/*---------------------------------------------------------------------------*\
**$Author: antanas $
**$Date: 2021-03-04 20:44:59 +0200 (Thu, 04 Mar 2021) $
**$Revision: 257 $
**$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/smiles-scripts/tags/v0.4.0/src/cdkcif2xyz.java $
\*---------------------------------------------------------------------------*/

// This CLI Java program reads a CIF (Crystallographic Information File,
// https://www.iucr.org/resources/cif) and converts it to the simple XYZ
// chemical format.

import org.openscience.cdk.ChemFile;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.io.CIFReader;

import javax.vecmath.Point3d;
import java.io.FileReader;
import java.util.Locale;

import static net.crystallography.helpers.cdk.OrthogonaliseAtomCoordinates.computeOrthogonalCoordinates;

@SuppressWarnings("ALL")
public class cdkcif2xyz {

    static OptionValue smilesOption = new OptionValue();
    static Option options[] = {
            new VersionOption ( null, "--version", OptionType.OT_FUNCTION ),
            new CDKCif2XyzHelp( null, "--help",    OptionType.OT_FUNCTION ),
    };

    private static final String progName = CDKCif2SmilesHelp.progName;

    @SuppressWarnings("SingleStatementInBlock")
    public static void main(String[] argv ) {
        String filenames[] = null;
        try {
            filenames = SOptions.get_options( argv, options );
        }
        catch (SOptionsException e) {
            System.err.println( progName + ": " + e.getMessage() );
            System.exit(1);
        }

        if( filenames == null || filenames.length == 0 ) {
            filenames = new String[] { "-" };
        }
        for( String filename : filenames ) {
            try {
                CIFReader reader;
                if (filename.equals("-")) {
                    reader = new CIFReader(System.in);
                } else {
                    reader = new CIFReader(new FileReader(filename));
                }

                ChemFile cifFile = reader.read(new ChemFile());

                assert cifFile != null;
                for ( IChemSequence sequence : cifFile.chemSequences() ) {
                    assert sequence.chemModels() != null;
                    for (IChemModel model : sequence.chemModels()) {
                        ICrystal crystal = model.getCrystal();
                        assert crystal != null : "Crystal is null";
                        computeOrthogonalCoordinates( crystal );
                        //------------------------------------------------------------
                        // Print out the chemical 'XYZ' format file:
                        System.out.println( crystal.getAtomCount() );
                        System.out.println( filename );
                        for( IAtom atom : crystal.atoms() ) {
                            String symbol = atom.getSymbol();
                            Point3d xyz = atom.getPoint3d();
                            System.out.printf( "%-2s ", symbol );
                            System.out.printf( Locale.ROOT, "%10.6g %10.6g %10.6g\n",
                                               xyz.x, xyz.y, xyz.z );
                        } // for
                    } // for
                } // for
            } // try
            catch(Exception e) {
                System.err.println( progName + ": " + "WARNING, " + e );
            }
        } // for
    }

}
