use anyhow::{Context, Result};
use std::fs;
use test_programs::nn::{sort_results, witx};

pub fn main() -> Result<()> {
    let model = fs::read("fixture/model.onnx")
        .context("the model file to be mapped to the fixture directory")?;
    let graph = witx::load(
        &[&model],
        witx::GraphEncoding::Onnx,
        witx::ExecutionTarget::CPU,
    )?;
    let tensor = fs::read("fixture/000000062808.rgb")
        .context("the tensor file to be mapped to the fixture directory")?;
    let results = witx::classify(graph, tensor)?;
    let top_five = &sort_results(&results)[..5];
    // 963 is "meat loaf, meatloaf."
    // https://github.com/onnx/models/blob/bec48b6a70e5e9042c0badbaafefe4454e072d08/validated/vision/classification/synset.txt#L963
    assert_eq!(top_five[0].class_id(), 963);
    println!("found results, sorted top 5: {top_five:?}");
    Ok(())
}
