% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratio.regression.R
\name{binregRatio}
\alias{binregRatio}
\alias{rmtlRatio}
\title{Percentage of years lost due to cause regression}
\usage{
binregRatio(
  formula,
  data,
  cause = 1,
  time = NULL,
  beta = NULL,
  type = c("II", "I"),
  offset = NULL,
  weights = NULL,
  cens.weights = NULL,
  cens.model = ~+1,
  se = TRUE,
  kaplan.meier = TRUE,
  cens.code = 0,
  no.opt = FALSE,
  method = "nr",
  augmentation = NULL,
  outcome = c("cif", "rmtl"),
  model = c("logit", "exp", "lin"),
  Ydirect = NULL,
  ...
)
}
\arguments{
\item{formula}{formula with outcome (see \code{coxph})}

\item{data}{data frame}

\item{cause}{cause of interest (numeric variable)}

\item{time}{time of interest}

\item{beta}{starting values}

\item{type}{"II" adds augmentation term, and "I" classical outcome IPCW regression}

\item{offset}{offsets for partial likelihood}

\item{weights}{for score equations}

\item{cens.weights}{censoring weights}

\item{cens.model}{only stratified cox model without covariates}

\item{se}{to compute se's  based on IPCW}

\item{kaplan.meier}{uses Kaplan-Meier for IPCW in contrast to exp(-Baseline)}

\item{cens.code}{gives censoring code}

\item{no.opt}{to not optimize}

\item{method}{for optimization}

\item{augmentation}{to augment binomial regression}

\item{outcome}{can do CIF regression "cif"=F(t|X), "rmtl"=E( t- min(T, t) | X)"}

\item{model}{logit, exp or lin(ear)}

\item{Ydirect}{use this Y instead of outcome constructed inside the program, should be a matrix with two column for numerator and denominator.}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Estimates the percentage of the years lost that is due to a cause and how covariates affects this percentage by doing ICPW regression.
}
\details{
Let the years lost be  \deqn{Y1= t- min(T ,) } and the years lost due to cause 1 \deqn{Y2= I(epsilon==1) ( t- min(T ,t) } , then
we model the ratio \deqn{logit( E(Y2 | X)/E(Y1 | X))  = X^T \beta }. Estimation is based on 
on binomial regresion IPCW response estimating equation: 
\deqn{ X ( \Delta^{ipcw}(t) Y2 expit(X^T \beta) -  Y1 ) = 0 }
where \deqn{\Delta^{ipcw}(t) = I((min(t,T)< C)/G_c(min(t,T)-)} is 
IPCW adjustment of the response \deqn{Y(t)= I(T \leq t, \epsilon=1 )}.  

(type="I") sovlves this estimating equation using a stratified Kaplan-Meier for the
censoring distribution. For (type="II") the default an additional 
censoring augmentation term \deqn{X \int E(Y(t)| T>s)/G_c(s) d \hat M_c} is added.

The variance is based on the squared influence functions that are also returned as the iid component. naive.var is variance 
under known censoring model. 

Censoring model may depend on strata (cens.model=~strata(gX)).
}
\examples{
library(mets)
data(bmt); bmt$time <- bmt$time+runif(408)*0.001

rmst30 <- rmstIPCW(Event(time,cause!=0)~platelet+tcell+age,bmt,time=30,cause=1)
rmst301 <- rmstIPCW(Event(time,cause)~platelet+tcell+age,bmt,time=30,cause=1)
rmst302 <- rmstIPCW(Event(time,cause)~platelet+tcell+age,bmt,time=30,cause=2)

estimate(rmst30)
estimate(rmst301)
estimate(rmst302)

## percentage of total cumulative incidence due to cause 1
rmtlratioI <- rmtlRatio(Event(time,cause)~platelet+tcell+age,bmt,time=30,cause=1)
summary(rmtlratioI)

pp <- predict(rmtlratioI,bmt[1:5,])
pp

newdata <- data.frame(platelet=1,tcell=1,age=1)
## percentage of total cumulative incidence due to cause 1
cifratio <- binregRatio(Event(time,cause)~platelet+tcell+age,bmt,time=30,cause=1)
summary(cifratio)
pp <- predict(cifratio,newdata)
pp

rmtlratioI <- binregRatio(Event(time,cause)~platelet+tcell+age,bmt,
                               time=30,cause=1,outcome="rmtl")
summary(rmtlratioI)

pp <- predict(rmtlratioI,newdata)
pp
}
\references{
Scheike & Tanaka (2025), Restricted mean time lost ratio regression: Percentage of restricted mean time lost due to specific cause, WIP
}
\author{
Thomas Scheike
}
