% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{mwNumeric}
\alias{mwNumeric}
\title{Add a numeric input to a manipulateWidget gadget}
\usage{
mwNumeric(value, label = NULL, ..., .display = TRUE)
}
\arguments{
\item{value}{Initial value of the numeric input.}

\item{label}{Display label for the control. If \code{NULL}, the name of the corresponding
variable is used.}

\item{...}{Other arguments passed to function\code{\link[shiny]{numericInput}}}

\item{.display}{expression that evaluates to TRUE or FALSE, indicating when
the input control should be shown/hidden.}
}
\value{
A function that will generate the input control.
}
\description{
Add a numeric input to a manipulateWidget gadget
}
\examples{

if (require(plotly)) {
  manipulateWidget({
      plot_ly(data.frame(x = 1:10, y = rnorm(10, mean, sd)), x=~x, y=~y,
              type = "scatter", mode = "markers")
    },
    mean = mwNumeric(0),
    sd = mwNumeric(1, min = 0, step = 0.1)
  )
}

}
\seealso{
Other controls: 
\code{\link{mwCheckboxGroup}()},
\code{\link{mwCheckbox}()},
\code{\link{mwDateRange}()},
\code{\link{mwDate}()},
\code{\link{mwGroup}()},
\code{\link{mwPassword}()},
\code{\link{mwRadio}()},
\code{\link{mwSelectize}()},
\code{\link{mwSelect}()},
\code{\link{mwSharedValue}()},
\code{\link{mwSlider}()},
\code{\link{mwText}()}
}
\concept{controls}
