# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservicesdatareplication import RecoveryServicesDataReplicationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestRecoveryServicesDataReplicationMgmtFabricOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(RecoveryServicesDataReplicationMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_get(self, resource_group):
        response = self.client.fabric.get(
            resource_group_name=resource_group.name,
            fabric_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_begin_create(self, resource_group):
        response = self.client.fabric.begin_create(
            resource_group_name=resource_group.name,
            fabric_name="str",
            resource={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "customProperties": "fabric_model_custom_properties",
                    "health": "str",
                    "healthErrors": [
                        {
                            "affectedResourceCorrelationIds": ["str"],
                            "affectedResourceType": "str",
                            "category": "str",
                            "causes": "str",
                            "childErrors": [
                                {
                                    "category": "str",
                                    "causes": "str",
                                    "code": "str",
                                    "creationTime": "2020-02-20 00:00:00",
                                    "healthCategory": "str",
                                    "isCustomerResolvable": bool,
                                    "message": "str",
                                    "recommendation": "str",
                                    "severity": "str",
                                    "source": "str",
                                    "summary": "str",
                                }
                            ],
                            "code": "str",
                            "creationTime": "2020-02-20 00:00:00",
                            "healthCategory": "str",
                            "isCustomerResolvable": bool,
                            "message": "str",
                            "recommendation": "str",
                            "severity": "str",
                            "source": "str",
                            "summary": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "serviceEndpoint": "str",
                    "serviceResourceId": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_begin_update(self, resource_group):
        response = self.client.fabric.begin_update(
            resource_group_name=resource_group.name,
            fabric_name="str",
            properties={
                "id": "str",
                "name": "str",
                "properties": {
                    "customProperties": "fabric_model_custom_properties",
                    "health": "str",
                    "healthErrors": [
                        {
                            "affectedResourceCorrelationIds": ["str"],
                            "affectedResourceType": "str",
                            "category": "str",
                            "causes": "str",
                            "childErrors": [
                                {
                                    "category": "str",
                                    "causes": "str",
                                    "code": "str",
                                    "creationTime": "2020-02-20 00:00:00",
                                    "healthCategory": "str",
                                    "isCustomerResolvable": bool,
                                    "message": "str",
                                    "recommendation": "str",
                                    "severity": "str",
                                    "source": "str",
                                    "summary": "str",
                                }
                            ],
                            "code": "str",
                            "creationTime": "2020-02-20 00:00:00",
                            "healthCategory": "str",
                            "isCustomerResolvable": bool,
                            "message": "str",
                            "recommendation": "str",
                            "severity": "str",
                            "source": "str",
                            "summary": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "serviceEndpoint": "str",
                    "serviceResourceId": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_begin_delete(self, resource_group):
        response = self.client.fabric.begin_delete(
            resource_group_name=resource_group.name,
            fabric_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_list(self, resource_group):
        response = self.client.fabric.list(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fabric_list_by_subscription(self, resource_group):
        response = self.client.fabric.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
