#import "@preview/lilaq:0.3.0" as lq
#import "@preview/tiptoe:0.3.0"


#let ion-colors = (
  y: color.red,
  b: color.blue,
  yp: color.red,
  ystar: color.red,
  "y*": color.red,
  yO: color.orange,
  x: color.orange,
  bstar: color.blue,
  "b*": color.blue,
  bO: rgb("#ff00ff"),
  a: color.green,
  astar: color.green,
  aO: color.green,
  c: color.blue,
  z: color.red,
  bp: color.blue
)

#let psm-ionlabel(name, size, charge) = [
  #let str_charge = ("", "+", "++", "+++")
  $#name _#size^#str_charge.at(charge)$
]

#let ms2spectra-delta-diagram = it => {
  show: lq.set-diagram(
    xlabel: [$m/z$],
    ylabel: [Mass delta (ppm)],
    legend: none,
    grid: none,
    xaxis: (mirror: none),
    yaxis: (mirror: none),
  )
  it
}

#let ms2spectra-diagram = it => {
  show: lq.set-diagram(
    xlabel: [$m/z$],
    ylabel: [Intensity],
    legend: none,
    grid: none,
    xaxis: (mirror: none),
    yaxis: (mirror: none),
  )
  it
}

#let ms2spectra-simple-plot(spectra) = {
    lq.stem(spectra.mz, spectra.intensity,
        color: black,
        base-stroke : none,
        mark: none)
}

#let ms2spectra-ion-plot(type, ion_arr) = {

        let mz_arr = ()
        let int_arr = ()
        for one_ion in ion_arr {
            mz_arr.push(one_ion.mz)
            int_arr.push(one_ion.intensity)
        }
        (
        lq.stem(mz_arr, int_arr, stroke: 1.1pt, base-stroke : none, color: ion-colors.at(type), mark:none, label: [#type])
        ,
        ion_arr.map((one_ion) => {
          let display = true
          if(("isotope" in one_ion)) {
             if (one_ion.isotope != 0) {
                display = false
             }
          }
          if(display) {
            let align = bottom
            lq.place(clip: true, one_ion.mz, one_ion.intensity, pad(bottom: 0.3em, left: 20%)[#text(ion-colors.at(type), size: 8pt)[#psm-ionlabel(type,one_ion.size, one_ion.charge)]], align: align)
            }
        })
        )
}


#let ms2spectra-delta-plot(delta_arr) = {
        delta_arr.map((delta) => {
          let level = 1em * delta.level + 1em
          (
          lq.line(
              tip: tiptoe.bar,
              toe: tiptoe.bar,
              stroke: (paint: ion-colors.at(delta.ion)),
              (delta.mz.at(0), level), (delta.mz.at(1), level)),
          lq.place(clip: true, (delta.mz.at(1)+delta.mz.at(0))/2, level,
              pad(bottom: 0.8em)[#text(ion-colors.at(delta.ion), size: 8pt)[#delta.label]]
          )
          )
        })
}



#let xic-plot(
  title: none,
  rt_range: auto,
  max_intensity: none,
  ..xic_json_list
) = {
    let ylimit = auto;
    if (max_intensity != none) {ylimit = (0, max_intensity)}
    
    lq.diagram(
    title: title,
    xlabel: [Retention time (s)], 
    ylabel: [Intensity],
    ylim: ylimit,
    xlim: rt_range,

    
    ..xic_json_list.pos().map((one_xic) => {
        let label = none
        if ("title" in one_xic) {label = one_xic.title}
        lq.plot(one_xic.x, one_xic.y, label: label)
    })
    )
}

#let ms2spectra-ion-delta-plot(type, ion_arr) = {
  let one_million = 1000000

        let mz_arr = ()
        let mz_delta_arr = ()
        for one_ion in ion_arr {
            mz_arr.push(one_ion.mz)
            mz_delta_arr.push((one_ion.mz - one_ion.mzth) / (one_ion.mz / one_million))
        }
        lq.scatter(mz_arr, mz_delta_arr, color: ion-colors.at(type))
}



#let ms2spectra-plot(
  title: none,
  mz_range: none,
  max_intensity: none,
  spectra: none,
  ion-series: none,
  delta: none,
  delta-fragments: false,
  psm_json_data
) = {
    let ylimit = auto;
    if (max_intensity != none) {ylimit = (0, max_intensity)}
    if(("delta" in psm_json_data)) {
      delta = psm_json_data.delta
    }
    if(("spectra" in psm_json_data)) {
      spectra = psm_json_data.spectra
    }
    if(("ion-series" in psm_json_data)) {
      ion-series = psm_json_data.ion-series
    }
    let mzpc = (spectra.mz.last() - spectra.mz.first()) / 100
    let inside_xlim = (spectra.mz.first()- 2*mzpc, spectra.mz.last()+ 2*mzpc)
    if (mz_range != none) {inside_xlim = mz_range}

    show: ms2spectra-diagram

    lq.diagram(
    title: title,
    xlim: inside_xlim,
    ylim: ylimit,
    
    if((spectra != none)) {ms2spectra-simple-plot(spectra)},
    
    ..if((ion-series != none)) {ion-series.pairs().map(((type, ion_arr)) => {
        ms2spectra-ion-plot(type, ion_arr)
        }).flatten()},
    
    ..if((delta != none)) {ms2spectra-delta-plot(delta).flatten()},
    
    if(delta-fragments) {
      lq.place(
      100%, 100%+2em, 
      align: right+top,
          lq.diagram(
            height: 1.5cm, 
            margin: 0%,
            ylabel: [delta ppm],
            ylim: (-10, 10),
            xlim: inside_xlim,
            xaxis: none,
          
          ..if((ion-series != none)) {ion-series.pairs().map(((type, ion_arr)) => {
              ms2spectra-ion-delta-plot(type, ion_arr)
              }).flatten()},
              
          lq.line(stroke: (paint: blue, dash: "dashed"),(0, 0), ( 100%,0))
        )
      )}
    )
}
