; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2024 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================
;
; RUN: igc_opt --igc-scalarize --opaque-pointers -S < %s | FileCheck %s
; REQUIRES: llvm-14-plus
; ------------------------------------------------
; ScalarizeFunction
; ------------------------------------------------
; The pass should break vector operation into many scalar operations
; ------------------------------------------------

define <2 x i32> @basic(<2 x i1> %switch, <2 x i32> %src1, <2 x i32> %src2) {
; CHECK-LABEL: define <2 x i32> @basic(
; CHECK-SAME: <2 x i1> [[SWITCH:%.*]], <2 x i32> [[SRC1:%.*]], <2 x i32> [[SRC2:%.*]]) {
; CHECK-NEXT:    [[SWITCH_SCALAR:%.*]] = extractelement <2 x i1> [[SWITCH]], i32 0
; CHECK-NEXT:    [[SWITCH_SCALAR3:%.*]] = extractelement <2 x i1> [[SWITCH]], i32 1
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x i32> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR2:%.*]] = extractelement <2 x i32> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    [[RESULT4:%.*]] = select i1 [[SWITCH_SCALAR]], i32 [[SRC1_SCALAR]], i32 [[SRC2_SCALAR]]
; CHECK-NEXT:    [[RESULT5:%.*]] = select i1 [[SWITCH_SCALAR3]], i32 [[SRC1_SCALAR1]], i32 [[SRC2_SCALAR2]]
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT:%.*]] = insertelement <2 x i32> undef, i32 [[RESULT4]], i32 0
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT6:%.*]] = insertelement <2 x i32> [[RESULT_ASSEMBLED_VECT]], i32 [[RESULT5]], i32 1
; CHECK-NEXT:    ret <2 x i32> [[RESULT_ASSEMBLED_VECT6]]
;
  %result = select <2 x i1> %switch, <2 x i32> %src1, <2 x i32> %src2
  ret <2 x i32> %result
}

define <2 x i32> @should_preserve_metadata(<2 x i1> %switch, <2 x i32> %src1, <2 x i32> %src2) {
; CHECK-LABEL: define <2 x i32> @should_preserve_metadata(
; CHECK-SAME: <2 x i1> [[SWITCH:%.*]], <2 x i32> [[SRC1:%.*]], <2 x i32> [[SRC2:%.*]]) {
; CHECK-NEXT:    [[SWITCH_SCALAR:%.*]] = extractelement <2 x i1> [[SWITCH]], i32 0
; CHECK-NEXT:    [[SWITCH_SCALAR3:%.*]] = extractelement <2 x i1> [[SWITCH]], i32 1
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x i32> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR2:%.*]] = extractelement <2 x i32> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    [[RESULT4:%.*]] = select i1 [[SWITCH_SCALAR]], i32 [[SRC1_SCALAR]], i32 [[SRC2_SCALAR]], !any_metadata [[META0:![0-9]+]]
; CHECK-NEXT:    [[RESULT5:%.*]] = select i1 [[SWITCH_SCALAR3]], i32 [[SRC1_SCALAR1]], i32 [[SRC2_SCALAR2]], !any_metadata [[META0]]
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT:%.*]] = insertelement <2 x i32> undef, i32 [[RESULT4]], i32 0
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT6:%.*]] = insertelement <2 x i32> [[RESULT_ASSEMBLED_VECT]], i32 [[RESULT5]], i32 1
; CHECK-NEXT:    ret <2 x i32> [[RESULT_ASSEMBLED_VECT6]]
;
  %result = select <2 x i1> %switch, <2 x i32> %src1, <2 x i32> %src2, !any_metadata !{i32 0}
  ret <2 x i32> %result
}

define <2 x float> @should_work_with_different_value_type(<2 x i1> %switch, <2 x float> %src1, <2 x float> %src2) {
; CHECK-LABEL: define <2 x float> @should_work_with_different_value_type(
; CHECK-SAME: <2 x i1> [[SWITCH:%.*]], <2 x float> [[SRC1:%.*]], <2 x float> [[SRC2:%.*]]) {
; CHECK-NEXT:    [[SWITCH_SCALAR:%.*]] = extractelement <2 x i1> [[SWITCH]], i32 0
; CHECK-NEXT:    [[SWITCH_SCALAR3:%.*]] = extractelement <2 x i1> [[SWITCH]], i32 1
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x float> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR2:%.*]] = extractelement <2 x float> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x float> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x float> [[SRC1]], i32 1
; CHECK-NEXT:    [[RESULT4:%.*]] = select i1 [[SWITCH_SCALAR]], float [[SRC1_SCALAR]], float [[SRC2_SCALAR]]
; CHECK-NEXT:    [[RESULT5:%.*]] = select i1 [[SWITCH_SCALAR3]], float [[SRC1_SCALAR1]], float [[SRC2_SCALAR2]]
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT:%.*]] = insertelement <2 x float> undef, float [[RESULT4]], i32 0
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT6:%.*]] = insertelement <2 x float> [[RESULT_ASSEMBLED_VECT]], float [[RESULT5]], i32 1
; CHECK-NEXT:    ret <2 x float> [[RESULT_ASSEMBLED_VECT6]]
;
  %result = select <2 x i1> %switch, <2 x float> %src1, <2 x float> %src2
  ret <2 x float> %result
}

define <2 x float> @should_work_with_fast_math_flags(<2 x i1> %switch, <2 x float> %src1, <2 x float> %src2) {
; CHECK-LABEL: define <2 x float> @should_work_with_fast_math_flags(
; CHECK-SAME: <2 x i1> [[SWITCH:%.*]], <2 x float> [[SRC1:%.*]], <2 x float> [[SRC2:%.*]]) {
; CHECK-NEXT:    [[SWITCH_SCALAR:%.*]] = extractelement <2 x i1> [[SWITCH]], i32 0
; CHECK-NEXT:    [[SWITCH_SCALAR3:%.*]] = extractelement <2 x i1> [[SWITCH]], i32 1
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x float> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR2:%.*]] = extractelement <2 x float> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x float> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x float> [[SRC1]], i32 1
; CHECK-NEXT:    [[RESULT4:%.*]] = select fast i1 [[SWITCH_SCALAR]], float [[SRC1_SCALAR]], float [[SRC2_SCALAR]]
; CHECK-NEXT:    [[RESULT5:%.*]] = select fast i1 [[SWITCH_SCALAR3]], float [[SRC1_SCALAR1]], float [[SRC2_SCALAR2]]
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT:%.*]] = insertelement <2 x float> undef, float [[RESULT4]], i32 0
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT6:%.*]] = insertelement <2 x float> [[RESULT_ASSEMBLED_VECT]], float [[RESULT5]], i32 1
; CHECK-NEXT:    ret <2 x float> [[RESULT_ASSEMBLED_VECT6]]
;
  %result = select fast <2 x i1> %switch, <2 x float> %src1, <2 x float> %src2
  ret <2 x float> %result
}

define <16 x i32> @should_work_with_larger_vector_size(<16 x i1> %switch, <16 x i32> %src1, <16 x i32> %src2) {
; CHECK-LABEL: define <16 x i32> @should_work_with_larger_vector_size(
; CHECK-SAME: <16 x i1> [[SWITCH:%.*]], <16 x i32> [[SRC1:%.*]], <16 x i32> [[SRC2:%.*]]) {
; CHECK-NEXT:    [[SWITCH_SCALAR:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 0
; CHECK-NEXT:    [[SWITCH_SCALAR31:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 1
; CHECK-NEXT:    [[SWITCH_SCALAR32:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 2
; CHECK-NEXT:    [[SWITCH_SCALAR33:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 3
; CHECK-NEXT:    [[SWITCH_SCALAR34:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 4
; CHECK-NEXT:    [[SWITCH_SCALAR35:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 5
; CHECK-NEXT:    [[SWITCH_SCALAR36:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 6
; CHECK-NEXT:    [[SWITCH_SCALAR37:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 7
; CHECK-NEXT:    [[SWITCH_SCALAR38:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 8
; CHECK-NEXT:    [[SWITCH_SCALAR39:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 9
; CHECK-NEXT:    [[SWITCH_SCALAR40:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 10
; CHECK-NEXT:    [[SWITCH_SCALAR41:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 11
; CHECK-NEXT:    [[SWITCH_SCALAR42:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 12
; CHECK-NEXT:    [[SWITCH_SCALAR43:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 13
; CHECK-NEXT:    [[SWITCH_SCALAR44:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 14
; CHECK-NEXT:    [[SWITCH_SCALAR45:%.*]] = extractelement <16 x i1> [[SWITCH]], i32 15
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <16 x i32> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR16:%.*]] = extractelement <16 x i32> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC2_SCALAR17:%.*]] = extractelement <16 x i32> [[SRC2]], i32 2
; CHECK-NEXT:    [[SRC2_SCALAR18:%.*]] = extractelement <16 x i32> [[SRC2]], i32 3
; CHECK-NEXT:    [[SRC2_SCALAR19:%.*]] = extractelement <16 x i32> [[SRC2]], i32 4
; CHECK-NEXT:    [[SRC2_SCALAR20:%.*]] = extractelement <16 x i32> [[SRC2]], i32 5
; CHECK-NEXT:    [[SRC2_SCALAR21:%.*]] = extractelement <16 x i32> [[SRC2]], i32 6
; CHECK-NEXT:    [[SRC2_SCALAR22:%.*]] = extractelement <16 x i32> [[SRC2]], i32 7
; CHECK-NEXT:    [[SRC2_SCALAR23:%.*]] = extractelement <16 x i32> [[SRC2]], i32 8
; CHECK-NEXT:    [[SRC2_SCALAR24:%.*]] = extractelement <16 x i32> [[SRC2]], i32 9
; CHECK-NEXT:    [[SRC2_SCALAR25:%.*]] = extractelement <16 x i32> [[SRC2]], i32 10
; CHECK-NEXT:    [[SRC2_SCALAR26:%.*]] = extractelement <16 x i32> [[SRC2]], i32 11
; CHECK-NEXT:    [[SRC2_SCALAR27:%.*]] = extractelement <16 x i32> [[SRC2]], i32 12
; CHECK-NEXT:    [[SRC2_SCALAR28:%.*]] = extractelement <16 x i32> [[SRC2]], i32 13
; CHECK-NEXT:    [[SRC2_SCALAR29:%.*]] = extractelement <16 x i32> [[SRC2]], i32 14
; CHECK-NEXT:    [[SRC2_SCALAR30:%.*]] = extractelement <16 x i32> [[SRC2]], i32 15
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <16 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <16 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR2:%.*]] = extractelement <16 x i32> [[SRC1]], i32 2
; CHECK-NEXT:    [[SRC1_SCALAR3:%.*]] = extractelement <16 x i32> [[SRC1]], i32 3
; CHECK-NEXT:    [[SRC1_SCALAR4:%.*]] = extractelement <16 x i32> [[SRC1]], i32 4
; CHECK-NEXT:    [[SRC1_SCALAR5:%.*]] = extractelement <16 x i32> [[SRC1]], i32 5
; CHECK-NEXT:    [[SRC1_SCALAR6:%.*]] = extractelement <16 x i32> [[SRC1]], i32 6
; CHECK-NEXT:    [[SRC1_SCALAR7:%.*]] = extractelement <16 x i32> [[SRC1]], i32 7
; CHECK-NEXT:    [[SRC1_SCALAR8:%.*]] = extractelement <16 x i32> [[SRC1]], i32 8
; CHECK-NEXT:    [[SRC1_SCALAR9:%.*]] = extractelement <16 x i32> [[SRC1]], i32 9
; CHECK-NEXT:    [[SRC1_SCALAR10:%.*]] = extractelement <16 x i32> [[SRC1]], i32 10
; CHECK-NEXT:    [[SRC1_SCALAR11:%.*]] = extractelement <16 x i32> [[SRC1]], i32 11
; CHECK-NEXT:    [[SRC1_SCALAR12:%.*]] = extractelement <16 x i32> [[SRC1]], i32 12
; CHECK-NEXT:    [[SRC1_SCALAR13:%.*]] = extractelement <16 x i32> [[SRC1]], i32 13
; CHECK-NEXT:    [[SRC1_SCALAR14:%.*]] = extractelement <16 x i32> [[SRC1]], i32 14
; CHECK-NEXT:    [[SRC1_SCALAR15:%.*]] = extractelement <16 x i32> [[SRC1]], i32 15
; CHECK-NEXT:    [[RESULT46:%.*]] = select i1 [[SWITCH_SCALAR]], i32 [[SRC1_SCALAR]], i32 [[SRC2_SCALAR]]
; CHECK-NEXT:    [[RESULT47:%.*]] = select i1 [[SWITCH_SCALAR31]], i32 [[SRC1_SCALAR1]], i32 [[SRC2_SCALAR16]]
; CHECK-NEXT:    [[RESULT48:%.*]] = select i1 [[SWITCH_SCALAR32]], i32 [[SRC1_SCALAR2]], i32 [[SRC2_SCALAR17]]
; CHECK-NEXT:    [[RESULT49:%.*]] = select i1 [[SWITCH_SCALAR33]], i32 [[SRC1_SCALAR3]], i32 [[SRC2_SCALAR18]]
; CHECK-NEXT:    [[RESULT50:%.*]] = select i1 [[SWITCH_SCALAR34]], i32 [[SRC1_SCALAR4]], i32 [[SRC2_SCALAR19]]
; CHECK-NEXT:    [[RESULT51:%.*]] = select i1 [[SWITCH_SCALAR35]], i32 [[SRC1_SCALAR5]], i32 [[SRC2_SCALAR20]]
; CHECK-NEXT:    [[RESULT52:%.*]] = select i1 [[SWITCH_SCALAR36]], i32 [[SRC1_SCALAR6]], i32 [[SRC2_SCALAR21]]
; CHECK-NEXT:    [[RESULT53:%.*]] = select i1 [[SWITCH_SCALAR37]], i32 [[SRC1_SCALAR7]], i32 [[SRC2_SCALAR22]]
; CHECK-NEXT:    [[RESULT54:%.*]] = select i1 [[SWITCH_SCALAR38]], i32 [[SRC1_SCALAR8]], i32 [[SRC2_SCALAR23]]
; CHECK-NEXT:    [[RESULT55:%.*]] = select i1 [[SWITCH_SCALAR39]], i32 [[SRC1_SCALAR9]], i32 [[SRC2_SCALAR24]]
; CHECK-NEXT:    [[RESULT56:%.*]] = select i1 [[SWITCH_SCALAR40]], i32 [[SRC1_SCALAR10]], i32 [[SRC2_SCALAR25]]
; CHECK-NEXT:    [[RESULT57:%.*]] = select i1 [[SWITCH_SCALAR41]], i32 [[SRC1_SCALAR11]], i32 [[SRC2_SCALAR26]]
; CHECK-NEXT:    [[RESULT58:%.*]] = select i1 [[SWITCH_SCALAR42]], i32 [[SRC1_SCALAR12]], i32 [[SRC2_SCALAR27]]
; CHECK-NEXT:    [[RESULT59:%.*]] = select i1 [[SWITCH_SCALAR43]], i32 [[SRC1_SCALAR13]], i32 [[SRC2_SCALAR28]]
; CHECK-NEXT:    [[RESULT60:%.*]] = select i1 [[SWITCH_SCALAR44]], i32 [[SRC1_SCALAR14]], i32 [[SRC2_SCALAR29]]
; CHECK-NEXT:    [[RESULT61:%.*]] = select i1 [[SWITCH_SCALAR45]], i32 [[SRC1_SCALAR15]], i32 [[SRC2_SCALAR30]]
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT:%.*]] = insertelement <16 x i32> undef, i32 [[RESULT46]], i32 0
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT62:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT]], i32 [[RESULT47]], i32 1
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT63:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT62]], i32 [[RESULT48]], i32 2
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT64:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT63]], i32 [[RESULT49]], i32 3
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT65:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT64]], i32 [[RESULT50]], i32 4
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT66:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT65]], i32 [[RESULT51]], i32 5
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT67:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT66]], i32 [[RESULT52]], i32 6
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT68:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT67]], i32 [[RESULT53]], i32 7
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT69:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT68]], i32 [[RESULT54]], i32 8
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT70:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT69]], i32 [[RESULT55]], i32 9
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT71:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT70]], i32 [[RESULT56]], i32 10
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT72:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT71]], i32 [[RESULT57]], i32 11
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT73:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT72]], i32 [[RESULT58]], i32 12
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT74:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT73]], i32 [[RESULT59]], i32 13
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT75:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT74]], i32 [[RESULT60]], i32 14
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT76:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT75]], i32 [[RESULT61]], i32 15
; CHECK-NEXT:    ret <16 x i32> [[RESULT_ASSEMBLED_VECT76]]
;
  %result = select <16 x i1> %switch, <16 x i32> %src1, <16 x i32> %src2
  ret <16 x i32> %result
}

define <2 x i32> @should_work_with_constant_value(<2 x i1> %switch, <2 x i32> %src1) {
; CHECK-LABEL: define <2 x i32> @should_work_with_constant_value(
; CHECK-SAME: <2 x i1> [[SWITCH:%.*]], <2 x i32> [[SRC1:%.*]]) {
; CHECK-NEXT:    [[SWITCH_SCALAR:%.*]] = extractelement <2 x i1> [[SWITCH]], i32 0
; CHECK-NEXT:    [[SWITCH_SCALAR2:%.*]] = extractelement <2 x i1> [[SWITCH]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    [[RESULT3:%.*]] = select i1 [[SWITCH_SCALAR]], i32 [[SRC1_SCALAR]], i32 2
; CHECK-NEXT:    [[RESULT4:%.*]] = select i1 [[SWITCH_SCALAR2]], i32 [[SRC1_SCALAR1]], i32 4
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT:%.*]] = insertelement <2 x i32> undef, i32 [[RESULT3]], i32 0
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT5:%.*]] = insertelement <2 x i32> [[RESULT_ASSEMBLED_VECT]], i32 [[RESULT4]], i32 1
; CHECK-NEXT:    ret <2 x i32> [[RESULT_ASSEMBLED_VECT5]]
;
  %result = select <2 x i1> %switch, <2 x i32> %src1, <2 x i32> <i32 2, i32 4>
  ret <2 x i32> %result
}

define <2 x i32> @should_work_with_non_vector_condition(i1 %switch, <2 x i32> %src1, <2 x i32> %src2) {
; CHECK-LABEL: define <2 x i32> @should_work_with_non_vector_condition(
; CHECK-SAME: i1 [[SWITCH:%.*]], <2 x i32> [[SRC1:%.*]], <2 x i32> [[SRC2:%.*]]) {
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x i32> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR2:%.*]] = extractelement <2 x i32> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    [[RESULT3:%.*]] = select i1 [[SWITCH]], i32 [[SRC1_SCALAR]], i32 [[SRC2_SCALAR]]
; CHECK-NEXT:    [[RESULT4:%.*]] = select i1 [[SWITCH]], i32 [[SRC1_SCALAR1]], i32 [[SRC2_SCALAR2]]
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT:%.*]] = insertelement <2 x i32> undef, i32 [[RESULT3]], i32 0
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT5:%.*]] = insertelement <2 x i32> [[RESULT_ASSEMBLED_VECT]], i32 [[RESULT4]], i32 1
; CHECK-NEXT:    ret <2 x i32> [[RESULT_ASSEMBLED_VECT5]]
;
  %result = select i1 %switch, <2 x i32> %src1, <2 x i32> %src2
  ret <2 x i32> %result
}

define <2 x i32> @should_not_select_from_the_same_value(<2 x i1> %switch, <2 x i32> %src1) {
; CHECK-LABEL: define <2 x i32> @should_not_select_from_the_same_value(
; CHECK-SAME: <2 x i1> [[SWITCH:%.*]], <2 x i32> [[SRC1:%.*]]) {
; CHECK-NEXT:    [[SWITCH_SCALAR:%.*]] = extractelement <2 x i1> [[SWITCH]], i32 0
; CHECK-NEXT:    [[SWITCH_SCALAR2:%.*]] = extractelement <2 x i1> [[SWITCH]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT:%.*]] = insertelement <2 x i32> undef, i32 [[SRC1_SCALAR]], i32 0
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT3:%.*]] = insertelement <2 x i32> [[RESULT_ASSEMBLED_VECT]], i32 [[SRC1_SCALAR1]], i32 1
; CHECK-NEXT:    ret <2 x i32> [[RESULT_ASSEMBLED_VECT3]]
;
  %result = select <2 x i1> %switch, <2 x i32> %src1, <2 x i32> %src1
  ret <2 x i32> %result
}

define i32 @should_not_scalarize_scalar(i1 %switch, i32 %src1, i32 %src2) {
; CHECK-LABEL: define i32 @should_not_scalarize_scalar(
; CHECK-SAME: i1 [[SWITCH:%.*]], i32 [[SRC1:%.*]], i32 [[SRC2:%.*]]) {
; CHECK-NEXT:    [[RESULT:%.*]] = select i1 [[SWITCH]], i32 [[SRC1]], i32 [[SRC2]]
; CHECK-NEXT:    ret i32 [[RESULT]]
;
  %result = select i1 %switch, i32 %src1, i32 %src2
  ret i32 %result
}

; CHECK: [[META0]] = !{i32 0}