/* Check that vec_sel absorbs a negation generated by vec_cmpge.  */

/* { dg-do compile } */
/* { dg-options "-O3 -mzarch -march=z13" } */

typedef __attribute__((vector_size(16))) unsigned char uv16qi;

#include <vecintrin.h>

void f(char *res, uv16qi ctrl)
{
  uv16qi a = vec_splat_u8(0xfe);
  uv16qi b = vec_splat_u8(0x80);
  uv16qi mask = vec_cmpge(ctrl, b);
  *(uv16qi *)res = vec_sel(a, b, mask);
}

/* { dg-final { scan-assembler-not "vno\t" } } */
