# Atkinson Hyperlegible Next

[![][Fontbakery]](https://googlefonts.github.io/atkinson-hyperlegible-next/fontbakery/fontbakery-report.html)
[![][Universal]](https://googlefonts.github.io/atkinson-hyperlegible-next/fontbakery/fontbakery-report.html)
[![][Font File]](https://googlefonts.github.io/atkinson-hyperlegible-next/fontbakery/fontbakery-report.html)

[Fontbakery]: https://img.shields.io/endpoint?url=https%3A%2F%2Fraw.githubusercontent.com%2Fgooglefonts%2Fatkinson-hyperlegible-next%2Fgh-pages%2Fbadges%2Foverall.json
[Font File]: https://img.shields.io/endpoint?url=https%3A%2F%2Fraw.githubusercontent.com%2Fgooglefonts%2Fatkinson-hyperlegible-next%2Fgh-pages%2Fbadges%2FFontFileChecks.json
[Universal]: https://img.shields.io/endpoint?url=https%3A%2F%2Fraw.githubusercontent.com%2Fgooglefonts%2Fatkinson-hyperlegible-next%2Fgh-pages%2Fbadges%2FUniversalProfileChecks.json

Atkinson Hyperlegible, named after the founder of the Braille Institute, has been developed specifically to increase legibility for readers with low vision, and to improve comprehension.

Having a traditional grotesque sans-serif at its core, it departs from tradition to incorporate unambiguous, distinctive elements—and at times, unexpected forms—always with the goal of increasing character recognition and ultimately improve reading.

Atkinson Hyperlegible Next is an improvement of the typeface Atkinson Hyperlegible, including new characters, improved glyphs, and improved kerning. Additionally, the two previous weights has increased to six, all in upright and italic, allowing for greater flexibility in use. 


![Sample Image](documentation/image1.png)

## About

Braille Institute is a nonprofit organization that has been positively transforming the lives of those with sight loss for more than 100 years. All programs and services are free of charge, and available through seven Southern California centers, as well as remotely by phone or computer.

## Building

Fonts are built automatically by GitHub Actions - take a look in the "Actions" tab for the latest build.

If you want to build fonts manually on your own computer:

* `make build` will produce font files.
* `make test` will run [FontBakery](https://github.com/googlefonts/fontbakery)'s quality assurance tests.
* `make proof` will generate HTML proof files.

The proof files and QA tests are also available automatically via GitHub Actions - look at `https://yourname.github.io/your-font-repository-name`.

## Changelog

**20 November 2024. Version 2.001**
- First release. (Font engineering & QA: Emma Marichal)

## License

This Font Software is licensed under the SIL Open Font License, Version 1.1.
This license is available with a FAQ at
https://openfontlicense.org

## Repository Layout

This font repository structure is inspired by [Unified Font Repository v0.3](https://github.com/unified-font-repository/Unified-Font-Repository), modified for the Google Fonts workflow.
