#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return "No Description found"

    def run(self):
        if not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "keyboard", "charDeleteEcho"
        ):
            return
        # detect typing or chilling
        if (
            self.env["screen"]["new_cursor"]["x"]
            >= self.env["screen"]["old_cursor"]["x"]
        ):
            return

        # More than just a deletion happend
        if self.env["runtime"]["ScreenManager"].is_delta(ignoreSpace=True):
            return

        # no deletion
        if not self.env["runtime"]["ScreenManager"].is_negative_delta():
            return

        # too much for a single backspace...
        # word begin produce a diff wiht len == 2 |a | others with 1 |a|
        if len(self.env["screen"]["newNegativeDelta"]) > 2:
            return

        curr_negative_delta = self.env["screen"]["newNegativeDelta"]
        if (
            len(curr_negative_delta.strip()) != len(curr_negative_delta)
            and curr_negative_delta.strip() != ""
        ):
            curr_negative_delta = curr_negative_delta.strip()
        self.env["runtime"]["OutputManager"].present_text(
            curr_negative_delta,
            interrupt=True,
            ignore_punctuation=True,
            announce_capital=True,
            flush=False,
        )

    def set_callback(self, callback):
        pass
