/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __lr10_dev_route_ip_h__
#define __lr10_dev_route_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_ADDRESS                 0x00005488      /* RW-4R */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_ADDRESS_ERROR_ADDRESS   8:0             /* RWIVF */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_ADDRESS_ERROR_ADDRESS_INIT 0x00000000   /* RWI-V */

#define NV_ROUTE_ERR_GLT_ECC_ERROR_ADDRESS_VALID           0x0000548c      /* R--4R */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_ADDRESS_VALID_VALID     0:0             /* R-DVF */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_ADDRESS_VALID_VALID_INVALID 0x00000000  /* R-D-V */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_ADDRESS_VALID_VALID_VALID 0x00000001    /* R---V */

#define NV_ROUTE_ERR_LOG_EN_0                              0x00005404      /* RW-4R */
#define NV_ROUTE_ERR_LOG_EN_0_ROUTEBUFERR                  0:0             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_ROUTEBUFERR__PROD            0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_ROUTEBUFERR_DISABLE          0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_ROUTEBUFERR_ENABLE           0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_NOPORTDEFINEDERR             1:1             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_NOPORTDEFINEDERR__PROD       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_NOPORTDEFINEDERR_DISABLE     0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_NOPORTDEFINEDERR_ENABLE      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_INVALIDROUTEPOLICYERR        2:2             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_INVALIDROUTEPOLICYERR__PROD  0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_INVALIDROUTEPOLICYERR_DISABLE 0x00000000     /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_INVALIDROUTEPOLICYERR_ENABLE 0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_LIMIT_ERR            3:3             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_LIMIT_ERR__PROD      0x00000000      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_LIMIT_ERR_DISABLE    0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_LIMIT_ERR_ENABLE     0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_DBE_ERR              4:4             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_DBE_ERR__PROD        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_DBE_ERR_DISABLE      0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_DBE_ERR_ENABLE       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_TRANSDONERESVERR             5:5             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_TRANSDONERESVERR__PROD       0x00000000      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_TRANSDONERESVERR_DISABLE     0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_TRANSDONERESVERR_ENABLE      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_PDCTRLPARERR                 6:6             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_PDCTRLPARERR__PROD           0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_PDCTRLPARERR_DISABLE         0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_PDCTRLPARERR_ENABLE          0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_LIMIT_ERR            7:7             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_LIMIT_ERR__PROD      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_LIMIT_ERR_DISABLE    0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_LIMIT_ERR_ENABLE     0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_DBE_ERR              8:8             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_DBE_ERR__PROD        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_DBE_ERR_DISABLE      0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_DBE_ERR_ENABLE       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_CDTPARERR                    9:9             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_CDTPARERR__PROD              0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_CDTPARERR_DISABLE            0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_CDTPARERR_ENABLE             0x00000001      /* RW--V */

#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0               0x00005410      /* RW-4R */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_ROUTEBUFERR   0:0             /* RWEVF */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_ROUTEBUFERR__PROD 0x00000000  /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_ROUTEBUFERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_ROUTEBUFERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_NOPORTDEFINEDERR 1:1          /* RWEVF */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_NOPORTDEFINEDERR__PROD 0x00000000 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_NOPORTDEFINEDERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_NOPORTDEFINEDERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_INVALIDROUTEPOLICYERR 2:2     /* RWEVF */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_INVALIDROUTEPOLICYERR__PROD 0x00000000 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_INVALIDROUTEPOLICYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_INVALIDROUTEPOLICYERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_GLT_ECC_LIMIT_ERR 3:3         /* RWEVF */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_GLT_ECC_LIMIT_ERR__PROD 0x00000000 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_GLT_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_GLT_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_GLT_ECC_DBE_ERR 4:4           /* RWEVF */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_GLT_ECC_DBE_ERR__PROD 0x00000000 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_GLT_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_GLT_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_TRANSDONERESVERR 5:5          /* RWEVF */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_TRANSDONERESVERR__PROD 0x00000000 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_TRANSDONERESVERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_TRANSDONERESVERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_PDCTRLPARERR  6:6             /* RWEVF */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_PDCTRLPARERR__PROD 0x00000000 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_PDCTRLPARERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_PDCTRLPARERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_NVS_ECC_LIMIT_ERR 7:7         /* RWEVF */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_NVS_ECC_LIMIT_ERR__PROD 0x00000000 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_NVS_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_NVS_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_NVS_ECC_DBE_ERR 8:8           /* RWEVF */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_NVS_ECC_DBE_ERR__PROD 0x00000000 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_NVS_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_NVS_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_CDTPARERR     9:9             /* RWEVF */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_CDTPARERR__PROD 0x00000000    /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_CDTPARERR_DISABLE 0x00000000  /* RWE-V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0_CDTPARERR_ENABLE 0x00000001   /* RW--V */

#define NV_ROUTE_ERR_TIMESTAMP_LOG                         0x00005450      /* R--4R */
#define NV_ROUTE_ERR_TIMESTAMP_LOG_TIMESTAMP               23:0            /* R-IVF */
#define NV_ROUTE_ERR_TIMESTAMP_LOG_TIMESTAMP_INIT          0x00000000      /* R-I-V */

#define NV_ROUTE_ERR_HEADER_LOG_VALID                      0x0000544c      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_VALID_HEADERVALID0         0:0             /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_VALID_HEADERVALID0_INVALID 0x00000000      /* R-D-V */
#define NV_ROUTE_ERR_HEADER_LOG_VALID_HEADERVALID0_VALID   0x00000001      /* R---V */

#define NV_ROUTE_ERR_MISC_LOG_0                            0x00005454      /* R--4R */
#define NV_ROUTE_ERR_MISC_LOG_0_SPORT                      5:0             /* R-IVF */
#define NV_ROUTE_ERR_MISC_LOG_0_SPORT_INIT                 0x00000000      /* R-I-V */
#define NV_ROUTE_ERR_MISC_LOG_0_ENCODEDVC                  10:8            /* R-IVF */
#define NV_ROUTE_ERR_MISC_LOG_0_ENCODEDVC_INIT             0x00000000      /* R-I-V */

#define NV_ROUTE_ERR_HEADER_LOG_0                          0x00005420      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_0_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_0_DW_INIT                  0x00000000      /* R-D-V */

#define NV_ROUTE_ERR_HEADER_LOG_1                          0x00005424      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_1_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_1_DW_INIT                  0x00000000      /* R-D-V */

#define NV_ROUTE_ERR_HEADER_LOG_2                          0x00005428      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_2_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_2_DW_INIT                  0x00000000      /* R-D-V */

#define NV_ROUTE_ERR_HEADER_LOG_3                          0x0000542c      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_3_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_3_DW_INIT                  0x00000000      /* R-D-V */

#define NV_ROUTE_ERR_HEADER_LOG_4                          0x00005430      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_4_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_4_DW_INIT                  0x00000000      /* R-D-V */

#define NV_ROUTE_ERR_HEADER_LOG_5                          0x00005434      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_5_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_5_DW_INIT                  0x00000000      /* R-D-V */

#define NV_ROUTE_ERR_HEADER_LOG_6                          0x00005438      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_6_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_6_DW_INIT                  0x00000000      /* R-D-V */

#define NV_ROUTE_ERR_HEADER_LOG_7                          0x0000543c      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_7_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_7_DW_INIT                  0x00000000      /* R-D-V */

#define NV_ROUTE_ERR_HEADER_LOG_8                          0x00005440      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_8_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_8_DW_INIT                  0x00000000      /* R-D-V */

#define NV_ROUTE_ERR_HEADER_LOG_9                          0x00005444      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_9_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_9_DW_INIT                  0x00000000      /* R-D-V */

#define NV_ROUTE_ERR_HEADER_LOG_10                         0x00005448      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_10_DW                      31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_10_DW_INIT                 0x00000000      /* R-D-V */

#define NV_ROUTE_ERR_STATUS_0                              0x00005400      /* RW-4R */
#define NV_ROUTE_ERR_STATUS_0_ROUTEBUFERR                  0:0             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_ROUTEBUFERR_NONE             0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_ROUTEBUFERR_CLEAR            0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_NOPORTDEFINEDERR             1:1             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_NOPORTDEFINEDERR_NONE        0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_NOPORTDEFINEDERR_CLEAR       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_INVALIDROUTEPOLICYERR        2:2             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_INVALIDROUTEPOLICYERR_NONE   0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_INVALIDROUTEPOLICYERR_CLEAR  0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_GLT_ECC_LIMIT_ERR            3:3             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_GLT_ECC_LIMIT_ERR_NONE       0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_GLT_ECC_LIMIT_ERR_CLEAR      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_GLT_ECC_DBE_ERR              4:4             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_GLT_ECC_DBE_ERR_NONE         0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_GLT_ECC_DBE_ERR_CLEAR        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_TRANSDONERESVERR             5:5             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_TRANSDONERESVERR_NONE        0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_TRANSDONERESVERR_CLEAR       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_PDCTRLPARERR                 6:6             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_PDCTRLPARERR_NONE            0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_PDCTRLPARERR_CLEAR           0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_NVS_ECC_LIMIT_ERR            7:7             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_NVS_ECC_LIMIT_ERR_NONE       0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_NVS_ECC_LIMIT_ERR_CLEAR      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_NVS_ECC_DBE_ERR              8:8             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_NVS_ECC_DBE_ERR_NONE         0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_NVS_ECC_DBE_ERR_CLEAR        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_CDTPARERR                    9:9             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_CDTPARERR_NONE               0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_CDTPARERR_CLEAR              0x00000001      /* RW--V */

#define NV_ROUTE_ERR_FIRST_0                               0x0000541c      /* RW-4R */
#define NV_ROUTE_ERR_FIRST_0_ROUTEBUFERR                   0:0             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_ROUTEBUFERR_NONE              0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_ROUTEBUFERR_CLEAR             0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_NOPORTDEFINEDERR              1:1             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_NOPORTDEFINEDERR_NONE         0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_NOPORTDEFINEDERR_CLEAR        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_INVALIDROUTEPOLICYERR         2:2             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_INVALIDROUTEPOLICYERR_NONE    0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_INVALIDROUTEPOLICYERR_CLEAR   0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_GLT_ECC_LIMIT_ERR             3:3             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_GLT_ECC_LIMIT_ERR_NONE        0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_GLT_ECC_LIMIT_ERR_CLEAR       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_GLT_ECC_DBE_ERR               4:4             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_GLT_ECC_DBE_ERR_NONE          0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_GLT_ECC_DBE_ERR_CLEAR         0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_TRANSDONERESVERR              5:5             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_TRANSDONERESVERR_NONE         0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_TRANSDONERESVERR_CLEAR        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_PDCTRLPARERR                  6:6             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_PDCTRLPARERR_NONE             0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_PDCTRLPARERR_CLEAR            0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_NVS_ECC_LIMIT_ERR             7:7             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_NVS_ECC_LIMIT_ERR_NONE        0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_NVS_ECC_LIMIT_ERR_CLEAR       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_NVS_ECC_DBE_ERR               8:8             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_NVS_ECC_DBE_ERR_NONE          0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_NVS_ECC_DBE_ERR_CLEAR         0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_CDTPARERR                     9:9             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_CDTPARERR_NONE                0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_CDTPARERR_CLEAR               0x00000001      /* RW--V */

#define NV_ROUTE_ERR_CONTAIN_EN_0                          0x00005414      /* RW-4R */
#define NV_ROUTE_ERR_CONTAIN_EN_0_ROUTEBUFERR              0:0             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_ROUTEBUFERR__PROD        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_ROUTEBUFERR_DISABLE      0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_ROUTEBUFERR_ENABLE       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NOPORTDEFINEDERR         1:1             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NOPORTDEFINEDERR__PROD   0x00000000      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NOPORTDEFINEDERR_DISABLE 0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NOPORTDEFINEDERR_ENABLE  0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_INVALIDROUTEPOLICYERR    2:2             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_INVALIDROUTEPOLICYERR__PROD 0x00000000   /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_INVALIDROUTEPOLICYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_INVALIDROUTEPOLICYERR_ENABLE 0x00000001  /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_LIMIT_ERR        3:3             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_LIMIT_ERR__PROD  0x00000000      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_LIMIT_ERR_DISABLE 0x00000000     /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_LIMIT_ERR_ENABLE 0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_DBE_ERR          4:4             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_DBE_ERR__PROD    0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_DBE_ERR_DISABLE  0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_DBE_ERR_ENABLE   0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_TRANSDONERESVERR         5:5             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_TRANSDONERESVERR__PROD   0x00000000      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_TRANSDONERESVERR_DISABLE 0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_TRANSDONERESVERR_ENABLE  0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_PDCTRLPARERR             6:6             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_PDCTRLPARERR__PROD       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_PDCTRLPARERR_DISABLE     0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_PDCTRLPARERR_ENABLE      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_LIMIT_ERR        7:7             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_LIMIT_ERR__PROD  0x00000000      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_LIMIT_ERR_DISABLE 0x00000000     /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_LIMIT_ERR_ENABLE 0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_DBE_ERR          8:8             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_DBE_ERR__PROD    0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_DBE_ERR_DISABLE  0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_DBE_ERR_ENABLE   0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_CDTPARERR                9:9             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_CDTPARERR__PROD          0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_CDTPARERR_DISABLE        0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_CDTPARERR_ENABLE         0x00000001      /* RW--V */

#define NV_ROUTE_REG_TABLE_ADDRESS                         0x00005080      /* RW-4R */
#define NV_ROUTE_REG_TABLE_ADDRESS_INDEX                   8:0             /* RWEVF */
#define NV_ROUTE_REG_TABLE_ADDRESS_INDEX_MIN               0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_ADDRESS_INDEX_GLTAB_DEPTH       0x000001ff      /* RW--V */
#define NV_ROUTE_REG_TABLE_ADDRESS_AUTO_INCR               31:31           /* RWEVF */
#define NV_ROUTE_REG_TABLE_ADDRESS_AUTO_INCR_DISABLE       0x00000000      /* RW--V */
#define NV_ROUTE_REG_TABLE_ADDRESS_AUTO_INCR_ENABLE        0x00000001      /* RWE-V */

#define NV_ROUTE_REG_TABLE_DATA0                           0x00005090      /* RW-4R */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_0                     3:0             /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_0_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_1                     7:4             /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_1_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_2                     11:8            /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_2_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_3                     15:12           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_3_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_4                     19:16           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_4_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_5                     23:20           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_5_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_6                     27:24           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_6_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_7                     31:28           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_7_INIT                0x00000000      /* RWE-V */

#define NV_ROUTE_ERR_NVS_ECC_ERROR_COUNTER                 0x00005490      /* RW-4R */
#define NV_ROUTE_ERR_NVS_ECC_ERROR_COUNTER_ERROR_COUNT     23:0            /* RWIVF */
#define NV_ROUTE_ERR_NVS_ECC_ERROR_COUNTER_ERROR_COUNT_INIT 0x00000000     /* RWI-V */

#define NV_ROUTE_ERR_NVS_ECC_ERROR_COUNTER_LIMIT           0x00005494      /* RW-4R */
#define NV_ROUTE_ERR_NVS_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT 23:0          /* RWEVF */
#define NV_ROUTE_ERR_NVS_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT_INIT 0x00ffffff /* RWE-V */
#define NV_ROUTE_ERR_NVS_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT__PROD 0x007fffff /* RW--V */

#define NV_ROUTE_ERR_ECC_CTRL                              0x00005470      /* RW-4R */
#define NV_ROUTE_ERR_ECC_CTRL_GLT_ECC_ENABLE               0:0             /* RWEVF */
#define NV_ROUTE_ERR_ECC_CTRL_GLT_ECC_ENABLE_ENABLE        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_GLT_ECC_ENABLE_DISABLE       0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_ECC_CTRL_GLT_ECC_ENABLE__PROD         0x00000001      /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_NVS_ECC_ENABLE               2:2             /* RWEVF */
#define NV_ROUTE_ERR_ECC_CTRL_NVS_ECC_ENABLE_ENABLE        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_NVS_ECC_ENABLE_DISABLE       0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_ECC_CTRL_NVS_ECC_ENABLE__PROD         0x00000001      /* RW--V */

#define NV_ROUTE_CMD_ROUTE_TABLE0                          0x000050a0      /* RW-4R */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN0                    1:0             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN0_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN0_FIXED              0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN0_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN0_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN1                    5:4             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN1_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN1_FIXED              0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN1_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN1_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN2                    9:8             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN2_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN2_FIXED              0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN2_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN2_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN3                    13:12           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN3_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN3_FIXED              0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN3_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN3_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN4                    17:16           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN4_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN4_FIXED              0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN4_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN4_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN5                    21:20           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN5_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN5_FIXED              0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN5_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN5_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN6                    25:24           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN6_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN6_FIXED              0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN6_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN6_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN7                    29:28           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN7_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN7_FIXED              0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN7_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN7_ALTERNATE          0x00000003      /* RW--V */

#define NV_ROUTE_CMD_ROUTE_TABLE1                          0x000050a4      /* RW-4R */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN8                    1:0             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN8_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN8_FIXED              0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN8_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN8_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN9                    5:4             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN9_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN9_FIXED              0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN9_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN9_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN10                   9:8             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN10_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN10_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN10_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN10_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN11                   13:12           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN11_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN11_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN11_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN11_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN12                   17:16           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN12_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN12_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN12_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN12_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN13                   21:20           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN13_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN13_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN13_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN13_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN14                   25:24           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN14_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN14_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN14_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN14_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN15                   29:28           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN15_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN15_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN15_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN15_ALTERNATE         0x00000003      /* RW--V */

#define NV_ROUTE_CMD_ROUTE_TABLE2                          0x000050a8      /* RW-4R */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN16                   1:0             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN16_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN16_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN16_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN16_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN17                   5:4             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN17_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN17_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN17_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN17_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN18                   9:8             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN18_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN18_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN18_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN18_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN19                   13:12           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN19_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN19_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN19_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN19_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN20                   17:16           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN20_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN20_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN20_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN20_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN21                   21:20           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN21_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN21_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN21_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN21_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN22                   25:24           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN22_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN22_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN22_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN22_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN23                   29:28           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN23_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN23_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN23_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN23_ALTERNATE         0x00000003      /* RW--V */

#define NV_ROUTE_CMD_ROUTE_TABLE3                          0x000050ac      /* RW-4R */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN24                   1:0             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN24_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN24_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN24_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN24_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN25                   5:4             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN25_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN25_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN25_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN25_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN26                   9:8             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN26_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN26_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN26_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN26_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN27                   13:12           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN27_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN27_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN27_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN27_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN28                   17:16           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN28_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN28_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN28_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN28_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN29                   21:20           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN29_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN29_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN29_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN29_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN30                   25:24           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN30_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN30_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN30_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN30_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN31                   29:28           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN31_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN31_FIXED             0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN31_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN31_ALTERNATE         0x00000003      /* RW--V */

#define NV_ROUTE_ROUTE_CONTROL                             0x00005040      /* RW-4R */
#define NV_ROUTE_ROUTE_CONTROL_SWECCENB                    0:0             /* RWEVF */
#define NV_ROUTE_ROUTE_CONTROL_SWECCENB_HWGEN              0x00000000      /* RWE-V */
#define NV_ROUTE_ROUTE_CONTROL_SWECCENB_SWGEN              0x00000001      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_ECCWRITEBACKENB             1:1             /* RWEVF */
#define NV_ROUTE_ROUTE_CONTROL_ECCWRITEBACKENB_DISABLE     0x00000000      /* RWE-V */
#define NV_ROUTE_ROUTE_CONTROL_ECCWRITEBACKENB_ENABLE      0x00000001      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_URRESPERRVCMAP              3:2             /* RWEVF */
#define NV_ROUTE_ROUTE_CONTROL_URRESPERRVCMAP_SAME         0x00000000      /* RWE-V */
#define NV_ROUTE_ROUTE_CONTROL_URRESPERRVCMAP_INVERT       0x00000001      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_URRESPERRVCMAP_ALWAYS0      0x00000002      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_URRESPERRVCMAP_ALWAYS1      0x00000003      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_DEBUGENB                    4:4             /* RWEVF */
#define NV_ROUTE_ROUTE_CONTROL_DEBUGENB_DISABLE            0x00000000      /* RWE-V */
#define NV_ROUTE_ROUTE_CONTROL_DEBUGENB_ENABLE             0x00000001      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_REQPORTDBGMODE              6:5             /* RWEVF */
#define NV_ROUTE_ROUTE_CONTROL_REQPORTDBGMODE_ERROR        0x00000000      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_REQPORTDBGMODE_ERROR2       0x00000001      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_REQPORTDBGMODE_ADDRESS      0x00000002      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_REQPORTDBGMODE_DBGPORT      0x00000003      /* RWE-V */
#define NV_ROUTE_ROUTE_CONTROL_VCDBGMODE                   8:7             /* RWEVF */
#define NV_ROUTE_ROUTE_CONTROL_VCDBGMODE_SAME              0x00000000      /* RWE-V */
#define NV_ROUTE_ROUTE_CONTROL_VCDBGMODE_INVERT            0x00000001      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_VCDBGMODE_ALWAYS0           0x00000002      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_VCDBGMODE_ALWAYS1           0x00000003      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_RSPPORTDBGMODE              10:9            /* RWEVF */
#define NV_ROUTE_ROUTE_CONTROL_RSPPORTDBGMODE_ERROR        0x00000000      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_RSPPORTDBGMODE_ERROR2       0x00000001      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_RSPPORTDBGMODE_ADDRESS      0x00000002      /* RWE-V */
#define NV_ROUTE_ROUTE_CONTROL_RSPPORTDBGMODE_DBGPORT      0x00000003      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_URRESPENB                   11:11           /* RWEVF */
#define NV_ROUTE_ROUTE_CONTROL_URRESPENB_DISABLE           0x00000000      /* RWE-V */
#define NV_ROUTE_ROUTE_CONTROL_URRESPENB_ENABLE            0x00000001      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_URRESPENB__PROD             0x00000001      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_KILLURTD                    12:12           /* RWEVF */
#define NV_ROUTE_ROUTE_CONTROL_KILLURTD_DISABLE            0x00000000      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_KILLURTD_ENABLE             0x00000001      /* RWE-V */
#define NV_ROUTE_ROUTE_CONTROL_TRANSDONERESVOVERRIDE       13:13           /* RWEVF */
#define NV_ROUTE_ROUTE_CONTROL_TRANSDONERESVOVERRIDE_DISABLE 0x00000000    /* RWE-V */
#define NV_ROUTE_ROUTE_CONTROL_TRANSDONERESVOVERRIDE_ENABLE 0x00000001     /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_TRANSDONERESVENABLE         14:14           /* RWEVF */
#define NV_ROUTE_ROUTE_CONTROL_TRANSDONERESVENABLE_DISABLE 0x00000000      /* RWE-V */
#define NV_ROUTE_ROUTE_CONTROL_TRANSDONERESVENABLE_ENABLE  0x00000001      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_PASSPING                    15:15           /* RWEVF */
#define NV_ROUTE_ROUTE_CONTROL_PASSPING_DISABLE            0x00000000      /* RWE-V */
#define NV_ROUTE_ROUTE_CONTROL_PASSPING_ENABLE             0x00000001      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_HOPINNXBAR                  19:19           /* RWEVF */
#define NV_ROUTE_ROUTE_CONTROL_HOPINNXBAR_DISABLE          0x00000000      /* RW--V */
#define NV_ROUTE_ROUTE_CONTROL_HOPINNXBAR_ENABLE           0x00000001      /* RWE-V */
#define NV_ROUTE_ROUTE_CONTROL_STOREANDFORWARD             24:24           /* RWEVF */
#define NV_ROUTE_ROUTE_CONTROL_STOREANDFORWARD_DISABLE     0x00000000      /* RWE-V */
#define NV_ROUTE_ROUTE_CONTROL_STOREANDFORWARD_ENABLE      0x00000001      /* RW--V */

#define NV_ROUTE_ERR_FATAL_REPORT_EN_0                     0x00005408      /* RW-4R */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_ROUTEBUFERR         0:0             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_ROUTEBUFERR__PROD   0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_ROUTEBUFERR_DISABLE 0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_ROUTEBUFERR_ENABLE  0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NOPORTDEFINEDERR    1:1             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NOPORTDEFINEDERR__PROD 0x00000000   /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NOPORTDEFINEDERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NOPORTDEFINEDERR_ENABLE 0x00000001  /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR 2:2           /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR__PROD 0x00000000 /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR   3:3             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR__PROD 0x00000000  /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR     4:4             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR__PROD 0x00000001    /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR_DISABLE 0x00000000  /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR_ENABLE 0x00000001   /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_TRANSDONERESVERR    5:5             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_TRANSDONERESVERR__PROD 0x00000000   /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_TRANSDONERESVERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_TRANSDONERESVERR_ENABLE 0x00000001  /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_PDCTRLPARERR        6:6             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_PDCTRLPARERR__PROD  0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_PDCTRLPARERR_DISABLE 0x00000000     /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_PDCTRLPARERR_ENABLE 0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR   7:7             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR__PROD 0x00000000  /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR     8:8             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR__PROD 0x00000001    /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR_DISABLE 0x00000000  /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR_ENABLE 0x00000001   /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_CDTPARERR           9:9             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_CDTPARERR__PROD     0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_CDTPARERR_DISABLE   0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_CDTPARERR_ENABLE    0x00000001      /* RW--V */

#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0                 0x0000540c      /* RW-4R */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_ROUTEBUFERR     0:0             /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_ROUTEBUFERR__PROD 0x00000000    /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_ROUTEBUFERR_DISABLE 0x00000000  /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_ROUTEBUFERR_ENABLE 0x00000001   /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NOPORTDEFINEDERR 1:1            /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NOPORTDEFINEDERR__PROD 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NOPORTDEFINEDERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NOPORTDEFINEDERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR 2:2       /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR__PROD 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR 3:3           /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR__PROD 0x00000000 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR 4:4             /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR__PROD 0x00000000 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_TRANSDONERESVERR 5:5            /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_TRANSDONERESVERR__PROD 0x00000000 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_TRANSDONERESVERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_TRANSDONERESVERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_PDCTRLPARERR    6:6             /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_PDCTRLPARERR__PROD 0x00000000   /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_PDCTRLPARERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_PDCTRLPARERR_ENABLE 0x00000001  /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR 7:7           /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR__PROD 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR 8:8             /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR__PROD 0x00000000 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_CDTPARERR       9:9             /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_CDTPARERR__PROD 0x00000000      /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_CDTPARERR_DISABLE 0x00000000    /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_CDTPARERR_ENABLE 0x00000001     /* RW--V */

#define NV_ROUTE_ERR_GLT_ECC_ERROR_COUNTER_LIMIT           0x00005484      /* RW-4R */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT 23:0          /* RWEVF */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT_INIT 0x00ffffff /* RWE-V */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT__PROD 0x007fffff /* RW--V */
#endif // __lr10_dev_route_ip_h__
