/*
 * Copyright (C) 2017 Red Hat, Inc.
 *
 * Author: Nikos Mavrogiannopoulos
 *
 * This file is part of GnuTLS.
 *
 * The GnuTLS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>
 *
 */

#ifndef GNUTLS_LIB_X509_ATTRIBUTES_H
#define GNUTLS_LIB_X509_ATTRIBUTES_H

int _x509_parse_attribute(asn1_node asn1_struct, const char *attr_name,
			  const char *given_oid, unsigned indx, int raw,
			  gnutls_datum_t *out);

int _x509_set_attribute(asn1_node asn, const char *root, const char *ext_id,
			const gnutls_datum_t *ext_data);

#endif /* GNUTLS_LIB_X509_ATTRIBUTES_H */
