#!/bin/bash
hexlist1000="4bb18f,8832b5,4d0106,704015,75010a,7582f5,8003b3,8a060e,885970,88530c,3c4581,7503fd,880841,8815b4,881057,880c44,8840f5,770588,a9733c,880453,880849,7503db,884202,880845,4bb188,750042,884347,885175,76d1c4,88434e,76cdb6,7503f0,4242ff,76cef7,76bcc8,750324,7502de,06a10e,750480,75046e,76cdac,750220,8a04a8,4bb154,4ba956,710063,750466,7504c4,7bd008,884207,702092,885961,750244,899000,76b869,7503ec,8a04f7,8a07c9,76cc6a,7504f7,ad9e66,880450,7504aa,06a102,78084a,86e7a2,8a08a1,76e4c6,76e4cc,781153,76e4c4,76e4cb,76e4ce,76e4cd,76b444,7817e1,86ef06,68220d,06a03d,7813ba,8a0227,8a04f5,7bd014,8a03b1,7c531c,7805d0,7802d4,780d13,780b87,780399,8a0551,8a07b7,888191,8a02d5,75020f,8a08a0,8a02e9,8a0813,88815a,886289,750107,8a0261,88811c,7503f3,76cdae,76cda4,888169,8a03c1,781418,8881c6,888185,8881a5,76cc64,88816b,7503b1,78137e,8a0661,8881ac,888096,888171,8a0605,88805e,888129,8880ac,750500,8a04ce,8880b4,88817c,88808a,8881be,8a0603,8a02a3,70e048,8880df,7bd023,76cd09,8881c3,8013d6,88817a,8880a5,8a0451,8880ed,888137,8a05d5,88816e,8881ba,8a0893,8a088a,88819a,750502,888179,76cc65,888173,888167,888095,8a0643,88815f,888133,88816c,888174,88813e,8880f3,76bd47,42486a,8a044e,899013,75020a,888051,8990da,7812bd,780a28,7504e8,8a0827,8a040a,8991b5,7504b5,8a0831,8991bd,8a0823,899020,780a5b,8a0515,78010e,750475,750485,8a08a7,781c50,78027d,78018f,7805fa,89647d,7819de,780e7f,8a03f3,750266,780ad5,4ba9f6,8a0455,781145,7805ec,780769,76b862,7818f2,76cc62,780cce,78058e,780d8e,7815f8,7504b1,75010b,781929,79a066,06a0e7,899039,a137df,780a2b,76d248,78088e,780df3,78124e,780625,abba93,789209,780294,4d2307,7808a1,76cc63,7c44b8,78100d,7807d3,7812c1,750065,71c275,3fe81e,8a08c7,7c2fe7,780a6c,75021c,7c3119,75025f,7c1758,7c1b0f,7c4c67,7c19a0,7c6ce8,7c49c5,7504e3,76cd0a,7c42ce,7c0742,7cf65a,7c7796,7c4f13,750264,8a08b1,76e729,750215,7c4530,780fd1,7c80fb,7c1c70,7c2bf5,780b60,8a0751,7c6d38,750069,7c2be9,888139,7c2bf6,7c3f19,780b5c,780c45,7c683d,7816f5,780671,7c009f,7c49fb,7c5343,7c1bee,780d75,780901,7c7a36,7c6f94,7c6c33,7c4d44,8a06ec,7c42d6,7c4cac,7c42e1,76cd14,780d99,7c2539,7c2bcf,780ede,7c6ca2,7813dc,7801ca,781015,abb6b5,780e87,780eec,7c6843,7c4708,7c4f0a,7c77fe,7c77fa,780595,7c6c25,89505b,7c42dc,7c44ae,7c42cc,781939,88809e,a7df59,78160e,780d03,78086e,780f6b,7c1ac1,a01f37,7c7799,7c7534,7c1761,7802f1,7805b1,7816c9,89913a,89900d,8991b7,7c7aee,781601,780ba1,7c66cd,781871,781c11,7808c0,7c2bea,7817a2,7814d3,a4cb6f,781097,a7f7fc,781649,861b47,780476,78155a,76d1c3,780b99,780a4a,78088d,79a077,780c69,75839f,781949,71bd54,7801bd,899081,7810fc,899144,79a067,7c4a01,780465,780742,04008d,76cd13,780d56,780a43,899093,7811d1,780b4e,78088c,78070b,89902b,7812d5,789253,7813b5,899040,75840b,7813ab,8990d0,79a071,781676,7583d1,7819d2,4bb18a,781464,06a1cc,758598,7805fe,4d214a,780b75,758325,758532,7583fa,780f9a,7585ab,8990cf,780f35,7811cf,8990ce,7c2e2e,7c1c6f,758475,78185c,78091e,781437,780f0a,7cf9e3,86226a,899053,780376,76cee9,89901d,89902a,758404,75841b,899149,7804af,888188,758303,7c1b2d,861b20,899130,75869f,75824e,7803ae,71bf41,78060c,781d6d,7814b5,780a87,7c1473,7580b3,781363,a34291,7816a1,7585cc,7585e3,8990e3,a57e87,896473,7801e3,75860e,758306,7803b1,781685,758616,780af4,7802ac,7802fe,758610,71c285,86eaf2,06a0af,780928,758304,7582e7,758322,71c364,7803cc,a967c9,8991bc,789241,7582b4,abed10,758531,7583a7,7583e7,7583ae,86d9ae,718a07,71be16,76cc6b,86796c,885177,71c255,7586ca,71bd85,71c042,71bd07,71c365,71c345,71bf35,7c6bbf,71c397,71c015,718a93,a874bf,71bd51,71c273,780a5e,71d707,71c311,71c384,71c234,71c339,71ba01,71bc21,8990b9,71c356,89907e,71c039,71c396,ae1209,71c018,780ac8,71c334,ae10e2,71c277,71bf16,780da0,ae6212,8414a9,86ef28,ae620c,ae6b9c,888153,86960c,71c095,ae6b9b,71bf22,86d906,780dfc,71c245,851bba,71c501,89805e,76cd72,841115,868038,71ce49,71c256,71bf89,71c043,861f22,841ebc,7806a2,872f5c,a290f3,8681b9,8462c4,868088,86e488,71c304,88819b,76cda8,8465c0,71c326,7c01e4,84b83e,86d629,c04599,845bde,86cf5a,84715c,7c01e2,86d215,ae116c,84c43e,86d2cc,8681ac,86e518,8467a0,a7e1c2,789252,86cf6f,780a6d,c8196a,78922f,868041,aa7d2b,850e36,86d68f,86e86e,780abd,71c250,ae4a79,846748,84bb0e,71c359,86cec5,76cd08,846844,86e7c4,7808a8,861ae1,8511ca,71c081,861e78,84b42f,851914,3c70ca,86cee7,84bb74,851826,86dd88,899100,84b79c,aba7d9,abe1eb,7c806c,850df2,851936,841538,780963,8681b0,84bac2,84b982,a07bb3,86d61c,899137,86d602,841894,71c274,845c3b,85c5dc,84cb66,86d330,86ced2,861fa4,8417d6,8681ab,863766,841ae0,7812a1,841500,85d098,8681b6,86da16,84c214,846d80,846822,841bd1,846bfa,8463b4,424407,abc96f,86ddaa,87cc08,8515c4,7c668c,872968,841e74,84b772,868042,845d1c,84b7d8,8964c3,8518ae,86e02e,a7006f,7c5b4a,84c29c,85c55a,75827c,86eee4,87cd05,84659e,846954,851cca,7c810d,845f30,7c6d2a,84b860,7c6d90,86d943,86d607,7cf9cc,861ede,86e13e,8991c0,84657c,7c81de,86cf4d,847c18,872863,ae29cf,842250,ae5dfe,846adc,ae5dfd,ae1531,84183c,86e8ac,86cf91,861eb4,8674f0,8514f8,8510f6,86cea3,84cefa,850e7a,850d8c,84612d,8681b1,867d00,84bd16,862dd8,781ae9,850dae,634323,851c86,899125,868094,84c27a,c82337,86d98e,a65092,86d594,84c5ec,862d50,861f3c,846978,868ee4,86eea0,86e79a,86d668,85e27c,06a1bc,71c382,780a1d,7c8069,861e4e,86808a,84116c,84b940,a18cbb,a954ca,c0173f,845f5a,781941,86dd6e,846910,7c77f8,85cd04,86ce8e,7c0c9a,8470a0,84b5ac,8463b5,c82258,899124,846d0c,7c8068,aac2e2,1506c1,8991ac,7c7bce,8462ee,8694fa,7c627b,7c6bb8,86951c,4d233a,4b1a02,7c4e6b,4d2089,841e00,8682fc,7c6695,ae638d,750255,867fac,7c531f,867fce,781094,7c1c23,7c2baf,7c7c77,a4c34c,06a1ea,7c6dbb,7cf359,7c7a3f,7c77f9,7cf6cb,7cf353,7c7ccc,7c7ab5,800740,7c4ef5,7c6dea,7c6c92,7c07ad,7c2fe1,7c6685,7c7c16,77058c,7c6ca0,7c4878,8695c6,7c6d7f,7c6de5,7c77fc,7c16f1,7c1662,7c5342,7c5348,7c39f1,7c451d,7c6b36,7c335c,7c6d2f,7c6c52,7c6273,7c423e,7c7ab6,86d682,7c4515,7c4512,7c7caf,7c809a,86d930,7c4513,7c4518,7c7bcc,7c7621,7c29d4,7c6deb,7c7a38,7c6b0b,780da8,7c6d9e,7c7ab8,a31a57,750256,7c6d39,a21633,7c5e46,7c6319,76cd0c,7c7aa1,7c7ab2,7c530b,7c801e,7c6ded,4d0104,7c7a45,7c4487,7c5b4c,7c68a5,7c6ddd,7c498f,7c3316,7c29d8,7c5d71,7c5300,7c585f,7c7c9c,7c77fd,7c6d2e,7c3b3e,7cf8ed,a81f7b,7c6d9b,7c7bd6,7c1fbd,7c2590,7c0bda,7c5310,7c7f01,aa7468,7c6d30,7cf7cc,7cfa0d,abd6c6,7c3559,aa7f8d,7c47ce,780b7d,7c16de,7c6691,7c4d14,76bd48,7c43d9,7c6de4,867f68,7c6d24,7c6276,7c6d2b,7c1469,896209,899097,7c6d8c,ac0d21,7c5323,7c52fa,7c81e0,7c6b40,7c7a3e,7c6b18,7cf481,7cf4fd,7c5304,7c0012,7c7a47,7c7bc7,7cf43a,7cf4cf,7c617c,7cf4e7,7c495b,7cf7ca,7cf7cb,7c6c9b,71bd78,7c530e,7c6b3b,89916b,7c6ba1,7c6de8,7c7c98,7c01c2,7c77f6,7c6aec,7c5309,7c6182,7c6c55,7c6d32,7c39fc,7c7ab3,7c67b5,7c7aa9,7c6b30,7c7ab9,7c7800,7c6b12,7c1c4c,7c6b2f,7c8021,7c39fb,7c4877,7c52f8,7c6ca6,7c6699,76cd05,7c595c,7c4519,7c5307,7c0002,7c6d27,7c7599,7c6782,7c6ad3,7c083c,7c24be,7c6acc,7c1475,7c2e34,7c6d94,7c2ba8,7c7a48,7c6d8f,7c6a8d,7c4dcc,899134,7c6d7b,7c6c99,7c6db6,899121,7c7701,7cf864,a4c02d,71c076,780561,7cf831,7c1505,868db5,76cd42,7c1795,ac4d43,71ba08,86d624,76cd45,ac10d8,c87ed7,868078,71ba03,7580d5,76cee7,c87ed5,86e474,781346,c820cf,c822e9,c8222f,c87f31,86e778,7c6c95,c87ee1,c87e0c,c827e3,c87e61,c87ee2,8990ec,c81861,c81ce7,c81ce9,781009"
hexlist200="4BB566,8832b5,4d0106,704015,75010a,7582f5,8003b3,8a060e,885970,88530c,3c4581,7503fd,880841,8815b4,881057,880c44,8840f5,770588,a9733c,880453,880849,7503db,884202,880845,4bb188,750042,884347,885175,76d1c4,88434e,76cdb6,7503f0,4242ff,76cef7,76bcc8,750324,7502de,06a10e,750480,75046e,76cdac,750220,8a04a8,4bb154,4ba956,710063,750466,7504c4,7bd008,884207,702092,885961,750244,899000,76b869,7503ec,8a04f7,8a07c9,76cc6a,7504f7,ad9e66,880450,7504aa,06a102,78084a,86e7a2,8a08a1,76e4c6,76e4cc,781153,76e4c4,76e4cb,76e4ce,76e4cd,76b444,7817e1,86ef06,68220d,06a03d,7813ba,8a0227,8a04f5,7bd014,8a03b1,7c531c,7805d0,7802d4,780d13,780b87,780399,8a0551,8a07b7,888191,8a02d5,75020f,8a08a0,8a02e9,8a0813,88815a,886289,750107,8a0261,88811c,7503f3,76cdae,76cda4,888169,8a03c1,781418,8881c6,888185,8881a5,76cc64,88816b,7503b1,78137e,8a0661,8881ac,888096,888171,8a0605,88805e,888129,8880ac,750500,8a04ce,8880b4,88817c,88808a,8881be,8a0603,8a02a3,70e048,8880df,7bd023,76cd09,8881c3,8013d6,88817a,8880a5,8a0451,8880ed,888137,8a05d5,88816e,8881ba,8a0893,8a088a,88819a,750502,888179,76cc65,888173,888167,888095,8a0643,88815f,888133,88816c,888174,88813e,8880f3,76bd47,42486a,8a044e,899013,75020a,888051,8990da,7812bd,780a28,7504e8,8a0827,8a040a,8991b5,7504b5,8a0831,8991bd,8a0823,899020,780a5b,8a0515,78010e,750475,750485,8a08a7,781c50,78027d,78018f,7805fa,89647d,7819de,780e7f,8a03f3,750266,780ad5,4ba9f6,8a0455,781145,7805ec"

function curltime() {
    request="$1"
    curl -sS --compressed "$request" \
        -w 'code: %{response_code}\tresolve: %{time_namelookup}\tfirst_byte: %{time_starttransfer}\ttotal: %{time_total}\n' \
        -o /dev/null
}
function get() {
    request="$1"
    curl -sS --compressed "$request"
}


set -e

queries=()
queries+=("?hexlist=${hexlist200}&jv2")
queries+=("?circle=33,-118,300&jv2")
queries+=("?closest=33,-118,300&jv2")
queries+=("?box=50,60,-5,5&jv2")
queries+=("?all_with_pos&jv2")
queries+=("?all&jv2")
queries+=("?all&filter_callsign_exact=DLH7Le&jv2")
queries+=("?all&filter_callsign_prefix=DLH&jv2")
queries+=("?all_with_pos&filter_mil&jv2")
queries+=("?all_with_pos&filter_ladd&jv2")
queries+=("?all_with_pos&filter_squawk=1000&jv2")
queries+=("/re-api/")


queries+=("?box=50,60,-5,5")
#queries=()
queries+=("?all")
queries+=("?all_with_pos")
queries+=("?all&filter_with_pos")
queries+=("?hexlist=4853D4,498421")
queries+=("?find_callsign=N126CM,CEF05N")
queries+=("?find_reg=TC-RBJ,PH-HXK")
queries+=("?find_type=a320,b788")
queries+=("?box=10,80,-5,20&filter_type=a320,b788")
queries+=("?box=10,80,-5,20")
queries+=("?box=10,80,-5,20&find_hex=4BB267")
queries+=("?box=10,80,-5,20&above_alt_baro=30000&below_alt_baro=35000")



testhost() {
    host=$1
    for query in "${queries[@]}"; do
        request="${host}${query}"
        echo -e -n "checking: ${query:0:30}\t"
        get "$request" | jq | tail -n4 | grep -e resultCount -e total -e ptime | tr  '\n' '\t'
        curltime "$request"
    done
}

hosts=(\
    "http://127.0.0.1:30152/" \
)

for host in "${hosts[@]}"; do
    echo "testing host: $host"
    testhost "$host" | column -t
    echo
done
