% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linux-distros.R
\name{linux_distros}
\alias{linux_distros}
\title{Return information about Posit's (and some other) R builds for Linux}
\usage{
linux_distros()
}
\value{
A data frame with the following columns:
\itemize{
\item \code{id}: The distro ID, e.g. \code{ubuntu-2404}.
\item \code{aliases}: A list column of character vectors with alternative names
for the distro. Alternative names starting and ending with a forward
slash are regular expressions.
\item \code{name}: The full name of the distro, e.g. \verb{Red Hat Enterprise Linux}.
\item \code{version}: The version of the distro, e.g. \code{24.04} for Ubuntu, or \code{9}
for RHEL.
\item \code{codename}: The codename of the distro, e.g. \code{focal} for Ubuntu 20.04.
\item \code{url}: The URL of the distro's homepage.
\item \code{docker}: The name of the official Docker image for the distro,
e.g. \code{ubuntu:20.04}.
\item \code{eol}: The end-of-life date of the distro, or \code{NA} if unknown.
\item \code{retired}: whether the distro version is retired for Posit and R-hub.
\item \code{aarch64}: whether aarch64 builds are available for this distro.
Possible values are \code{posit} (builds are available from Posit),
\code{r-hub} (builds are available from R-hub), \code{none} (no builds are
available).
\item \code{ppm_binaries}: whether PPM binaries are available for this distro.
\item \code{ppm_aarch64}: whether aarch64 PPM binaries are available for this
distro.
\item \code{ppm_url}: The URL of the PPM binaries for this distro.
}
}
\description{
Return information about Posit's (and some other) R builds for Linux
}
\details{
\code{linux_distros()} caches its results in the current R session. To clear
the cache restart R or set the \code{R_VERSION_CACHE_TIMEOUT} environment
variable to \code{0}.
}
\examples{
\dontshow{if (rversions:::is_online()) withAutoprint(\{ # examplesIf}
linux_distros()
\dontshow{\}) # examplesIf}
}
