% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_poisson.R
\name{dist_poisson}
\alias{dist_poisson}
\title{The Poisson Distribution}
\usage{
dist_poisson(lambda)
}
\arguments{
\item{lambda}{The rate parameter (mean and variance) of the distribution.
Can be any positive number. This represents the expected number of events
in the given interval.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Poisson distributions are frequently used to model counts. The Poisson
distribution is commonly used to model the number of events occurring in
a fixed interval of time or space when these events occur with a known
constant mean rate and independently of the time since the last event.
Examples include the number of emails received per hour, the number of
decay events per second from a radioactive source, or the number of
customers arriving at a store per day.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_poisson.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_poisson.html}

In the following, let \eqn{X} be a Poisson random variable with parameter
\code{lambda} = \eqn{\lambda}.

\strong{Support}: \eqn{\{0, 1, 2, 3, ...\}}{{0, 1, 2, 3, ...}}

\strong{Mean}: \eqn{\lambda}

\strong{Variance}: \eqn{\lambda}

\strong{Probability mass function (p.m.f)}:

\deqn{
    P(X = k) = \frac{\lambda^k e^{-\lambda}}{k!}
  }{
    P(X = k) = \lambda^k e^(-\lambda) / k!
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    P(X \le k) = e^{-\lambda}
    \sum_{i = 0}^{\lfloor k \rfloor} \frac{\lambda^i}{i!}
  }{
    P(X \le k) = e^(-\lambda)
    \sum_{i = 0}^k \lambda^i / i!
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = e^{\lambda (e^t - 1)}
  }{
    E(e^(tX)) = e^(\lambda (e^t - 1))
  }

\strong{Skewness}:

\deqn{
    \gamma_1 = \frac{1}{\sqrt{\lambda}}
  }{
    \gamma_1 = 1 / sqrt(\lambda)
  }

\strong{Excess kurtosis}:

\deqn{
    \gamma_2 = \frac{1}{\lambda}
  }{
    \gamma_2 = 1 / \lambda
  }
}
\examples{
dist <- dist_poisson(lambda = c(1, 4, 10))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Poisson]{stats::Poisson}
}
