% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-slice.R
\name{dbplyr-slice}
\alias{slice_min.tbl_lazy}
\alias{slice_max.tbl_lazy}
\alias{slice_sample.tbl_lazy}
\title{Subset rows using their positions}
\usage{
\method{slice_min}{tbl_lazy}(
  .data,
  order_by,
  ...,
  n,
  prop,
  by = NULL,
  with_ties = TRUE,
  na_rm = TRUE
)

\method{slice_max}{tbl_lazy}(
  .data,
  order_by,
  ...,
  n,
  by = NULL,
  prop,
  with_ties = TRUE,
  na_rm = TRUE
)

\method{slice_sample}{tbl_lazy}(.data, ..., n, prop, by = NULL, weight_by = NULL, replace = FALSE)
}
\arguments{
\item{.data}{A lazy data frame backed by a database query.}

\item{order_by}{Variable or function of variables to order by.}

\item{...}{Not used.}

\item{n, prop}{Provide either \code{n}, the number of rows, or \code{prop}, the
proportion of rows to select. If neither are supplied, \code{n = 1} will be
used.

If \code{n} is greater than the number of rows in the group (or \code{prop} > 1),
the result will be silently truncated to the group size. If the proportion
of a group size is not an integer, it is rounded down.}

\item{by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{with_ties}{Should ties be kept together? The default, \code{TRUE}, may
return more rows than you request. Use FALSE to ignore ties, and return
the first n rows.}

\item{na_rm}{Should missing values in \code{order_by} be removed from the result?
If \code{FALSE}, \code{NA} values are sorted to the end (like in \code{\link[dplyr:arrange]{arrange()}}), so
they will only be included if there are insufficient non-missing values to
reach \code{n}/\code{prop}.}

\item{weight_by, replace}{Not supported for database backends.}
}
\description{
These are methods for the dplyr generics \code{\link[dplyr:slice]{dplyr::slice_min()}}, \code{\link[dplyr:slice]{dplyr::slice_max()}}, and
\code{\link[dplyr:slice]{dplyr::slice_sample()}}. They are translated to SQL using \code{\link[dplyr:filter]{dplyr::filter()}} and
window functions (\code{ROWNUMBER}, \code{MIN_RANK}, or \code{CUME_DIST} depending on
arguments). \code{slice()}, \code{slice_head()}, and \code{slice_tail()} are not supported
since database tables have no intrinsic order.

If data is grouped, the operation will be performed on each group so that
(e.g.) \code{slice_min(db, x, n = 3)} will select the three rows with the smallest
value of \code{x} in each group.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

db <- memdb_frame(x = 1:3, y = c(1, 1, 2))
db \%>\% slice_min(x) \%>\% show_query()
db \%>\% slice_max(x) \%>\% show_query()
db \%>\% slice_sample() \%>\% show_query()

db \%>\% group_by(y) \%>\% slice_min(x) \%>\% show_query()

# By default, ties are includes so you may get more rows
# than you expect
db \%>\% slice_min(y, n = 1)
db \%>\% slice_min(y, n = 1, with_ties = FALSE)

# Non-integer group sizes are rounded down
db \%>\% slice_min(x, prop = 0.5)
}
