
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file EpsWindAttributes.h
    \\brief Definition of EpsWind Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "EpsWindAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

EpsWindAttributes::EpsWindAttributes():
	convention_(ParameterManager::getString("eps_rose_wind_convention")),
	legend_(ParameterManager::getBool("legend"))
	,
	colour_(MagTranslator<string, Colour>().magics("eps_rose_wind_colour")),
	border_colour_(MagTranslator<string, Colour>().magics("eps_rose_wind_border_colour"))
	
{
}


EpsWindAttributes::~EpsWindAttributes()
{

}


void EpsWindAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	int i = 0;
	prefix[i++] = "eps";
	prefix[i++] = "eps_rose_wind";
	
	setAttribute(prefix, "eps_rose_wind_convention", convention_, params);
	setAttribute(prefix, "legend", legend_, params);
	
	setMember(prefix, "eps_rose_wind_colour", colour_, params);
	setMember(prefix, "eps_rose_wind_border_colour", border_colour_, params);
	
}

void EpsWindAttributes::copy(const EpsWindAttributes& other)
{
	convention_ = other.convention_;
	legend_ = other.legend_;
	colour_ = unique_ptr<Colour>(other.colour_->clone());
	border_colour_ = unique_ptr<Colour>(other.border_colour_->clone());
	
}


bool EpsWindAttributes::accept(const string& node)
{

	if ( magCompare(node, "epswind")  )
		return true;
	
	return false;
}

void EpsWindAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "epswind")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void EpsWindAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " convention = " <<  convention_;
	out << " legend = " <<  legend_;
	out << " colour = " <<  *colour_;
	out << " border_colour = " <<  *border_colour_;
	
	out << "]" << "\n";
}

void EpsWindAttributes::toxml(ostream& out)  const
{
	out <<  "\"epswind\"";
	out << ", \"eps_rose_wind_convention\":";
	niceprint(out,convention_);
	out << ", \"legend\":";
	niceprint(out,legend_);
	out << ", \"eps_rose_wind_colour\":";
	niceprint(out, *colour_);
	out << ", \"eps_rose_wind_border_colour\":";
	niceprint(out, *border_colour_);
	
}

static MagicsParameter<string> eps_rose_wind_convention("eps_rose_wind_convention", "meteorological");
static MagicsParameter<string> legend("legend", "on");
static MagicsParameter<string> eps_rose_wind_colour("eps_rose_wind_colour", "grey");
static MagicsParameter<string> eps_rose_wind_border_colour("eps_rose_wind_border_colour", "grey");
