.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
spheremonics - 3d spherical harmonic shapes.
.SH SYNOPSIS
.B spheremonics
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fInumber\fP]
[\-duration \fInumber\fP]
[\-resolution \fInumber\fP]
[\-wander]
[\-no-spin]
[\-spin \fI[XYZ]\fP]
[\-wireframe]
[\-no-smooth]
[\-no-grid]
[\-bbox]
[\-fps]
.SH DESCRIPTION
These closed objects are commonly called spherical harmonics, although they
are only remotely related to the mathematical definition found in the
solution to certain wave functions, most notable the eigenfunctions of
angular momentum operators.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 30000 (0.03 seconds.).
.TP 8
.B \-duration \fInumber\fP
Duration.  5 - 1000.  Default: 100.
.TP 8
.B \-resolution \fInumber\fP
Resolution.  5 - 100.  Default: 64.
.TP 8
.B \-wander | \-no-wander
Whether the object should wander around the screen.
.TP 8
.B \-spin \fI[XYZ]\fP
Around which axes should the object spin?
.TP 8
.B \-no-spin
Don't spin.
.TP 8
.B \-wireframe
Render in wireframe instead of solid.
.TP 8
.B \-smooth | \-no-smooth
Smoothed Lines.  Boolean.
.TP 8
.B \-grid | \-no-grid
Draw Grid.  Boolean.
.TP 8
.B \-bbox | \-no-bbox
Draw Bounding Box.  Boolean.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2002 by Paul Bourke and Jamie Zawinski.  Permission to
use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  No representations are made about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.
.SH AUTHOR
Paul Bourke and Jamie Zawinski.
