#ifndef _TextFieldP_h
#define _TextFieldP_h

/*
 *  The TextField Widget
 *  --------------------
 
 *  Copyright (C) 1997  by Till Straumann   <strauman@sun6hft.ee.tu-berlin.de>
 *  modified 2006 by Bernhard R. Link (see Changelog for details)

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Library Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Library Public License for more details.

 *  You should have received a copy of the GNU General Library Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "TextField.h"

#ifdef TEXT_COMPAT
#include <X11/Xaw3d/TextP.h> /* need XtNRResizeMode */
#endif

/* include superclass private header file */

#include <X11/Xaw3d/ThreeDP.h>

/* define unique representation types not found in <X11/StringDefs.h> */

typedef struct {
    int empty;
} TextFieldClassPart;

typedef struct _TextFieldClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    ThreeDClassPart	threeD_class;
    TextFieldClassPart	textField_class;
} TextFieldClassRec;

extern TextFieldClassRec textFieldClassRec;

#ifdef TEXT_COMPAT
typedef XawTextResizeMode TfResizeMode;
#else
typedef union {
	Boolean b;
	enum { pas_a,pad_b,pad_c,pad_d } pad;
} TfResizeMode;
#endif

typedef struct {
    /* resources */
    XFontStruct*	font;
    Pixel			foreground;
    Pixel			insensitive_foreground;
    Dimension		internalHeight;
    Dimension		internalWidth;
    TfTextPosition	text_cursor;
    TfResizeMode	resize;
    String			string;
    Boolean			use_string_in_place;
    XtJustify		justify;
    Cardinal			maxlen;
    Boolean			readonly;
    short			scroll_chars;
    XtCallbackList	notify_cbl,modified_cbl;
    XrmValue		value;
    String			value_type;
    String			input_format;
    String			output_format;
    Boolean			display_caret;
	Boolean			modified_by_user;
	Boolean			blink;
	Boolean			auto_blink;
	int				auto_blink_wait_time; /* note: time in ms for XtTimers is unsigned long.
									   *	   There is no such rep. type however.
									   */
	int				blink_on_time;
	int				blink_off_time;
	Boolean			leftLabel; /* paint the label at the left or right ? */
    XFontStruct*	lblFont;
	String			label;
	int				labelSep;
	Dimension		labelWidth;
	XtJustify		lblJustify;
	int				showNChars;

    /* private state */

    GC				lbl,norm, norm_hil, insens, insens_hil;
    short			visible_start,visible_end;
    unsigned long	selections;
    String			buffer;
    short			hil_start,hil_end;
    short			multiclick;
    Time			multiclick_time;
    Boolean			active_cursor;
	XtIntervalId 	blink_timer;
	Boolean			blink_state_on;
	String			backup;
} TextFieldPart;

typedef struct _TextFieldRec {
    CorePart		core;
    SimplePart		simple;
    ThreeDPart		threeD;
    TextFieldPart	textField;
} TextFieldRec;

#endif /* _TextFieldP_h */
