# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


#-------------------------------------------------------------------------------------------------------------
# Reste à faire :
#   Faire que dans le cas où une modif de rep est faite, un check soit refait même si on ne click pas sur le bouton !
#   Resetter les combox d'output format quand on change les dépendances externes
#-------------------------------------------------------------------------------------------------------------


import sys
import os
from xml.dom import minidom
from xml.dom.minidom import Document
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from __builtin__ import hex as hexp
from string import *
from main_win import *
from statusconf import *
from Configuration import *
from GlobalDefines import *
from DocHelpDlg import *
from OFD import *

class ConfigurationDlg(QDialog,Ui_Configuration) :
  
    def __init__(self, VideoporamaInstance,parent=None):
      super(ConfigurationDlg, self).__init__(parent)
      self.setupUi(self)
      self.tabWidget.setCurrentIndex(0)
      self.VideoporamaInstance=VideoporamaInstance

      #-------------------------------------- Init Overlaid text option for new objet in the dialog box text
      # Init check box
      self.TOverlaidtextLeft.setCheckable(True)
      self.TOverlaidtextCenter.setCheckable(True)
      self.TOverlaidtextJustif.setCheckable(True)
      self.TOverlaidtextRight.setCheckable(True)
      self.TOverlaidtextUp.setCheckable(True)
      self.TOverlaidtextVCenter.setCheckable(True)
      self.TOverlaidtextBottom.setCheckable(True)
      # Init font
      sizes=QFontDatabase.standardSizes()
      Ssizes=QStringList()
      for size in sizes : Ssizes.append(unicode(size))
      self.TOverlaidfontSize.insertItems(0,Ssizes)
      self.TOverlaidfontSize.setCurrentIndex(6)
      # Init combo box FontEffect
      self.TOverlaidfontEffectCB.addItem(QIcon("icons/text_normal.png"),             self.VideoporamaInstance.qtapp.translate("DefTextDlg","No effect"))
      self.TOverlaidfontEffectCB.addItem(QIcon("icons/text_outerline.png"),          self.VideoporamaInstance.qtapp.translate("DefTextDlg","Outerline"))
      self.TOverlaidfontEffectCB.addItem(QIcon("icons/text_shadow_up_left.png"),     self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow upper left"))
      self.TOverlaidfontEffectCB.addItem(QIcon("icons/text_shadow_up_right.png"),    self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow upper right"))
      self.TOverlaidfontEffectCB.addItem(QIcon("icons/text_shadow_bottom_left.png"), self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow bottom left"))
      self.TOverlaidfontEffectCB.addItem(QIcon("icons/text_shadow_bottom_right.png"),self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow bottom right"))
      # Init combo box Background form
      self.TOverlaidBackgroundFormCB.addItem(QIcon("icons/Frame_TextOnly.png"),      self.VideoporamaInstance.qtapp.translate("DefTextDlg","Text only"))
      self.TOverlaidBackgroundFormCB.addItem(QIcon("icons/Frame_Rectangle.png"),     self.VideoporamaInstance.qtapp.translate("DefTextDlg","Rectangle"))
      self.TOverlaidBackgroundFormCB.addItem(QIcon("icons/Frame_RoundRec.png"),      self.VideoporamaInstance.qtapp.translate("DefTextDlg","Rounded Rectangle"))
      self.TOverlaidBackgroundFormCB.addItem(QIcon("icons/Frame_Buble.png"),         self.VideoporamaInstance.qtapp.translate("DefTextDlg","Buble"))
      self.TOverlaidBackgroundFormCB.addItem(QIcon("icons/Frame_Ellipse.png"),       self.VideoporamaInstance.qtapp.translate("DefTextDlg","Ellipse"))
      # Init combo box Background style
      self.TOverlaidBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Solid"))
      self.TOverlaidBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent")+unicode(" 75%"))
      self.TOverlaidBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent")+unicode(" 50%"))
      self.TOverlaidBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent")+unicode(" 25%"))
      self.TOverlaidBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent"))

      self.VideoporamaInstance.qtapp.connect(self.TOverlaidfontStyleCB,SIGNAL("currentFontChanged(QFont)"),self.TOverlaidChangeFont)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidfontSize,SIGNAL("currentIndexChanged(QString)"),self.TOverlaidChangeSizeFont)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidfontColorB,SIGNAL("pressed()"),self.TOverlaidSetTextColor)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidStyleShadowColorBt,SIGNAL("pressed()"),self.TOverlaidSetFontShadowColor)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidbold,SIGNAL("released()"),self.TOverlaidSetBold)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidItalic,SIGNAL("released()"),self.TOverlaidSetItalic)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidSouligne,SIGNAL("released()"),self.TOverlaidSetUnderline)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidtextLeft,SIGNAL("pressed()"),self.TOverlaidSetTextLeft)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidtextCenter,SIGNAL("pressed()"),self.TOverlaidSetTextCenter)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidtextRight,SIGNAL("pressed()"),self.TOverlaidSetTextRight)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidtextJustif,SIGNAL("pressed()"),self.TOverlaidSetTextJustif)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidtextUp,SIGNAL("pressed()"),self.TOverlaidSetTextUp)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidtextVCenter,SIGNAL("pressed()"),self.TOverlaidSetTextVCenter)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidtextBottom,SIGNAL("pressed()"),self.TOverlaidSetTextBottom)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidfontEffectCB,SIGNAL("currentIndexChanged(int)"),self.TOverlaidChangeStyleFont)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidBackgroundFormCB,SIGNAL("currentIndexChanged(int)"),self.TOverlaidChangeBackgroundForm)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidBackgroundStyleCB,SIGNAL("currentIndexChanged(int)"),self.TOverlaidChangeBackgroundStyle)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidBackgroundColorBt,SIGNAL("pressed()"),self.TOverlaidSetBackgroundColor)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidPenColorBt,SIGNAL("pressed()"),self.TOverlaidSetPenColor)
      self.VideoporamaInstance.qtapp.connect(self.TOverlaidPenSizeEd,SIGNAL("valueChanged(int)"),self.TOverlaidChgPenSize)

      #-------------------------------------- Init BackGround text option for new objet in the dialog box text
      # Init check box
      self.TBackGtextLeft.setCheckable(True)
      self.TBackGtextCenter.setCheckable(True)
      self.TBackGtextJustif.setCheckable(True)
      self.TBackGtextRight.setCheckable(True)
      self.TBackGtextUp.setCheckable(True)
      self.TBackGtextVCenter.setCheckable(True)
      self.TBackGtextBottom.setCheckable(True)
      # Init font
      sizes=QFontDatabase.standardSizes()
      Ssizes=QStringList()
      for size in sizes : Ssizes.append(unicode(size))
      self.TBackGfontSize.insertItems(0,Ssizes)
      self.TBackGfontSize.setCurrentIndex(6)
      # Init combo box FontEffect
      self.TBackGfontEffectCB.addItem(QIcon("icons/text_normal.png"),             self.VideoporamaInstance.qtapp.translate("DefTextDlg","No effect"))
      self.TBackGfontEffectCB.addItem(QIcon("icons/text_outerline.png"),          self.VideoporamaInstance.qtapp.translate("DefTextDlg","Outerline"))
      self.TBackGfontEffectCB.addItem(QIcon("icons/text_shadow_up_left.png"),     self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow upper left"))
      self.TBackGfontEffectCB.addItem(QIcon("icons/text_shadow_up_right.png"),    self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow upper right"))
      self.TBackGfontEffectCB.addItem(QIcon("icons/text_shadow_bottom_left.png"), self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow bottom left"))
      self.TBackGfontEffectCB.addItem(QIcon("icons/text_shadow_bottom_right.png"),self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow bottom right"))
      # Init combo box Background form
      self.TBackGBackgroundFormCB.addItem(QIcon("icons/Frame_TextOnly.png"),      self.VideoporamaInstance.qtapp.translate("DefTextDlg","Text only"))
      self.TBackGBackgroundFormCB.addItem(QIcon("icons/Frame_Rectangle.png"),     self.VideoporamaInstance.qtapp.translate("DefTextDlg","Rectangle"))
      self.TBackGBackgroundFormCB.addItem(QIcon("icons/Frame_RoundRec.png"),      self.VideoporamaInstance.qtapp.translate("DefTextDlg","Rounded Rectangle"))
      self.TBackGBackgroundFormCB.addItem(QIcon("icons/Frame_Buble.png"),         self.VideoporamaInstance.qtapp.translate("DefTextDlg","Buble"))
      self.TBackGBackgroundFormCB.addItem(QIcon("icons/Frame_Ellipse.png"),       self.VideoporamaInstance.qtapp.translate("DefTextDlg","Ellipse"))
      # Init combo box Background style
      self.TBackGBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Solid"))
      self.TBackGBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent")+unicode(" 75%"))
      self.TBackGBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent")+unicode(" 50%"))
      self.TBackGBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent")+unicode(" 25%"))
      self.TBackGBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent"))

      self.VideoporamaInstance.qtapp.connect(self.TBackGfontStyleCB,SIGNAL("currentFontChanged(QFont)"),self.TBackGChangeFont)
      self.VideoporamaInstance.qtapp.connect(self.TBackGfontSize,SIGNAL("currentIndexChanged(QString)"),self.TBackGChangeSizeFont)
      self.VideoporamaInstance.qtapp.connect(self.TBackGfontColorB,SIGNAL("pressed()"),self.TBackGSetTextColor)
      self.VideoporamaInstance.qtapp.connect(self.TBackGStyleShadowColorBt,SIGNAL("pressed()"),self.TBackGSetFontShadowColor)
      self.VideoporamaInstance.qtapp.connect(self.TBackGbold,SIGNAL("released()"),self.TBackGSetBold)
      self.VideoporamaInstance.qtapp.connect(self.TBackGItalic,SIGNAL("released()"),self.TBackGSetItalic)
      self.VideoporamaInstance.qtapp.connect(self.TBackGSouligne,SIGNAL("released()"),self.TBackGSetUnderline)
      self.VideoporamaInstance.qtapp.connect(self.TBackGtextLeft,SIGNAL("pressed()"),self.TBackGSetTextLeft)
      self.VideoporamaInstance.qtapp.connect(self.TBackGtextCenter,SIGNAL("pressed()"),self.TBackGSetTextCenter)
      self.VideoporamaInstance.qtapp.connect(self.TBackGtextRight,SIGNAL("pressed()"),self.TBackGSetTextRight)
      self.VideoporamaInstance.qtapp.connect(self.TBackGtextJustif,SIGNAL("pressed()"),self.TBackGSetTextJustif)
      self.VideoporamaInstance.qtapp.connect(self.TBackGtextUp,SIGNAL("pressed()"),self.TBackGSetTextUp)
      self.VideoporamaInstance.qtapp.connect(self.TBackGtextVCenter,SIGNAL("pressed()"),self.TBackGSetTextVCenter)
      self.VideoporamaInstance.qtapp.connect(self.TBackGtextBottom,SIGNAL("pressed()"),self.TBackGSetTextBottom)
      self.VideoporamaInstance.qtapp.connect(self.TBackGfontEffectCB,SIGNAL("currentIndexChanged(int)"),self.TBackGChangeStyleFont)
      self.VideoporamaInstance.qtapp.connect(self.TBackGBackgroundFormCB,SIGNAL("currentIndexChanged(int)"),self.TBackGChangeBackgroundForm)
      self.VideoporamaInstance.qtapp.connect(self.TBackGBackgroundStyleCB,SIGNAL("currentIndexChanged(int)"),self.TBackGChangeBackgroundStyle)
      self.VideoporamaInstance.qtapp.connect(self.TBackGBackgroundColorBt,SIGNAL("pressed()"),self.TBackGSetBackgroundColor)
      self.VideoporamaInstance.qtapp.connect(self.TBackGPenColorBt,SIGNAL("pressed()"),self.TBackGSetPenColor)
      self.VideoporamaInstance.qtapp.connect(self.TBackGPenSizeEd,SIGNAL("valueChanged(int)"),self.TBackGChgPenSize)

      #-------------------------------------- Init Shot text option for new objet in the dialog box text
      # Init check box
      self.TShottextLeft.setCheckable(True)
      self.TShottextCenter.setCheckable(True)
      self.TShottextJustif.setCheckable(True)
      self.TShottextRight.setCheckable(True)
      self.TShottextUp.setCheckable(True)
      self.TShottextVCenter.setCheckable(True)
      self.TShottextBottom.setCheckable(True)
      # Init font
      sizes=QFontDatabase.standardSizes()
      Ssizes=QStringList()
      for size in sizes : Ssizes.append(unicode(size))
      self.TShotfontSize.insertItems(0,Ssizes)
      self.TShotfontSize.setCurrentIndex(6)
      # Init combo box FontEffect
      self.TShotfontEffectCB.addItem(QIcon("icons/text_normal.png"),             self.VideoporamaInstance.qtapp.translate("DefTextDlg","No effect"))
      self.TShotfontEffectCB.addItem(QIcon("icons/text_outerline.png"),          self.VideoporamaInstance.qtapp.translate("DefTextDlg","Outerline"))
      self.TShotfontEffectCB.addItem(QIcon("icons/text_shadow_up_left.png"),     self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow upper left"))
      self.TShotfontEffectCB.addItem(QIcon("icons/text_shadow_up_right.png"),    self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow upper right"))
      self.TShotfontEffectCB.addItem(QIcon("icons/text_shadow_bottom_left.png"), self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow bottom left"))
      self.TShotfontEffectCB.addItem(QIcon("icons/text_shadow_bottom_right.png"),self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow bottom right"))
      # Init combo box Background form
      self.TShotBackgroundFormCB.addItem(QIcon("icons/Frame_TextOnly.png"),      self.VideoporamaInstance.qtapp.translate("DefTextDlg","Text only"))
      self.TShotBackgroundFormCB.addItem(QIcon("icons/Frame_Rectangle.png"),     self.VideoporamaInstance.qtapp.translate("DefTextDlg","Rectangle"))
      self.TShotBackgroundFormCB.addItem(QIcon("icons/Frame_RoundRec.png"),      self.VideoporamaInstance.qtapp.translate("DefTextDlg","Rounded Rectangle"))
      self.TShotBackgroundFormCB.addItem(QIcon("icons/Frame_Buble.png"),         self.VideoporamaInstance.qtapp.translate("DefTextDlg","Buble"))
      self.TShotBackgroundFormCB.addItem(QIcon("icons/Frame_Ellipse.png"),       self.VideoporamaInstance.qtapp.translate("DefTextDlg","Ellipse"))
      # Init combo box Background style
      self.TShotBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Solid"))
      self.TShotBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent")+unicode(" 75%"))
      self.TShotBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent")+unicode(" 50%"))
      self.TShotBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent")+unicode(" 25%"))
      self.TShotBackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent"))

      self.VideoporamaInstance.qtapp.connect(self.TShotfontStyleCB,SIGNAL("currentFontChanged(QFont)"),self.TShotChangeFont)
      self.VideoporamaInstance.qtapp.connect(self.TShotfontSize,SIGNAL("currentIndexChanged(QString)"),self.TShotChangeSizeFont)
      self.VideoporamaInstance.qtapp.connect(self.TShotfontColorB,SIGNAL("pressed()"),self.TShotSetTextColor)
      self.VideoporamaInstance.qtapp.connect(self.TShotStyleShadowColorBt,SIGNAL("pressed()"),self.TShotSetFontShadowColor)
      self.VideoporamaInstance.qtapp.connect(self.TShotbold,SIGNAL("released()"),self.TShotSetBold)
      self.VideoporamaInstance.qtapp.connect(self.TShotItalic,SIGNAL("released()"),self.TShotSetItalic)
      self.VideoporamaInstance.qtapp.connect(self.TShotSouligne,SIGNAL("released()"),self.TShotSetUnderline)
      self.VideoporamaInstance.qtapp.connect(self.TShottextLeft,SIGNAL("pressed()"),self.TShotSetTextLeft)
      self.VideoporamaInstance.qtapp.connect(self.TShottextCenter,SIGNAL("pressed()"),self.TShotSetTextCenter)
      self.VideoporamaInstance.qtapp.connect(self.TShottextRight,SIGNAL("pressed()"),self.TShotSetTextRight)
      self.VideoporamaInstance.qtapp.connect(self.TShottextJustif,SIGNAL("pressed()"),self.TShotSetTextJustif)
      self.VideoporamaInstance.qtapp.connect(self.TShottextUp,SIGNAL("pressed()"),self.TShotSetTextUp)
      self.VideoporamaInstance.qtapp.connect(self.TShottextVCenter,SIGNAL("pressed()"),self.TShotSetTextVCenter)
      self.VideoporamaInstance.qtapp.connect(self.TShottextBottom,SIGNAL("pressed()"),self.TShotSetTextBottom)
      self.VideoporamaInstance.qtapp.connect(self.TShotfontEffectCB,SIGNAL("currentIndexChanged(int)"),self.TShotChangeStyleFont)
      self.VideoporamaInstance.qtapp.connect(self.TShotBackgroundFormCB,SIGNAL("currentIndexChanged(int)"),self.TShotChangeBackgroundForm)
      self.VideoporamaInstance.qtapp.connect(self.TShotBackgroundStyleCB,SIGNAL("currentIndexChanged(int)"),self.TShotChangeBackgroundStyle)
      self.VideoporamaInstance.qtapp.connect(self.TShotBackgroundColorBt,SIGNAL("pressed()"),self.TShotSetBackgroundColor)
      self.VideoporamaInstance.qtapp.connect(self.TShotPenColorBt,SIGNAL("pressed()"),self.TShotSetPenColor)
      self.VideoporamaInstance.qtapp.connect(self.TShotPenSizeEd,SIGNAL("valueChanged(int)"),self.TShotChgPenSize)

      #-------------------------------------- 
      #Init transition ComboBox
      self.typet.insertItems(0,self.VideoporamaInstance.lstT)
      self.typet.addItem(self.VideoporamaInstance.qtapp.translate("main","Random"))
      self.RANDOMTRANSITIONTYPE=self.typet.count()-1

      self.connect(self.saveconfig,SIGNAL("clicked()"),self.SaveConfig)
      self.connect(self.chk,SIGNAL("clicked()"),self.check_CheckConfig)

      if self.VideoporamaInstance.IsPortable==False :
        #TAB Directory configuration : init lineEdit and signal for browse button from each directory configuration
        self.InitTextOption(self.tmpdir,'tmpdir',self.VideoporamaInstance.T)
        self.InitTextOption(self.imgmgkdir,'imgmgkdir',self.VideoporamaInstance.I)
        self.InitTextOption(self.mjpegtoolsdir,'mjpegtoolsdir',self.VideoporamaInstance.MJ)
        self.InitTextOption(self.soxdir,'soxdir',self.VideoporamaInstance.S)
        self.InitTextOption(self.mplayerdir,'mplayerdir',self.VideoporamaInstance.MP)
        self.InitTextOption(self.ImageEditor,'ImageEditor',self.VideoporamaInstance.ImageEditor)

        self.connect(self.tmpdirbut,SIGNAL("clicked()"),self.ChTMPDir)
        self.connect(self.tmpdir,SIGNAL("editingFinished()"),self.ChTMPDirEd)
        self.connect(self.mplayerbut,SIGNAL("clicked()"),self.ChMPlayerDir)
        self.connect(self.mplayerdir,SIGNAL("editingFinished()"),self.ChMPlayerDirEd)
        self.connect(self.imgmgkbut,SIGNAL("clicked()"),self.ChFFMPEGDir)
        self.connect(self.imgmgkdir,SIGNAL("editingFinished()"),self.ChFFMPEGDirEd)
        self.connect(self.mjpegtoolsbut,SIGNAL("clicked()"),self.ChMJPEGToolsDir)
        self.connect(self.mjpegtoolsdir,SIGNAL("editingFinished()"),self.ChMJPEGToolsDirEd)
        self.connect(self.soxbut,SIGNAL("clicked()"),self.ChSOXDir)
        self.connect(self.soxdir,SIGNAL("editingFinished()"),self.ChSOXDirEd)
        self.connect(self.ImageEditorBut,SIGNAL("clicked()"),self.ChImageEditor)
        self.connect(self.ImageEditor,SIGNAL("editingFinished()"),self.ChImageEditorEd)
      else :
        self.tmpdir.setText(QtGui.QApplication.translate("Configuration", "PortableVideoporama version use default user tempory directory", None, QtGui.QApplication.UnicodeUTF8))
        self.imgmgkdir.setText(QtGui.QApplication.translate("Configuration", "PortableVideoporama version include the dependences", None, QtGui.QApplication.UnicodeUTF8))
        self.mjpegtoolsdir.setText(QtGui.QApplication.translate("Configuration", "PortableVideoporama version include the dependences", None, QtGui.QApplication.UnicodeUTF8))
        self.soxdir.setText(QtGui.QApplication.translate("Configuration", "PortableVideoporama version include the dependences", None, QtGui.QApplication.UnicodeUTF8))
        self.mplayerdir.setText(QtGui.QApplication.translate("Configuration", "PortableVideoporama version include the dependences", None, QtGui.QApplication.UnicodeUTF8))
        self.ImageEditor.setText(QtGui.QApplication.translate("Configuration", "PortableVideoporama version use PortableGimp if present", None, QtGui.QApplication.UnicodeUTF8))
        self.tmpdir.setEnabled(False)
        self.tmpdirbut.setEnabled(False)
        self.imgmgkdir.setEnabled(False)
        self.imgmgkbut.setEnabled(False)
        self.mjpegtoolsdir.setEnabled(False)
        self.mjpegtoolsbut.setEnabled(False)
        self.soxdir.setEnabled(False)
        self.soxbut.setEnabled(False)
        self.mplayerdir.setEnabled(False)
        self.mplayerbut.setEnabled(False)
        self.ImageEditor.setEnabled(False)
        self.ImageEditorBut.setEnabled(False)

      #TAB Display configuration : Init & Signal
      self.InitCBOption(self.DisplayUnitMode,'zoomVal',self.VideoporamaInstance.ConfDisplayUnit)
      self.InitCBOption(self.RestoreWindowState,'WindowsSettings-RestoreWindowState',self.VideoporamaInstance.RestoreWindowState)
      self.InitCBOption(self.NewSEQPosition,'NewSEQPosition',self.VideoporamaInstance.NewSEQPosition)

      #TAB Default output format : Init & Signal
      self.InitCBOption(self.imgformat,'imgformat',self.VideoporamaInstance.ConfImgFormat)
      self.connect(self.DisplayUnitMode,SIGNAL("activated(int)"),self.ChDisplayUnitOption)
      
      # Parse Output Format Definition
      List=self.VideoporamaInstance.OutputOFDXMLObject.GetOFDDeviceTypeCBList(self.imgformat.currentIndex())
      self.DeviceTypeCB.addItems(List)
      self.DeviceTypeCB.setCurrentIndex(self.DeviceTypeCB.findText(self.VideoporamaInstance.ConfOFDDeviceType))
      self.ChgDeviceType(self.DeviceTypeCB.currentIndex())
      self.DeviceModelCB.setCurrentIndex(self.DeviceModelCB.findText(self.VideoporamaInstance.ConfOFDDeviceModel))
      self.ChgDeviceModel(self.DeviceModelCB.currentIndex())
      self.OutputCodecCB.setCurrentIndex(self.OutputCodecCB.findText(self.VideoporamaInstance.ConfOFDOutputCodec))
      self.ChgOutputCodec(self.OutputCodecCB.currentIndex())
      self.OutputFormatCB.setCurrentIndex(self.OutputFormatCB.findText(self.VideoporamaInstance.ConfOFDOutputFormat))
      self.connect(self.imgformat,SIGNAL("currentIndexChanged(int)"),self.ChgImgFormat)
      self.connect(self.DeviceTypeCB,SIGNAL("currentIndexChanged(int)"),self.ChgDeviceType)
      self.connect(self.DeviceModelCB,SIGNAL("currentIndexChanged(int)"),self.ChgDeviceModel)
      self.connect(self.OutputCodecCB,SIGNAL("currentIndexChanged(int)"),self.ChgOutputCodec)

      #TAB Standards project options : Init & Signal
      self.InitIntOption(self.FirstShotStaticTime,'time',self.VideoporamaInstance.ConfTime)
      self.InitIntOption(self.NextShotStaticTime,'time',self.VideoporamaInstance.ConfStaticTimeNext)
      self.InitIntOption(self.NextShotMobilTime,'time',self.VideoporamaInstance.ConfAnimTimeNext)
      self.InitCBOption(self.speedt,'speedt',self.VideoporamaInstance.ConfSpeedT)
      self.InitCBOption(self.typet,'typet',self.VideoporamaInstance.ConfTypeT)
      self.ChgTrOption(self.typet.currentIndex())
      self.InitCBOption(self.transiopt,'transiopt',self.VideoporamaInstance.ConfTransiOpt)
      self.InitTextOption(self.bgfile,'bgfile',self.VideoporamaInstance.ConfBgFile)
      xcolor=QString(self.VideoporamaInstance.ConfBgColor).toInt(16)[0]
      qp=QPalette()
      qp.setColor(QPalette.Base,toqcolor(xcolor)) 
      self.bgcolor.setPalette(qp)
      self.bgcolor.setText(colortohex(xcolor))
      self.connect(self.bgcolora,SIGNAL("clicked()"),self.BrowseBgColor)
      self.connect(self.bgfilea,SIGNAL("clicked()"),self.ChgBgFile)
      self.connect(self.typet,SIGNAL("currentIndexChanged(int)"),self.ChgTrOption)
      self.connect(self.HelpBt,SIGNAL("pressed()"),self.Documentation)

      #End of init : Display the dialog box
      self.SetupInterface()
      #self.show()

    def SetupInterface(self):
      #-------------------------------------------------------------------------- Overlaid Text
      #Alignment
      self.TOverlaidtextLeft.setChecked(self.VideoporamaInstance.TOverlaidHAlign==0)
      self.TOverlaidtextLeft.setDown(self.VideoporamaInstance.TOverlaidHAlign==0)
      self.TOverlaidtextCenter.setChecked(self.VideoporamaInstance.TOverlaidHAlign==1)
      self.TOverlaidtextCenter.setDown(self.VideoporamaInstance.TOverlaidHAlign==1)
      self.TOverlaidtextJustif.setChecked(self.VideoporamaInstance.TOverlaidHAlign==3)
      self.TOverlaidtextJustif.setDown(self.VideoporamaInstance.TOverlaidHAlign==3)
      self.TOverlaidtextRight.setChecked(self.VideoporamaInstance.TOverlaidHAlign==2)
      self.TOverlaidtextRight.setDown(self.VideoporamaInstance.TOverlaidHAlign==2)
      self.TOverlaidtextUp.setChecked(self.VideoporamaInstance.TOverlaidVAlign==0)
      self.TOverlaidtextUp.setDown(self.VideoporamaInstance.TOverlaidVAlign==0)
      self.TOverlaidtextVCenter.setChecked(self.VideoporamaInstance.TOverlaidVAlign==1)
      self.TOverlaidtextVCenter.setDown(self.VideoporamaInstance.TOverlaidVAlign==1)
      self.TOverlaidtextBottom.setChecked(self.VideoporamaInstance.TOverlaidVAlign==2)
      self.TOverlaidtextBottom.setDown(self.VideoporamaInstance.TOverlaidVAlign==2)
      #Style
      self.TOverlaidStyleShadowColorBt.setDisabled(self.VideoporamaInstance.TOverlaidStyleText==0)
      self.TOverlaidfontStyleCB.setCurrentIndex(self.TOverlaidfontStyleCB.findText(QString(self.VideoporamaInstance.TOverlaidFontName)))
      self.TOverlaidfontSize.setCurrentIndex(self.TOverlaidfontSize.findText(unicode(self.VideoporamaInstance.TOverlaidFontSize)))
      self.TOverlaidfontEffectCB.setCurrentIndex(self.VideoporamaInstance.TOverlaidStyleText)
      self.TOverlaidbold.setChecked(self.VideoporamaInstance.TOverlaidIsBold)
      self.TOverlaidbold.setDown(self.VideoporamaInstance.TOverlaidIsBold)
      self.TOverlaidItalic.setChecked(self.VideoporamaInstance.TOverlaidIsItalic)
      self.TOverlaidItalic.setDown(self.VideoporamaInstance.TOverlaidIsItalic)
      self.TOverlaidSouligne.setChecked(self.VideoporamaInstance.TOverlaidIsUnderline)
      self.TOverlaidSouligne.setDown(self.VideoporamaInstance.TOverlaidIsUnderline)
      #Frame options
      self.TOverlaidBackgroundStyleCB.setDisabled(self.VideoporamaInstance.TOverlaidBackgroundForm==0)
      self.TOverlaidBackgroundColorBt.setDisabled(self.VideoporamaInstance.TOverlaidBackgroundForm==0 or self.VideoporamaInstance.TOverlaidBackgroundStyle==4)
      self.TOverlaidPenSizeEd.setDisabled(self.VideoporamaInstance.TOverlaidBackgroundForm==0)
      self.TOverlaidPenColorBt.setDisabled(self.VideoporamaInstance.TOverlaidBackgroundForm==0 or self.VideoporamaInstance.TOverlaidPenSize==0)
      self.TOverlaidBackgroundFormCB.setCurrentIndex(self.VideoporamaInstance.TOverlaidBackgroundForm)
      self.TOverlaidBackgroundStyleCB.setCurrentIndex(self.VideoporamaInstance.TOverlaidBackgroundStyle)
      self.TOverlaidPenSizeEd.setValue(int(self.VideoporamaInstance.TOverlaidPenSize))
      #-------------------------------------------------------------------------- BackGround Text
      #Alignment
      self.TBackGtextLeft.setChecked(self.VideoporamaInstance.TBackGHAlign==0)
      self.TBackGtextLeft.setDown(self.VideoporamaInstance.TBackGHAlign==0)
      self.TBackGtextCenter.setChecked(self.VideoporamaInstance.TBackGHAlign==1)
      self.TBackGtextCenter.setDown(self.VideoporamaInstance.TBackGHAlign==1)
      self.TBackGtextJustif.setChecked(self.VideoporamaInstance.TBackGHAlign==3)
      self.TBackGtextJustif.setDown(self.VideoporamaInstance.TBackGHAlign==3)
      self.TBackGtextRight.setChecked(self.VideoporamaInstance.TBackGHAlign==2)
      self.TBackGtextRight.setDown(self.VideoporamaInstance.TBackGHAlign==2)
      self.TBackGtextUp.setChecked(self.VideoporamaInstance.TBackGVAlign==0)
      self.TBackGtextUp.setDown(self.VideoporamaInstance.TBackGVAlign==0)
      self.TBackGtextVCenter.setChecked(self.VideoporamaInstance.TBackGVAlign==1)
      self.TBackGtextVCenter.setDown(self.VideoporamaInstance.TBackGVAlign==1)
      self.TBackGtextBottom.setChecked(self.VideoporamaInstance.TBackGVAlign==2)
      self.TBackGtextBottom.setDown(self.VideoporamaInstance.TBackGVAlign==2)
      #Style
      self.TBackGStyleShadowColorBt.setDisabled(self.VideoporamaInstance.TBackGStyleText==0)
      self.TBackGfontStyleCB.setCurrentIndex(self.TBackGfontStyleCB.findText(QString(self.VideoporamaInstance.TBackGFontName)))
      self.TBackGfontSize.setCurrentIndex(self.TBackGfontSize.findText(unicode(self.VideoporamaInstance.TBackGFontSize)))
      self.TBackGfontEffectCB.setCurrentIndex(self.VideoporamaInstance.TBackGStyleText)
      self.TBackGbold.setChecked(self.VideoporamaInstance.TBackGIsBold)
      self.TBackGbold.setDown(self.VideoporamaInstance.TBackGIsBold)
      self.TBackGItalic.setChecked(self.VideoporamaInstance.TBackGIsItalic)
      self.TBackGItalic.setDown(self.VideoporamaInstance.TBackGIsItalic)
      self.TBackGSouligne.setChecked(self.VideoporamaInstance.TBackGIsUnderline)
      self.TBackGSouligne.setDown(self.VideoporamaInstance.TBackGIsUnderline)
      #Frame options
      self.TBackGBackgroundStyleCB.setDisabled(self.VideoporamaInstance.TBackGBackgroundForm==0)
      self.TBackGBackgroundColorBt.setDisabled(self.VideoporamaInstance.TBackGBackgroundForm==0 or self.VideoporamaInstance.TBackGBackgroundStyle==4)
      self.TBackGPenSizeEd.setDisabled(self.VideoporamaInstance.TBackGBackgroundForm==0)
      self.TBackGPenColorBt.setDisabled(self.VideoporamaInstance.TBackGBackgroundForm==0 or self.VideoporamaInstance.TBackGPenSize==0)
      self.TBackGBackgroundFormCB.setCurrentIndex(self.VideoporamaInstance.TBackGBackgroundForm)
      self.TBackGBackgroundStyleCB.setCurrentIndex(self.VideoporamaInstance.TBackGBackgroundStyle)
      self.TBackGPenSizeEd.setValue(int(self.VideoporamaInstance.TBackGPenSize))
      #-------------------------------------------------------------------------- Shot Text
      #Alignment
      self.TShottextLeft.setChecked(self.VideoporamaInstance.TShotHAlign==0)
      self.TShottextLeft.setDown(self.VideoporamaInstance.TShotHAlign==0)
      self.TShottextCenter.setChecked(self.VideoporamaInstance.TShotHAlign==1)
      self.TShottextCenter.setDown(self.VideoporamaInstance.TShotHAlign==1)
      self.TShottextJustif.setChecked(self.VideoporamaInstance.TShotHAlign==3)
      self.TShottextJustif.setDown(self.VideoporamaInstance.TShotHAlign==3)
      self.TShottextRight.setChecked(self.VideoporamaInstance.TShotHAlign==2)
      self.TShottextRight.setDown(self.VideoporamaInstance.TShotHAlign==2)
      self.TShottextUp.setChecked(self.VideoporamaInstance.TShotVAlign==0)
      self.TShottextUp.setDown(self.VideoporamaInstance.TShotVAlign==0)
      self.TShottextVCenter.setChecked(self.VideoporamaInstance.TShotVAlign==1)
      self.TShottextVCenter.setDown(self.VideoporamaInstance.TShotVAlign==1)
      self.TShottextBottom.setChecked(self.VideoporamaInstance.TShotVAlign==2)
      self.TShottextBottom.setDown(self.VideoporamaInstance.TShotVAlign==2)
      #Style
      self.TShotStyleShadowColorBt.setDisabled(self.VideoporamaInstance.TShotStyleText==0)
      self.TShotfontStyleCB.setCurrentIndex(self.TShotfontStyleCB.findText(QString(self.VideoporamaInstance.TShotFontName)))
      self.TShotfontSize.setCurrentIndex(self.TShotfontSize.findText(unicode(self.VideoporamaInstance.TShotFontSize)))
      self.TShotfontEffectCB.setCurrentIndex(self.VideoporamaInstance.TShotStyleText)
      self.TShotbold.setChecked(self.VideoporamaInstance.TShotIsBold)
      self.TShotbold.setDown(self.VideoporamaInstance.TShotIsBold)
      self.TShotItalic.setChecked(self.VideoporamaInstance.TShotIsItalic)
      self.TShotItalic.setDown(self.VideoporamaInstance.TShotIsItalic)
      self.TShotSouligne.setChecked(self.VideoporamaInstance.TShotIsUnderline)
      self.TShotSouligne.setDown(self.VideoporamaInstance.TShotIsUnderline)
      #Frame options
      self.TShotBackgroundStyleCB.setDisabled(self.VideoporamaInstance.TShotBackgroundForm==0)
      self.TShotBackgroundColorBt.setDisabled(self.VideoporamaInstance.TShotBackgroundForm==0 or self.VideoporamaInstance.TShotBackgroundStyle==4)
      self.TShotPenSizeEd.setDisabled(self.VideoporamaInstance.TShotBackgroundForm==0)
      self.TShotPenColorBt.setDisabled(self.VideoporamaInstance.TShotBackgroundForm==0 or self.VideoporamaInstance.TShotPenSize==0)
      self.TShotBackgroundFormCB.setCurrentIndex(self.VideoporamaInstance.TShotBackgroundForm)
      self.TShotBackgroundStyleCB.setCurrentIndex(self.VideoporamaInstance.TShotBackgroundStyle)
      self.TShotPenSizeEd.setValue(int(self.VideoporamaInstance.TShotPenSize))

    #----------------------------------------------------------------------------------------
    # Documentation Dialog box
    #----------------------------------------------------------------------------------------
    def Documentation(self) :
      docw=DocHelp(self.VideoporamaInstance ,self.VideoporamaInstance.qtapp.translate("Documentation","en-configbox.html"),self.VideoporamaInstance.win)
      docw.show() 

    def ChgDeviceType(self,index):
      self.DeviceModelCB.clear()
      List=self.VideoporamaInstance.OutputOFDXMLObject.GetOFDDeviceModelCBList(self.DeviceTypeCB.currentText(),self.imgformat.currentIndex())
      self.DeviceModelCB.addItems(List)
      self.ChgDeviceModel(0)

    def ChgDeviceModel(self,index):
      self.OutputCodecCB.clear()
      List=self.VideoporamaInstance.OutputOFDXMLObject.GetOFDOutputCodecCBList(self.DeviceTypeCB.currentText(),self.DeviceModelCB.currentText(),self.imgformat.currentIndex())
      self.OutputCodecCB.addItems(List)
      self.ChgOutputCodec(0)

    def ChgOutputCodec(self,index):
      self.OutputFormatCB.clear()
      List=self.VideoporamaInstance.OutputOFDXMLObject.GetOFDOutputFormatList(self.DeviceTypeCB.currentText(),self.DeviceModelCB.currentText(),self.OutputCodecCB.currentText(),self.imgformat.currentIndex())
      self.OutputFormatCB.addItems(List)
      if self.OutputFormatCB.count()==0:
        self.OutputFormatCB.addItem(self.VideoporamaInstance.qtapp.translate("main","No available format - Check config"))

    def ChgImgFormat(self,index):
      aDevice=self.DeviceTypeCB.currentIndex()
      aModel=self.DeviceModelCB.currentIndex()
      aCodec=self.OutputCodecCB.currentIndex()
      self.ChgDeviceType(aDevice)
      self.ChgDeviceModel(aModel)
      self.ChgOutputCodec(aCodec)

    #sub to init a Text LineEdit
    def InitTextOption(self,object,XmlName,default):
      try:
        object.setText(self.ConfigXMLObject.getElementsByTagName(XmlName)[0].childNodes[0].nodeValue)
      except:
        object.setText(default)

    #sub to init a ComboBox
    def InitCBOption(self,object,XmlName,default):
      try:
        object.setCurrentIndex(int(self.ConfigXMLObject.getElementsByTagName(XmlName)[0].childNodes[0].nodeValue))
      except:
        object.setCurrentIndex(int(default))

    #sub to init a Int LineEdit
    def InitIntOption(self,object,XmlName,default):
      try:
        object.setValue(int(self.ConfigXMLObject.getElementsByTagName(XmlName)[0].childNodes[0].nodeValue))
      except:
        object.setValue(int(default))

    #Function call each time transition choice is change => update option transition list
    def ChgTrOption(self,index) :
      #Load Transition Option from Transition selected
      z=getTrOptionLst(self.VideoporamaInstance,index)
      self.transiopt.clear()
      i=0;
      max=len(z)
      while i<max:
        if index==7:
          FNameTr=u"iconstr/"+z[i]+u".png"
        else:
          FNameTr=u"iconstr/tr-0"+unicode(index)+u"-0"+unicode(i)+u".png"
        try:
          self.transiopt.addItem(QIcon(FNameTr),z[i])
        except:
          self.transiopt.addItem(z[i])
        i=i+1
           
    def ChTMPDirEd(self) :
      Path=validatePath(self.tmpdir.text())
      if (Path!=""):
        self.VideoporamaInstance.T=unicode(Path)
        self.tmpdir.setText(self.VideoporamaInstance.T)
        UpdateConfigurationXMLFile(self.VideoporamaInstance.ConfigXMLObject,"tmpdir",self.VideoporamaInstance.T,1)

    # Action button to browse for directory : TempDir
    def ChTMPDir(self): 
      Path=validatePath(QFileDialog.getExistingDirectory(self, self.VideoporamaInstance.qtapp.translate("main","Directory Dialog"), self.VideoporamaInstance.T))
      if (Path!=""):
        self.VideoporamaInstance.T=unicode(Path)
        self.tmpdir.setText(self.VideoporamaInstance.T)
        UpdateConfigurationXMLFile(self.VideoporamaInstance.ConfigXMLObject,"tmpdir",self.VideoporamaInstance.T,1)

    def ChFFMPEGDirEd(self) :
      Path=validatePath(self.imgmgkdir.text())
      if (Path!=""):
        self.VideoporamaInstance.I=unicode(Path)
        self.imgmgkdir.setText(self.VideoporamaInstance.I)
        UpdateConfigurationXMLFile(self.VideoporamaInstance.ConfigXMLObject,"imgmgkdir",self.VideoporamaInstance.I,1)

    # Action button to browse for directory : FFMPEGDir
    def ChFFMPEGDir(self): 
      Path=validatePath(QFileDialog.getExistingDirectory(self, self.VideoporamaInstance.qtapp.translate("main","Directory Dialog"), self.VideoporamaInstance.I))
      if (Path!=""):
        self.VideoporamaInstance.I=Path
        self.imgmgkdir.setText(self.VideoporamaInstance.I)
        UpdateConfigurationXMLFile(self.VideoporamaInstance.ConfigXMLObject,"imgmgkdir",self.VideoporamaInstance.I,1)

    def ChMJPEGToolsDirEd(self) :
      Path=validatePath(self.mjpegtoolsdir.text())
      if (Path!=""):
        self.VideoporamaInstance.MJ=Path
        self.mjpegtoolsdir.setText(self.VideoporamaInstance.MJ)
        UpdateConfigurationXMLFile(self.VideoporamaInstance.ConfigXMLObject,"mjpegtoolsdir",self.VideoporamaInstance.MJ,1)

    # Action button to browse for directory : MJPEGToolsDir
    def ChMJPEGToolsDir(self): 
      Path=validatePath(QFileDialog.getExistingDirectory(self, self.VideoporamaInstance.qtapp.translate("main","Directory Dialog"), self.VideoporamaInstance.MJ))
      if (Path!=""):
        self.MJ=Path
        self.mjpegtoolsdir.setText(self.MJ)
        UpdateConfigurationXMLFile(self.VideoporamaInstance.ConfigXMLObject,"mjpegtoolsdir",self.MJ,1)

    def ChSOXDirEd(self) :
      Path=validatePath(self.soxdir.text())
      if (Path!=""):
        self.VideoporamaInstance.S=Path
        self.soxdir.setText(self.VideoporamaInstance.S)
        UpdateConfigurationXMLFile(self.VideoporamaInstance.ConfigXMLObject,"soxdir",self.VideoporamaInstance.S,1)

    # Action button to browse for directory : SOXDir
    def ChSOXDir(self): 
      Path=validatePath(QFileDialog.getExistingDirectory(self, self.VideoporamaInstance.qtapp.translate("main","Directory Dialog"), self.VideoporamaInstance.S))
      if (Path!=""):
        self.VideoporamaInstance.S=Path
        self.soxdir.setText(self.VideoporamaInstance.S)
        UpdateConfigurationXMLFile(self.VideoporamaInstance.ConfigXMLObject,"soxdir",self.VideoporamaInstance.S,1)

    def ChMPlayerDirEd(self) :
      Path=validatePath(self.mplayerdir.text())
      if (Path!=""):
        self.VideoporamaInstance.MP=Path
        self.mplayerdir.setText(self.VideoporamaInstance.MP)
        UpdateConfigurationXMLFile(self.VideoporamaInstance.ConfigXMLObject,"mplayerdir",self.VideoporamaInstance.MP,1)

    # Action button to browse for directory : MPlayerDir
    def ChMPlayerDir(self): 
      Path=validatePath(QFileDialog.getExistingDirectory(self, self.VideoporamaInstance.qtapp.translate("main","Directory Dialog"), self.VideoporamaInstance.MP))
      if (Path!=""):
        self.VideoporamaInstance.MP=Path
        self.mplayerdir.setText(self.VideoporamaInstance.MP)
        UpdateConfigurationXMLFile(self.ConfigXMLObject,"mplayerdir",self.VideoporamaInstance.MP,1)

    # Action button to select a background file
    def ChgBgFile(self): #OK QT4
      file=QFileDialog.getOpenFileName(self, self.VideoporamaInstance.qtapp.translate("main","File Dialog"),self.VideoporamaInstance.lastDirBackground, "Image(*.jpg *.JPG *.png *.PNG *.gif *.GIF *.xpm *.XPM)")
      if file!="":
        self.VideoporamaInstance.lastDirBackground=os.path.split(unicode(file))[0]
        self.bgfile.setText(file)

    # Action button to browse for GIMP
    def ChImageEditor(self): 
      Path=validatePath(QFileDialog.getOpenFileName(self, self.VideoporamaInstance.qtapp.translate("main","Select Image Editor"),"", "All files (*)"),False)
      if (Path!=""):
        self.VideoporamaInstance.ImageEditor=Path
        self.ImageEditor.setText(self.VideoporamaInstance.ImageEditor)
        UpdateConfigurationXMLFile(self.VideoporamaInstance.ConfigXMLObject,"ImageEditor",self.VideoporamaInstance.ImageEditor,1)

    def ChImageEditorEd(self): 
      Path=validatePath(self.ImageEditor.text(),False)
      if (Path!=""):
        self.VideoporamaInstance.ImageEditor=Path
        self.ImageEditor.setText(self.VideoporamaInstance.ImageEditor)
        UpdateConfigurationXMLFile(self.VideoporamaInstance.ConfigXMLObject,"ImageEditor",self.VideoporamaInstance.ImageEditor,1)
        
    # Action button to select a background color
    def BrowseBgColor(self):
      color=QColorDialog.getColor(toqcolor(QString(self.VideoporamaInstance.ConfBgColor).toInt(16)[0]),self)
      qp=QPalette()
      qp.setColor(QPalette.Base,color)
      self.bgcolor.setPalette(qp)
      red=color.red()
      green=color.green()
      blue=color.blue()
      self.VideoporamaInstance.ConfBgColor=colortohex(red*65536+green*256+blue)
      self.bgcolor.setText(self.VideoporamaInstance.ConfBgColor)

    # Change unit display mode
    def ChDisplayUnitOption(self,txt):
      self.VideoporamaInstance.ConfDisplayUnit = unicode(txt)
      #Setup interface
      self.VideoporamaInstance.App_SetupInterface()

    def check_CheckConfig(self):
      #if call was made from the configuration dialog box, first save the config
      self.SaveConfig(False)
      self.VideoporamaInstance.check_CheckConfig(True,False)

    #---------------------------------------------------------- Default Overlaid text options

    def TOverlaidChangeFont(self,font) :
      if font.family()!="":
        self.VideoporamaInstance.TOverlaidFontName=font.family()
        self.SetupInterface()

    def TOverlaidChangeSizeFont(self,size) :
      if QString(size)!="" :
        self.VideoporamaInstance.TOverlaidFontSize=int(size)
        self.SetupInterface()

    def TOverlaidChangeStyleFont(self,Style) :
      self.VideoporamaInstance.TOverlaidStyleText=Style
      self.SetupInterface()

    def TOverlaidChangeBackgroundForm(self,Style) :
      self.VideoporamaInstance.TOverlaidBackgroundForm=Style
      self.SetupInterface()

    def TOverlaidChangeBackgroundStyle(self,Style) :
      self.VideoporamaInstance.TOverlaidBackgroundStyle=Style
      self.SetupInterface()

    def TOverlaidSetItalic(self) :
      if self.VideoporamaInstance.TOverlaidIsItalic==True: self.VideoporamaInstance.TOverlaidIsItalic=False
      else: self.VideoporamaInstance.TOverlaidIsItalic=True
      self.SetupInterface()

    def TOverlaidSetBold(self) :
      if self.VideoporamaInstance.TOverlaidIsBold==True: self.VideoporamaInstance.TOverlaidIsBold=False
      else: self.VideoporamaInstance.TOverlaidIsBold=True
      self.SetupInterface()

    def TOverlaidSetUnderline(self) :
      if self.VideoporamaInstance.TOverlaidIsUnderline==True: self.VideoporamaInstance.TOverlaidIsUnderline=False
      else: self.VideoporamaInstance.TOverlaidIsUnderline=True
      self.SetupInterface()

    def TOverlaidSetTextColor(self) :
      color=QColorDialog.getColor(Qt.black,self)
      red=color.red()
      green=color.green()
      blue=color.blue()
      self.VideoporamaInstance.TOverlaidFontColor=colortohex(red*65536+green*256+blue)
      self.SetupInterface()

    def TOverlaidSetFontShadowColor(self) :
      color=QColorDialog.getColor(Qt.black,self)
      red=color.red()
      green=color.green()
      blue=color.blue()
      self.VideoporamaInstance.TOverlaidFontShadowColor=colortohex(red*65536+green*256+blue)
      self.SetupInterface()

    def TOverlaidSetBackgroundColor(self) :
      color=QColorDialog.getColor(Qt.black,self)
      red=color.red()
      green=color.green()
      blue=color.blue()
      self.VideoporamaInstance.TOverlaidBackgroundColor=colortohex(red*65536+green*256+blue)
      self.SetupInterface()

    def TOverlaidSetPenColor(self) :
      color=QColorDialog.getColor(Qt.black,self)
      red=color.red()
      green=color.green()
      blue=color.blue()
      self.VideoporamaInstance.TOverlaidPenColor=colortohex(red*65536+green*256+blue)
      self.SetupInterface()

    def TOverlaidChgPenSize(self,Value):
      self.VideoporamaInstance.TOverlaidPenSize=Value
      self.SetupInterface()

    def TOverlaidSetTextHAlign(self,HAlign) :
      self.VideoporamaInstance.TOverlaidHAlign=HAlign
      self.SetupInterface()
      
    def TOverlaidSetTextLeft(self) :
      self.VideoporamaInstance.TOverlaidHAlign=0
      self.SetupInterface()

    def TOverlaidSetTextCenter(self) :
      self.VideoporamaInstance.TOverlaidHAlign=1
      self.SetupInterface()

    def TOverlaidSetTextRight(self) :
      self.VideoporamaInstance.TOverlaidHAlign=2
      self.SetupInterface()

    def TOverlaidSetTextJustif(self) :
      self.VideoporamaInstance.TOverlaidHAlign=3
      self.SetupInterface()
      
    def TOverlaidSetTextUp(self) :
      self.VideoporamaInstance.TOverlaidVAlign=0
      self.SetupInterface()

    def TOverlaidSetTextVCenter(self) :
      self.VideoporamaInstance.TOverlaidVAlign=1
      self.SetupInterface()

    def TOverlaidSetTextBottom(self) :
      self.VideoporamaInstance.TOverlaidVAlign=2
      self.SetupInterface()

    #---------------------------------------------------------- Default BackGround text options

    def TBackGChangeFont(self,font) :
      if font.family()!="":
        self.VideoporamaInstance.TBackGFontName=font.family()
        self.SetupInterface()

    def TBackGChangeSizeFont(self,size) :
      if QString(size)!="" :
        self.VideoporamaInstance.TBackGFontSize=int(size)
        self.SetupInterface()

    def TBackGChangeStyleFont(self,Style) :
      self.VideoporamaInstance.TBackGStyleText=Style
      self.SetupInterface()

    def TBackGChangeBackgroundForm(self,Style) :
      self.VideoporamaInstance.TBackGBackgroundForm=Style
      self.SetupInterface()

    def TBackGChangeBackgroundStyle(self,Style) :
      self.VideoporamaInstance.TBackGBackgroundStyle=Style
      self.SetupInterface()

    def TBackGSetItalic(self) :
      if self.VideoporamaInstance.TBackGIsItalic==True: self.VideoporamaInstance.TBackGIsItalic=False
      else: self.VideoporamaInstance.TBackGIsItalic=True
      self.SetupInterface()

    def TBackGSetBold(self) :
      if self.VideoporamaInstance.TBackGIsBold==True: self.VideoporamaInstance.TBackGIsBold=False
      else: self.VideoporamaInstance.TBackGIsBold=True
      self.SetupInterface()

    def TBackGSetUnderline(self) :
      if self.VideoporamaInstance.TBackGIsUnderline==True: self.VideoporamaInstance.TBackGIsUnderline=False
      else: self.VideoporamaInstance.TBackGIsUnderline=True
      self.SetupInterface()

    def TBackGSetTextColor(self) :
      color=QColorDialog.getColor(Qt.black,self)
      red=color.red()
      green=color.green()
      blue=color.blue()
      self.VideoporamaInstance.TBackGFontColor=colortohex(red*65536+green*256+blue)
      self.SetupInterface()

    def TBackGSetFontShadowColor(self) :
      color=QColorDialog.getColor(Qt.black,self)
      red=color.red()
      green=color.green()
      blue=color.blue()
      self.VideoporamaInstance.TBackGFontShadowColor=colortohex(red*65536+green*256+blue)
      self.SetupInterface()

    def TBackGSetBackgroundColor(self) :
      color=QColorDialog.getColor(Qt.black,self)
      red=color.red()
      green=color.green()
      blue=color.blue()
      self.VideoporamaInstance.TBackGBackgroundColor=colortohex(red*65536+green*256+blue)
      self.SetupInterface()

    def TBackGSetPenColor(self) :
      color=QColorDialog.getColor(Qt.black,self)
      red=color.red()
      green=color.green()
      blue=color.blue()
      self.VideoporamaInstance.TBackGPenColor=colortohex(red*65536+green*256+blue)
      self.SetupInterface()

    def TBackGChgPenSize(self,Value):
      self.VideoporamaInstance.TBackGPenSize=Value
      self.SetupInterface()

    def TBackGSetTextHAlign(self,HAlign) :
      self.VideoporamaInstance.TBackGHAlign=HAlign
      self.SetupInterface()
      
    def TBackGSetTextLeft(self) :
      self.VideoporamaInstance.TBackGHAlign=0
      self.SetupInterface()

    def TBackGSetTextCenter(self) :
      self.VideoporamaInstance.TBackGHAlign=1
      self.SetupInterface()

    def TBackGSetTextRight(self) :
      self.VideoporamaInstance.TBackGHAlign=2
      self.SetupInterface()

    def TBackGSetTextJustif(self) :
      self.VideoporamaInstance.TBackGHAlign=3
      self.SetupInterface()
      
    def TBackGSetTextUp(self) :
      self.VideoporamaInstance.TBackGVAlign=0
      self.SetupInterface()

    def TBackGSetTextVCenter(self) :
      self.VideoporamaInstance.TBackGVAlign=1
      self.SetupInterface()

    def TBackGSetTextBottom(self) :
      self.VideoporamaInstance.TBackGVAlign=2
      self.SetupInterface()

    #---------------------------------------------------------- Default Shot text options

    def TShotChangeFont(self,font) :
      if font.family()!="":
        self.VideoporamaInstance.TShotFontName=font.family()
        self.SetupInterface()

    def TShotChangeSizeFont(self,size) :
      if QString(size)!="" :
        self.VideoporamaInstance.TShotFontSize=int(size)
        self.SetupInterface()

    def TShotChangeStyleFont(self,Style) :
      self.VideoporamaInstance.TShotStyleText=Style
      self.SetupInterface()

    def TShotChangeBackgroundForm(self,Style) :
      self.VideoporamaInstance.TShotBackgroundForm=Style
      self.SetupInterface()

    def TShotChangeBackgroundStyle(self,Style) :
      self.VideoporamaInstance.TShotBackgroundStyle=Style
      self.SetupInterface()

    def TShotSetItalic(self) :
      if self.VideoporamaInstance.TShotIsItalic==True: self.VideoporamaInstance.TShotIsItalic=False
      else: self.VideoporamaInstance.TShotIsItalic=True
      self.SetupInterface()

    def TShotSetBold(self) :
      if self.VideoporamaInstance.TShotIsBold==True: self.VideoporamaInstance.TShotIsBold=False
      else: self.VideoporamaInstance.TShotIsBold=True
      self.SetupInterface()

    def TShotSetUnderline(self) :
      if self.VideoporamaInstance.TShotIsUnderline==True: self.VideoporamaInstance.TShotIsUnderline=False
      else: self.VideoporamaInstance.TShotIsUnderline=True
      self.SetupInterface()

    def TShotSetTextColor(self) :
      color=QColorDialog.getColor(Qt.black,self)
      red=color.red()
      green=color.green()
      blue=color.blue()
      self.VideoporamaInstance.TShotFontColor=colortohex(red*65536+green*256+blue)
      self.SetupInterface()

    def TShotSetFontShadowColor(self) :
      color=QColorDialog.getColor(Qt.black,self)
      red=color.red()
      green=color.green()
      blue=color.blue()
      self.VideoporamaInstance.TShotFontShadowColor=colortohex(red*65536+green*256+blue)
      self.SetupInterface()

    def TShotSetBackgroundColor(self) :
      color=QColorDialog.getColor(Qt.black,self)
      red=color.red()
      green=color.green()
      blue=color.blue()
      self.VideoporamaInstance.TShotBackgroundColor=colortohex(red*65536+green*256+blue)
      self.SetupInterface()

    def TShotSetPenColor(self) :
      color=QColorDialog.getColor(Qt.black,self)
      red=color.red()
      green=color.green()
      blue=color.blue()
      self.VideoporamaInstance.TShotPenColor=colortohex(red*65536+green*256+blue)
      self.SetupInterface()

    def TShotChgPenSize(self,Value):
      self.VideoporamaInstance.TShotPenSize=Value
      self.SetupInterface()

    def TShotSetTextHAlign(self,HAlign) :
      self.VideoporamaInstance.TShotHAlign=HAlign
      self.SetupInterface()
      
    def TShotSetTextLeft(self) :
      self.VideoporamaInstance.TShotHAlign=0
      self.SetupInterface()

    def TShotSetTextCenter(self) :
      self.VideoporamaInstance.TShotHAlign=1
      self.SetupInterface()

    def TShotSetTextRight(self) :
      self.VideoporamaInstance.TShotHAlign=2
      self.SetupInterface()

    def TShotSetTextJustif(self) :
      self.VideoporamaInstance.TShotHAlign=3
      self.SetupInterface()
      
    def TShotSetTextUp(self) :
      self.VideoporamaInstance.TShotVAlign=0
      self.SetupInterface()

    def TShotSetTextVCenter(self) :
      self.VideoporamaInstance.TShotVAlign=1
      self.SetupInterface()

    def TShotSetTextBottom(self) :
      self.VideoporamaInstance.TShotVAlign=2
      self.SetupInterface()

    #----------------------------------------------------------------------------------------------------------

    # Save configuration to XML File
    def SaveConfig(self,ToClose=True): 
      # configurations elements
      if self.VideoporamaInstance.IsPortable==False :
        self.VideoporamaInstance.T                  =self.tmpdir.text()          # tmp directory
        self.VideoporamaInstance.I                  =self.imgmgkdir.text()       # ffmpeg directory
        self.VideoporamaInstance.MJ                 =self.mjpegtoolsdir.text()   # mjpegtools directory
        self.VideoporamaInstance.S                  =self.soxdir.text()          # SOX directory
        self.VideoporamaInstance.MP                 =self.mplayerdir.text()      # mplayer directory
        
      self.VideoporamaInstance.ConfBgFile         =self.bgfile.text()
      self.VideoporamaInstance.ConfBgColor        =self.bgcolor.text()
      self.VideoporamaInstance.ConfTime           =self.FirstShotStaticTime.text()
      self.VideoporamaInstance.ConfStaticTimeNext =self.NextShotStaticTime.text()
      self.VideoporamaInstance.ConfAnimTimeNext   =self.NextShotMobilTime.text()
      self.VideoporamaInstance.ConfSpeedT         =self.speedt.currentIndex()
      self.VideoporamaInstance.ConfTypeT          =self.typet.currentIndex()
      self.VideoporamaInstance.ConfTransiOpt      =self.transiopt.currentIndex()
      self.VideoporamaInstance.ConfImgFormat      =self.imgformat.currentIndex()
      self.VideoporamaInstance.ConfDisplayUnit    =unicode(self.DisplayUnitMode.currentIndex())
      self.VideoporamaInstance.NewSEQPosition     =int(self.NewSEQPosition.currentIndex())
      self.VideoporamaInstance.RestoreWindowState =self.RestoreWindowState.currentIndex()
      self.VideoporamaInstance.ConfOFDDeviceType  =self.DeviceTypeCB.currentText()
      self.VideoporamaInstance.ConfOFDDeviceModel =self.DeviceModelCB.currentText()
      self.VideoporamaInstance.ConfOFDOutputCodec =self.OutputCodecCB.currentText()
      self.VideoporamaInstance.ConfOFDOutputFormat=self.OutputFormatCB.currentText()
      self.VideoporamaInstance.App_SaveConfig()
      if ToClose==True: self.close()
