#!/usr/bin/env python
"""
Usage:
  ./localrun.py --name=mytestmodulename --verbosity=[0|1|...|N] --local=[0|1]
"""

import sys

# get commandline options
import getopt
longoptions  = ["name=", "verbosity=", "local="]
opt, args = getopt.getopt(sys.argv[1:], "", longoptions)
 
# set default options       
name      = "runall"
verbosity = 0
local     = 0

# override defaults if provided
for o in opt:
    oname = o[0].strip("-")
    s = "%s = %s.__class__(%s)" % (oname, oname, repr(o[1]))
    exec(s)

# optionally use the local uninstalled SyFi and sfc modules
if local:
    import os.path as p
    syfipath = p.abspath( p.join(p.curdir, p.pardir) )
    sys.path.insert(0, syfipath)

# import module and run test
m = __import__(name)
m.test(verbosity)

