use core:debug;
use core:asm;
use core:lang;

AsmOperand number(Str size, Str value) {
	if (size == "b") {
		byteConst(value.toInt.byte);
	} else if (size == "i") {
		intConst(value.toInt);
	} else if (size == "n") {
		natConst(value.toNat);
	} else if (size == "l") {
		longConst(value.toLong);
	} else if (size == "w") {
		wordConst(value.toWord);
	} else if (size == "p") {
		ptrConst(Offset(value.toInt));
	} else {
		// Fallback.
		intConst(value.toInt);
	}
}

// Assumes pointer-sized.
AsmOperand number(Str value) {
	ptrConst(Offset(value.toInt));
}

AsmOperand ptrNumber(Str? times) {
	Offset off(sPtr);
	if (times)
		off = off * times.toInt;
	ptrConst(off);
}

AsmOperand pointer(Str size, AsmOperand base, AsmOperand? offset) {
	Reg reg = base.value.reg;
	Offset off;
	if (offset)
		off = offset.value.offset;

	if (size == "b") {
		byteRel(reg, off);
	} else if (size == "i") {
		intRel(reg, off);
	} else if (size == "n") {
		intRel(reg, off);
	} else if (size == "l") {
		longRel(reg, off);
	} else if (size == "w") {
		longRel(reg, off);
	} else if (size == "p") {
		ptrRel(reg, off);
	} else {
		// Fallback.
		intRel(reg, off);
	}
}


/**
 * Various registers.
 */
AsmOperand rAl() { Operand(al); }
AsmOperand rBl() { Operand(bl); }
AsmOperand rCl() { Operand(cl); }
AsmOperand rEax() { Operand(eax); }
AsmOperand rEbx() { Operand(ebx); }
AsmOperand rEcx() { Operand(ecx); }
AsmOperand rRax() { Operand(rax); }
AsmOperand rRbx() { Operand(rbx); }
AsmOperand rRcx() { Operand(rcx); }
AsmOperand rPtrA() { Operand(ptrA); }
AsmOperand rPtrB() { Operand(ptrB); }
AsmOperand rPtrC() { Operand(ptrC); }
AsmOperand rPtrStack() { Operand(ptrStack); }
AsmOperand rPtrFrame() { Operand(ptrFrame); }
