/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLList;
import adql.query.ADQLObject;
import adql.query.ADQLSet;
import adql.query.ClauseADQL;
import adql.query.TextPosition;
import adql.query.constraint.ADQLConstraint;
import adql.query.operand.ADQLOperand;
import java.util.NoSuchElementException;

public class In
implements ADQLConstraint {
    public static final LanguageFeature FEATURE = new LanguageFeature(null, "IN", false, "An IN constrait (which tests whether a value is part of the given list of value or result of a sub-query).");
    private ADQLOperand leftOp;
    private ADQLSet subQuery;
    private ADQLList<ADQLOperand> list;
    private boolean notIn = false;
    private TextPosition position = null;

    public In(ADQLOperand op, ADQLSet query) throws NullPointerException {
        this(op, query, false);
    }

    public In(ADQLOperand op, ADQLSet query, boolean notIn) throws NullPointerException {
        this.setOperand(op);
        this.setSubQuery(query);
        this.setNotIn(notIn);
    }

    public In(ADQLOperand op, ADQLOperand[] valuesList) throws NullPointerException {
        this(op, valuesList, false);
    }

    public In(ADQLOperand op, ADQLOperand[] valuesList, boolean notIn) throws NullPointerException {
        this.setOperand(op);
        this.setValuesList(valuesList);
        this.setNotIn(notIn);
    }

    public In(ADQLOperand op, ADQLList<ADQLOperand> valuesList) throws NullPointerException {
        this(op, valuesList, false);
    }

    public In(ADQLOperand op, ADQLList<ADQLOperand> valuesList, boolean notIn) throws NullPointerException {
        this.setOperand(op);
        this.setValuesList(valuesList);
        this.setNotIn(notIn);
    }

    public In(In toCopy) throws Exception {
        this.leftOp = (ADQLOperand)toCopy.leftOp.getCopy();
        if (toCopy.hasSubQuery()) {
            this.setSubQuery((ADQLSet)toCopy.subQuery.getCopy());
        } else {
            this.setValuesList((ADQLList)toCopy.list.getCopy());
        }
        this.notIn = toCopy.notIn;
        this.position = toCopy.position == null ? null : new TextPosition(toCopy.position);
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    public final ADQLOperand getOperand() {
        return this.leftOp;
    }

    public void setOperand(ADQLOperand newLeftOp) throws NullPointerException {
        if (newLeftOp == null) {
            throw new NullPointerException("Impossible to set a left operand NULL in an IN constraint!");
        }
        this.leftOp = newLeftOp;
        this.position = null;
    }

    public final ADQLSet getSubQuery() {
        return this.subQuery;
    }

    public final boolean hasSubQuery() {
        return this.subQuery != null;
    }

    public void setSubQuery(ADQLSet newSubQuery) throws NullPointerException {
        if (newSubQuery == null) {
            throw new NullPointerException("Impossible to set a sub-query NULL in an IN constraint!");
        }
        this.list = null;
        this.subQuery = newSubQuery;
        this.position = null;
    }

    public final ADQLList<ADQLOperand> getValuesList() {
        return this.list;
    }

    public void setValuesList(ADQLOperand[] valuesList) throws NullPointerException {
        if (valuesList == null) {
            throw new NullPointerException("Impossible to set a values list NULL in an IN constraint!");
        }
        if (valuesList.length > 0) {
            this.subQuery = null;
            this.list = new ClauseADQL<ADQLOperand>();
            for (int i = 0; i < valuesList.length; ++i) {
                this.list.add(valuesList[i]);
            }
            this.position = null;
        }
    }

    public void setValuesList(ADQLList<ADQLOperand> valuesList) throws NullPointerException {
        if (valuesList == null) {
            throw new NullPointerException("Impossible to set a values list NULL in an IN constraint!");
        }
        this.subQuery = null;
        this.list = valuesList;
        this.position = null;
    }

    public final boolean isNotIn() {
        return this.notIn;
    }

    public void setNotIn(boolean notIn) {
        this.notIn = notIn;
        this.position = null;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new In(this);
    }

    @Override
    public String getName() {
        return this.notIn ? "NOT IN" : "IN";
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;

            @Override
            public ADQLObject next() {
                ++this.index;
                if (this.index == 0) {
                    return In.this.leftOp;
                }
                if (this.index == 1) {
                    return In.this.hasSubQuery() ? In.this.subQuery : In.this.list;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < 2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called!");
                }
                if (replacer == null) {
                    this.remove();
                }
                if (this.index == 0) {
                    if (!(replacer instanceof ADQLOperand)) throw new UnsupportedOperationException("Impossible to replace an ADQLOperand by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                    In.this.leftOp = (ADQLOperand)replacer;
                    In.this.position = null;
                    return;
                } else {
                    if (this.index != 1) return;
                    if (In.this.hasSubQuery() && replacer instanceof ADQLSet) {
                        In.this.subQuery = (ADQLSet)replacer;
                        In.this.position = null;
                        return;
                    } else {
                        if (In.this.hasSubQuery() || !(replacer instanceof ADQLList)) throw new UnsupportedOperationException("Impossible to replace an " + (In.this.hasSubQuery() ? "ADQLSet" : "ADQLList<ADQLOperand>") + " by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                        In.this.list = (ADQLList)replacer;
                        In.this.position = null;
                    }
                }
            }

            @Override
            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called!");
                }
                if (this.index == 0) {
                    throw new UnsupportedOperationException("Impossible to remove the left operand of the IN constraint!");
                }
                if (this.index == 1) {
                    throw new UnsupportedOperationException("Impossible to remove the " + (In.this.hasSubQuery() ? "sub-query" : "values list") + " of the IN constraint!");
                }
            }
        };
    }

    @Override
    public String toADQL() {
        return this.leftOp.toADQL() + " " + this.getName() + " (" + (this.hasSubQuery() ? this.subQuery.toADQL() : this.list.toADQL()) + ")";
    }
}

