#ifndef _protocoltimerasio_h
#define _protocoltimerasio_h


#include "protocoltimer.h"
#include <boost/asio.hpp>


class ProtocolIOAsio : public ProtocolIO
{
private:
  boost::asio::io_service & ioservice;

public:
  ProtocolIOAsio(boost::asio::io_service & ioservice);

  boost::posix_time::ptime currentTimeUTC();
  TheTimerObjectBase * getTimer();
};


class TheTimerObjectAsio : public TheTimerObjectBase
{
private:
  boost::asio::io_service & ioservice;

  bool timerActive;
  boost::asio::deadline_timer timer;

  void timerExpiredEvent(const boost::system::error_code& err);

public:
  TheTimerObjectAsio(boost::asio::io_service & ioservice);
  ~TheTimerObjectAsio();

  void startAlarmAt(const boost::posix_time::ptime & time, TimerEventHandlerBase * handler);
  void startAlarmAfter(const boost::posix_time::time_duration & expiry_time, TimerEventHandlerBase * handler);
  void stop();
  bool isRunning();
};


#endif
