/*
 * Decompiled with CFR 0.152.
 */
package app.authkit.test;

import app.authkit.test.AuthTest;
import app.authkit.test.Digester;
import glguerin.authkit.Authorization;
import glguerin.authkit.Privilege;
import glguerin.authkit.UnauthorizedException;
import glguerin.util.Streamer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class TestAuth
extends AuthTest {
    private static final String BETWEEN = ":";
    private static final String AVAIL = "see";
    private static final String PREAUTH = "pre";
    private static final String AUTH_W = "au+";
    private static final String AUTH_WO = "au-";
    private static final String PUT = "put";
    private static final String GET = "get";
    private static final String RELEASE = "#";
    private static final String DESTROY = "##";
    private static final String VERSION = "ver";
    private static final String SNOOZE = "zzz";
    private static final String AT = "@";
    private static final String JAVA = "JAVA";
    private final String myBetween = System.getProperty("between", ":");

    public static void main(String[] stringArray) {
        AuthTest.tell("TestAuth.main(): starting...");
        Authorization authorization = AuthTest.makeAuth(null);
        AuthTest.tell("Authorization: " + authorization.getClass());
        new TestAuth().testAuth(authorization, "dont-care", stringArray);
        AuthTest.tell("TestAuth.main(): done...\n");
    }

    public void testAuth(Authorization authorization, String string, String[] stringArray) {
        try {
            authorization.isAvailable(Privilege.EMPTY);
            this.decodeActions(authorization, stringArray);
        }
        catch (UnauthorizedException unauthorizedException) {
            AuthTest.explain(unauthorizedException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AuthTest.explain(illegalArgumentException);
        }
        AuthTest.tell("");
    }

    private void decodeActions(Authorization authorization, String[] stringArray) {
        Enumeration enumeration = this.asVector(stringArray).elements();
        Vector<String> vector = new Vector<String>(stringArray.length);
        while (true) {
            vector.removeAllElements();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().toString();
                if (string.equals(this.myBetween)) break;
                vector.addElement(string);
            }
            int n = vector.size();
            if (n == 0) {
                if (!enumeration.hasMoreElements()) break;
                continue;
            }
            Object[] objectArray = new String[n];
            vector.copyInto(objectArray);
            try {
                Object object = objectArray[0];
                AuthTest.tell("-----with: " + this.getWhich(authorization) + " (" + (String)object + ")");
                if (((String)object).equals(RELEASE)) {
                    AuthTest.tell("  Release: " + this.getWhich(authorization));
                    authorization.release();
                    continue;
                }
                if (((String)object).equals(DESTROY)) {
                    AuthTest.tell("  Destroy: " + this.getWhich(authorization));
                    authorization.detach(true);
                    continue;
                }
                if (((String)object).equals(AVAIL)) {
                    this.doAvail(authorization, (String[])objectArray, 1);
                    continue;
                }
                if (((String)object).equals(PREAUTH)) {
                    this.doPreauth(authorization, (String[])objectArray, 1);
                    continue;
                }
                if (((String)object).equals(AUTH_W)) {
                    this.doAuth(authorization, (String[])objectArray, 1, true);
                    continue;
                }
                if (((String)object).equals(AUTH_WO)) {
                    this.doAuth(authorization, (String[])objectArray, 1, false);
                    continue;
                }
                if (((String)object).equals(PUT)) {
                    this.doPut(authorization, (String[])objectArray, 1);
                    continue;
                }
                if (((String)object).equals(VERSION)) {
                    this.doVersion(authorization, (String[])objectArray, 1);
                    continue;
                }
                if (((String)object).equals(SNOOZE)) {
                    this.doSnooze(authorization, (String[])objectArray, 1);
                    continue;
                }
                if (((String)object).equals(GET)) {
                    Authorization authorization2 = this.doGet(authorization, (String[])objectArray, 1);
                    if (authorization2 == authorization) continue;
                    AuthTest.tell("      got: " + this.getWhich(authorization2));
                    AuthTest.tell("   detach: " + this.getWhich(authorization));
                    authorization.detach(true);
                    authorization = authorization2;
                    continue;
                }
                this.doExec(authorization, (String[])objectArray);
            }
            catch (UnauthorizedException unauthorizedException) {
                AuthTest.explain(unauthorizedException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                AuthTest.explain(illegalArgumentException);
            }
            catch (Throwable throwable) {
                AuthTest.explain(throwable);
            }
        }
    }

    private Vector asVector(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector.addElement(objectArray[n]);
            ++n;
        }
        return vector;
    }

    private void doAvail(Authorization authorization, String[] stringArray, int n) {
        if (n < stringArray.length) {
            while (n < stringArray.length) {
                Privilege privilege = new Privilege(stringArray[n++]);
                this.tellPrivilege("Privilege: ", privilege, authorization);
            }
        } else {
            AuthTest.tell(" Past Granted... ");
            this.tellGranted("Privilege: ", authorization);
        }
    }

    private void doPreauth(Authorization authorization, String[] stringArray, int n) {
        while (n < stringArray.length) {
            Privilege privilege = new Privilege(stringArray[n++]);
            AuthTest.tell("Privilege: " + privilege);
            authorization.preauthorize(privilege);
            this.tellPrivilege("  preauth: ", privilege, authorization);
        }
    }

    private void doAuth(Authorization authorization, String[] stringArray, int n, boolean bl) {
        while (n < stringArray.length) {
            Privilege privilege = new Privilege(stringArray[n++]);
            AuthTest.tell("Privilege: " + privilege);
            authorization.authorize(privilege, bl);
            this.tellPrivilege("     auth: ", privilege, authorization);
        }
    }

    private void doPut(Authorization authorization, String[] stringArray, int n) throws IOException {
        if (n < stringArray.length) {
            while (n < stringArray.length) {
                this.writeSecret(authorization, stringArray[n++]);
            }
        } else {
            byte[] byArray = authorization.getSecretIdentifier();
            this.putHexTo(System.out, "## Secret identifier:", "  ", byArray, -1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeSecret(Authorization authorization, String string) throws IOException {
        if (string == null || string.length() == 0) {
            return;
        }
        byte[] byArray = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            byArray = authorization.getSecretIdentifier();
            ((OutputStream)fileOutputStream).write(byArray);
            AuthTest.tell("    wrote: " + string);
            Object var6_5 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileOutputStream == null) throw throwable;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    private Authorization doGet(Authorization authorization, String[] stringArray, int n) throws IllegalAccessException, InstantiationException {
        Authorization authorization2 = authorization;
        if (n < stringArray.length) {
            authorization2 = (Authorization)authorization.getClass().newInstance();
            String string = stringArray[n];
            if (string.equals(".")) {
                authorization2.attachPrivileged();
            } else {
                this.resession(authorization2, string);
            }
        }
        return authorization2;
    }

    private void doVersion(Authorization authorization, String[] stringArray, int n) throws IllegalAccessException, InstantiationException {
        AuthTest.tell(" java.version: " + System.getProperty("java.version", "???"));
        AuthTest.tell("    java.home: " + System.getProperty("java.home", "???"));
    }

    private void doSnooze(Authorization authorization, String[] stringArray, int n) throws IOException {
        int n2 = 3;
        if (n < stringArray.length) {
            try {
                n2 = Integer.parseInt(stringArray[n]);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 3;
            }
            if (n2 <= 0) {
                n2 = 3;
            }
        }
        AuthTest.tell(" sleeping: " + n2);
        this.dawdle(n2);
    }

    private void dawdle(int n) {
        try {
            Thread.sleep((long)n * 1000L);
        }
        catch (InterruptedException interruptedException) {
            AuthTest.explain(interruptedException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doExec(Authorization authorization, String[] stringArray) {
        int n;
        Object object;
        block21: {
            Object object2;
            Object object3;
            boolean bl = false;
            if (stringArray[0].equals(AT)) {
                object = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, object, 0, ((String[])object).length);
                stringArray = object;
                bl = true;
            }
            if (stringArray[0].equals(JAVA)) {
                object = new StringBuffer(System.getProperty("java.home", ""));
                ((StringBuffer)object).append(File.separator);
                object3 = System.getProperty("auth.bin.java", "");
                if (((String)object3).length() != 0) {
                    ((StringBuffer)object).append((String)object3);
                } else {
                    ((StringBuffer)object).append("bin").append(File.separator).append("java");
                }
                stringArray[0] = ((StringBuffer)object).toString();
            }
            AuthTest.tell("Executing: " + stringArray[0]);
            object = authorization.execPrivileged(stringArray);
            AuthTest.tell("  process: " + object);
            AuthTest.tell("    class: " + object.getClass().getName());
            if (authorization.isCapable(2)) {
                try {
                    object3 = new Digester(((Process)object).getInputStream(), System.out, "MD5");
                    object2 = ((Streamer)object3).makeDaemon(null, "Digester-daemon");
                    ((Thread)object2).setPriority(10);
                    ((Thread)object2).start();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (bl && authorization.isCapable(4)) {
                int n2;
                object3 = null;
                try {
                    int n3;
                    block22: {
                        try {
                            object2 = ((Process)object).getOutputStream();
                            object3 = authorization.getSecretIdentifier();
                            ((OutputStream)object2).write((byte[])object3);
                            ((OutputStream)object2).flush();
                            ((OutputStream)object2).close();
                            AuthTest.tell("    wrote: " + ((Object)object3).length + " secret bytes to child");
                        }
                        catch (Throwable throwable) {
                            AuthTest.explain(throwable);
                            Object var8_12 = null;
                            if (object3 == null) break block21;
                            n3 = 0;
                            break block22;
                        }
                        Object var8_11 = null;
                        if (object3 == null) break block21;
                        int n4 = 0;
                        while (true) {
                            if (n4 >= ((Object)object3).length) {
                                object3 = null;
                                break block21;
                            }
                            object3[n4] = false;
                            ++n4;
                        }
                    }
                    while (true) {
                        if (n3 >= ((Object)object3).length) {
                            object3 = null;
                            break;
                        }
                        object3[n3] = false;
                        ++n3;
                    }
                    break block21;
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    if (object3 == null) throw throwable;
                    n2 = 0;
                }
                while (true) {
                    if (n2 >= ((Object)object3).length) {
                        object3 = null;
                        throw throwable;
                    }
                    object3[n2] = false;
                    ++n2;
                }
            }
        }
        if (!authorization.isCapable(32)) {
            AuthTest.tell("  sleeping a few seconds...");
            this.dawdle(3);
            return;
        }
        try {
            n = ((Process)object).waitFor();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalArgumentException("Unexpectedly interrupted");
        }
        AuthTest.tell("   exited: " + n);
    }
}

