// Code generated by go-swagger; DO NOT EDIT.

package agent

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new agent API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new agent API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new agent API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for agent API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	PutAPI5AgentBridge(params *PutAPI5AgentBridgeParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PutApi5AgentBridgeOK, error)

	PutAPI5AgentGateway(params *PutAPI5AgentGatewayParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PutApi5AgentGatewayOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
PutAPI5AgentBridge registers a bridge

Register a bridge. This endpoint allows "menshen agent" processes running on bridges to register themselves.
*/
func (a *Client) PutAPI5AgentBridge(params *PutAPI5AgentBridgeParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PutApi5AgentBridgeOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPutAPI5AgentBridgeParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PutAPI5AgentBridge",
		Method:             "PUT",
		PathPattern:        "/api/5/agent/bridge",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PutAPI5AgentBridgeReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PutApi5AgentBridgeOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PutAPI5AgentBridge: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PutAPI5AgentGateway registers a gateway

Register a gateway. This endpoint allows "menshen agent" processes running on gateways to register themselves.
*/
func (a *Client) PutAPI5AgentGateway(params *PutAPI5AgentGatewayParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PutApi5AgentGatewayOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPutAPI5AgentGatewayParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PutAPI5AgentGateway",
		Method:             "PUT",
		PathPattern:        "/api/5/agent/gateway",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PutAPI5AgentGatewayReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PutApi5AgentGatewayOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PutAPI5AgentGateway: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
