<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook Print Stylesheet//EN" CDATA DSSSL>
<!ENTITY refdblib SYSTEM "../lib/refdblib.dsl">
<!ENTITY refdbvar SYSTEM "../lib/refdbvar.dsl">
]>

<style-sheet>
<style-specification use="docbook">
<style-specification-body>

;; $Id: docbook-refdb.dsl,v 1.5.2.6 2006/03/26 00:43:29 mhoenicka Exp $
;; Driver file for the DocBook stylesheets.
;; overrides for refdb bibliographies

;; include common stuff
&refdblib;
&refdbvar;

;; general stuff

; use letter as default because it prints just fine on both letter and
; A4 paper
(define %paper-type%
  "USletter")

; allow pdf images in mediaobjects
(define preferred-mediaobject-extensions
  (list "eps" "ps" "jpg" "jpeg" "pdf"))

;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;; process bibliography elements

(define (refdb-process-inline token)
  ;; REFENTRY refdb-process-inline
  ;; PURP process inline elements with refdb formatting instructions
  ;; DESC
  ;; uses the command line parameters to apply custom formatting to
  ;; inline elements
  ;; ARGS
  ;; ARG 'token'
  ;; this is roughly equivalent to an element, but the name of the token
  ;; stems from the name in the database, not from the DocBook element
  ;; /ARG
  ;; /ARGS
  ;; /DESC
  ;; EXAMPLE
  ;; (refdb-process-inline "VOLUMESTYLE") will process the current element
  ;; and its children with the formatting instructions in the variable
  ;; VOLUMESTYLE
  ;; /EXAMPLE
  ;; /REFENTRY
  (if (refdb-underline? token)
      (make score
	type: 'after
	score-spaces?: #f
	font-size: (* (inherited-font-size) (refdb-getsizefactor token))
	position-point-shift: (* (inherited-font-size) (refdb-getpointshift token))
	font-weight: (refdb-getfontweight token)
	font-posture: (refdb-getfontposture token)
	(process-children))
      (make sequence
	font-size: (* (inherited-font-size) (refdb-getsizefactor token))
	position-point-shift: (* (inherited-font-size) (refdb-getpointshift token))
	font-weight: (refdb-getfontweight token)
	font-posture: (refdb-getfontposture token)
	(process-children))))

(define (refdb-literal string token)
  ;; REFENTRY refdb-literal
  ;; PURP display literal string with refdb formatting instructions
  ;; DESC
  ;; uses the command line parameters to apply custom formatting to
  ;; literals
  ;; ARGS
  ;; ARG 'string'
  ;; the string to print
  ;; /ARG
  ;; ARG 'token'
  ;; this is roughly equivalent to an element, but the name of the token
  ;; stems from the name in the database, not from the DocBook element
  ;; /ARG
  ;; /ARGS
  ;; /DESC
  ;; EXAMPLE
  ;; (refdb-process-inline "VOLUMESTYLE") will process the current element
  ;; and its children with the formatting instructions in the variable
  ;; VOLUMESTYLE
  ;; /EXAMPLE
  ;; /REFENTRY
  (if (refdb-underline? token)
      (make score
	type: 'after
	score-spaces?: #f
	font-size: (* (inherited-font-size) (refdb-getsizefactor token))
	position-point-shift: (* (inherited-font-size) (refdb-getpointshift token))
	font-weight: (refdb-getfontweight token)
	font-posture: (refdb-getfontposture token)
	(literal string))
      (make sequence
	font-size: (* (inherited-font-size) (refdb-getsizefactor token))
	position-point-shift: (* (inherited-font-size) (refdb-getpointshift token))
	font-weight: (refdb-getfontweight token)
	font-posture: (refdb-getfontposture token)
	(literal string))))

(define (refdb-getpointshift token)
  ;; REFENTRY refdb-getpointshift
  ;; PURP retrieves the font shift (for sub/superscript)
  ;; DESC
  ;; determines the font point shift relative to the baseline for the
  ;; requested token
  ;; ARGS
  ;; ARG 'token'
  ;; this is roughly equivalent to an element, but the name of the token
  ;; stems from the name in the database, not from the DocBook element
  ;; /ARG
  ;; /ARGS
  ;; /DESC
  ;; EXAMPLE
  ;; (refdb-getpointshift "VOLUMESTYLE") will return "0.4" if we are in a
  ;; "bibliomixed" element with the role attribute "JOUR" and the variable
  ;; "JOURVOLUMESTYLE" has the value "SUPER"
  ;; /EXAMPLE
  ;; /REFENTRY
  (let* ((pointshift (refdb-getstyle token)))
    (cond ((equal? pointshift "SUB") (* -1 %ss-shift-factor%))
	  ((equal? pointshift "SUPER") %ss-shift-factor%)
	  (else 0))))

;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;; docbook overrides: bibliography stuff

;; override this to use refdb-mode for all children
(define (refdb-bibliography-content)
  ;; Note that the code below works for both the case where the bibliography
  ;; has BIBLIODIVs and the case where it doesn't, by the slightly subtle
  ;; fact that if it does, then allentries will be (empty-node-list).
  (let* ((allbibcontent (children (current-node)))
	 (prebibcontent (node-list-filter-by-not-gi 
			 allbibcontent
			 (list (normalize "biblioentry")
			       (normalize "bibliomixed"))))
	 (allentries    (node-list-filter-by-gi 
			 allbibcontent
			 (list (normalize "biblioentry")
			       (normalize "bibliomixed"))))
	 (entries       (if biblio-filter-used
			    (biblio-filter allentries)
			    allentries)))
    (make sequence
      (with-mode refdb-mode (process-node-list prebibcontent))
; we can't use a mode here because of a PDF link problem with JadeTeX(?)
;      (with-mode refdb-mode (process-node-list entries))))
      (process-node-list entries)))
)

;; bibliography is the entry point where we fork off the RefDB-specific
;; formatting
(element (book bibliography)
  (make simple-page-sequence
    page-n-columns: %page-n-columns%
    page-number-restart?: (or %page-number-restart% 
			      (book-start?) 
			      (first-chapter?))
    page-number-format: ($page-number-format$)
    use: default-text-style
    left-header:   ($left-header$)
    center-header: ($center-header$)
    right-header:  ($right-header$)
    left-footer:   ($left-footer$)
    center-footer: ($center-footer$)
    right-footer:  ($right-footer$)
    start-indent: %body-start-indent%
    input-whitespace-treatment: 'collapse
    quadding: %default-quadding%
    (make sequence
      ($component-title$)
      (if (equal? (normalize (attribute-string (normalize "role"))) (normalize "refdb"))
	  (refdb-bibliography-content)
	  (bibliography-content)))
    (make-endnotes)))

(element bibliography
  ;; A bibliography that's inside something else...
  (let* ((sect   (ancestor-member (current-node) 
				  (append (section-element-list)
					  (component-element-list))))
	 (hlevel (+ (SECTLEVEL sect) 1))
	 (hs     (HSIZE (- 4 hlevel))))
    (make sequence
      (make paragraph
	font-family-name: %title-font-family%
	font-weight:  (if (< hlevel 5) 'bold 'medium)
	font-posture: (if (< hlevel 5) 'upright 'italic)
	font-size: hs
	line-spacing: (* hs %line-spacing-factor%)
	space-before: (* hs %head-before-factor%)
	space-after:  (* hs %head-after-factor%)
	start-indent: (if (or (>= hlevel 3)
			      (member (gi) (list (normalize "refsect1") 
						 (normalize "refsect2") 
						 (normalize "refsect3"))))
			  %body-start-indent%
			  0pt)
	first-line-start-indent: 0pt
	quadding: %section-title-quadding%
	keep-with-next?: #t
	heading-level: (if %generate-heading-level% (+ hlevel 1) 0)
	(element-title-sosofo (current-node)))
      (if (equal? (normalize (attribute-string (normalize "role"))) (normalize "refdb"))
	  (refdb-bibliography-content)
	  (bibliography-content)))))


; this would be much nicer if it was wrapped in a mode and the fork between
; refdb and non-refdb bibliomixed elements was made upstream. But if we do
; just that, the bibliomixed element will not work as a proper link target in
; the pdf output.
; this is most likely a bug in JadeTeX
(element bibliomixed
  (if (equal? (normalize (attribute-string (normalize "role") (parent))) (normalize "refdb"))
      ; this is our special RefDB treatment
      (let ((bibcontent (node-list-filter-by-attribute-token (children (current-node))
							     (normalize "role")
							     (normalize "bibliography"))))
	(if (equal? (case-fold-up 
		     (attribute-string (normalize "role"))) (normalize "multixref"))
	    (empty-sosofo)
	    (make paragraph
	      space-before: %para-sep%
	      space-after: %para-sep%
	      start-indent: (if refdb-start-indent
				(+ (inherited-start-indent) refdb-start-indent)
				(+ (inherited-start-indent) 2pi))
	      first-line-start-indent: (if refdb-text-indent
					   refdb-text-indent
					   -2pi)
	      font-size: (if refdb-font-size
			     refdb-font-size
			     (inherited-font-size))
	      
	      (with-mode biblioentry-inline-refdb-mode
		(process-node-list bibcontent)))))

      ; this is the default DocBook stylesheet treatment
      (let* ((all-inline-children (children (current-node)))
	     (leading-abbrev      (if (equal? (normalize "abbrev")
					      (gi (node-list-first 
						   all-inline-children)))
				      (node-list-first all-inline-children)
				      (empty-node-list)))
	     (inline-children     (if (node-list-empty? leading-abbrev)
				      all-inline-children
				      (node-list-rest all-inline-children)))
	     (has-leading-abbrev? (not (node-list-empty? leading-abbrev)))
	     (xreflabel           (if (or has-leading-abbrev? biblio-number)
				      #f
				      (attribute-string (normalize "xreflabel")))))
	(make paragraph
	  space-before: %para-sep%
	  space-after: %para-sep%
	  start-indent: (+ (inherited-start-indent) 2pi)
	  first-line-start-indent: -2pi
	  
	  (if (or biblio-number xreflabel has-leading-abbrev?)
	      (make sequence
		(literal "[")
		
		(if biblio-number 
		    (literal (number->string (bibentry-number (current-node))))
		    (empty-sosofo))
	    
		(if xreflabel
		    (literal xreflabel)
		    (empty-sosofo))
	    
		(if has-leading-abbrev?
		    (with-mode biblioentry-inline-mode 
		      (process-node-list leading-abbrev))
		    (empty-sosofo))
	    
		(literal "]\no-break-space;"))
	      (empty-sosofo))

	  (with-mode biblioentry-inline-mode
	    (process-children))))))

(mode biblioentry-inline-refdb-mode
  (element abbrev
    (refdb-process-inline "REFNUMBERSTYLE"))

  (element abstract
    (refdb-process-inline "ABSTRACTSTYLE"))

  (element address
    (refdb-process-inline "ADDRESSSTYLE"))

  (element affiliation
    (let ((inline-children (node-list-filter-by-not-gi 
			    (children (current-node))
			    (list (normalize "address")))))
      (let loop ((nl inline-children))
	(if (node-list-empty? nl)
	    (empty-sosofo)
	    (make sequence
	      (process-node-list (node-list-first nl))
	      (if (node-list-empty? (node-list-rest nl))
		  (empty-sosofo)
		  (literal ", "))
	      (loop (node-list-rest nl)))))))

  (element artpagenums
    (make sequence
      (process-children)))

  (element author
    (literal (author-list-string)))

  (element authorgroup
    (process-children))

  (element authorinitials
    (make sequence
      (process-children)))

  (element (address city)
    (refdb-process-inline "PUBPLACESTYLE"))

  (element collab
    (let* ((nl (children (current-node)))
	   (collabname (node-list-first nl))
	   (affil (node-list-rest nl)))
      (make sequence
	(process-node-list collabname)
	(if (node-list-empty? affil)
	    (empty-sosofo)
	    (let loop ((nl affil))
	      (if (node-list-empty? nl)
		  (empty-sosofo)
		  (make sequence
		    (literal ", ")
		    (process-node-list (node-list-first nl))
		    (loop (node-list-rest nl)))))))))

  (element (collab collabname)
    (process-children))

  (element confgroup
    (let ((inline-children (node-list-filter-by-not-gi 
			    (children (current-node))
			    (list (normalize "address")))))
      (let loop ((nl inline-children))
	(if (node-list-empty? nl)
	    (empty-sosofo)
	    (make sequence
	      (process-node-list (node-list-first nl))
	      (if (node-list-empty? (node-list-rest nl))
		  (empty-sosofo)
		  (literal ", "))
	      (loop (node-list-rest nl)))))))

  (element contractnum
    (process-children))

  (element contractsponsor
    (process-children))

  (element contrib
    (process-children))

  (element copyright
    ;; Just print the year(s)
    (let ((years (select-elements (children (current-node))
				  (normalize "year"))))
      (process-node-list years)))

  (element (copyright year)
    (make sequence
      (process-children)
      (if (not (last-sibling? (current-node)))
	  (literal ", ")
	  (empty-sosofo))))

  (element corpauthor
    (make sequence
      (process-children)))

  (element corpname
    (make sequence
      (process-children)))

  (element date
    (make sequence
      (process-children)))

  (element edition
    (make sequence
      (process-children)))

  (element editor
    (make sequence
      (literal (gentext-edited-by))
      (literal " ")
      (literal (author-list-string))))

  (element firstname
    (let ((relation (normalize 
		(inherited-attribute-string (normalize "relation")))))
     (cond
      ((equal? relation (normalize "author")) 
	(refdb-process-inline "AUTHORLISTSTYLE"))
      ((equal? relation (normalize "editor")) 
	(refdb-process-inline "EDITORLISTSTYLE"))
      ((equal? relation (normalize "seditor")) 
	(refdb-process-inline "SEDITORLISTSTYLE"))
      (else 
	(refdb-process-inline "ALLALISTSTYLE")))))

  (element honorific
    (let ((relation (normalize 
		(inherited-attribute-string (normalize "relation")))))
     (cond
      ((equal? relation (normalize "author")) 
	(refdb-process-inline "AUTHORLISTSTYLE"))
      ((equal? relation (normalize "editor")) 
	(refdb-process-inline "EDITORLISTSTYLE"))
      ((equal? relation (normalize "seditor")) 
	(refdb-process-inline "SEDITORLISTSTYLE"))
      (else 
	(refdb-process-inline "ALLALISTSTYLE")))))

  (element invpartnumber
    (make sequence
      (process-children)))

  (element isbn
    (refdb-process-inline "SERIALSTYLE"))

  (element issn
    (refdb-process-inline "SERIALSTYLE"))

  (element issuenum
    (refdb-process-inline "ISSUESTYLE"))

  (element lineage
    (let ((relation (normalize
		(inherited-attribute-string (normalize "relation")))))
     (cond
      ((equal? relation (normalize "author")) 
	(refdb-process-inline "AUTHORLISTSTYLE"))
      ((equal? relation (normalize "editor")) 
	(refdb-process-inline "EDITORLISTSTYLE"))
      ((equal? relation (normalize "seditor")) 
	(refdb-process-inline "SEDITORLISTSTYLE"))
      (else 
	(refdb-process-inline "ALLALISTSTYLE")))))

  (element orgname
    (make sequence
      (process-children)))

  (element othercredit
    (literal (author-list-string)))

  (element othername
    (let ((relation (normalize
		(inherited-attribute-string (normalize "relation")))))
     (cond
      ((equal? relation (normalize "author")) 
	(refdb-process-inline "AUTHORLISTSTYLE"))
      ((equal? relation (normalize "editor")) 
	(refdb-process-inline "EDITORLISTSTYLE"))
      ((equal? relation (normalize "seditor")) 
	(refdb-process-inline "SEDITORLISTSTYLE"))
      (else 
	(refdb-process-inline "ALLALISTSTYLE")))))

  (element pagenums
    (refdb-process-inline "PAGESSTYLE"))

  (element productname
    (make sequence
      ($charseq$)
; this is actually a problem since "trade" is the default value for
; the class attribute. we can put this back in in DocBook 5.0, when
; class becomes #IMPLIED
;      (if (equal? (attribute-string "class") (normalize "trade"))
;	  (literal "\trade-mark-sign;")
;	  (empty-sosofo))
      ))
  
  (element productnumber
    (make sequence
      (process-children)))

  (element pubdate
    (let ((role (normalize
		(attribute-string (normalize "role")))))
     (cond
      ((equal? role (normalize "primary")) 
	(refdb-process-inline "PUBDATESTYLE"))
      ((equal? role (normalize "secondary")) 
	(refdb-process-inline "PUBDATESECSTYLE"))
      (else 
	(refdb-process-inline "PUBDATEALLSTYLE")))))

  (element publisher
    (let ((pubname (select-elements (children (current-node))
				    (normalize "publishername")))
	  (cities  (select-elements (descendants (current-node))
				    (normalize "city"))))
    (make sequence
      (process-node-list pubname)
      (if (node-list-empty? cities)
	  (empty-sosofo)
	  (literal ", "))
      (process-node-list cities))))

  (element publishername
    (refdb-process-inline "PUBLISHERSTYLE"))

  (element (publisher address city)
    (make sequence
      (process-children)
      (if (not (last-sibling? (current-node)))
	  (literal ", ")
	  (empty-sosofo))))

  (element pubsnumber
    (make sequence
      (process-children)))

  (element releaseinfo
    (make sequence
      (process-children)))

  (element seriesvolnums
    (make sequence
      (process-children)))

  (element subtitle
    (make sequence
      font-posture: 'italic
      (process-children)))

  (element surname
    (let ((relation (normalize 
		(inherited-attribute-string (normalize "relation")))))
     (cond
      ((equal? relation (normalize "author")) 
	(refdb-process-inline "AUTHORLISTSTYLE"))
      ((equal? relation (normalize "editor")) 
	(refdb-process-inline "EDITORLISTSTYLE"))
      ((equal? relation (normalize "seditor")) 
	(refdb-process-inline "SEDITORLISTSTYLE"))
      (else 
	(refdb-process-inline "ALLALISTSTYLE")))))

  (element title
    (make sequence
      font-posture: 'italic
      (process-children)))

  (element titleabbrev
    (make sequence
      (process-children)))

  (element ulink
    (refdb-process-inline "URLSTYLE"))

  (element volumenum
    (refdb-process-inline "VOLUMESTYLE"))

  (element (bibliomixed title) 
      (make sequence
	font-posture: 'italic
	(process-children)))

  
  (element (bibliomixed subtitle) 
    (make sequence
      font-posture: 'italic
      (process-children)))

  (element (biblioset title)
    (let ((rel (normalize
		(inherited-attribute-string (normalize "relation")))))
      (cond
       ((equal? rel (normalize "article"))
	(make sequence
	  (literal (gentext-start-quote))
	  (process-children)
	  (literal (gentext-end-quote))))
       (else (make sequence
	       font-posture: 'italic
	       (process-children))))))

  (element (bibliomset title)
    (let ((rel (normalize
		(inherited-attribute-string (normalize "relation")))))
      (cond
       ((equal? rel (normalize "article")) 
	(refdb-process-inline "TITLESTYLE"))
       ((equal? rel (normalize "journal")) 
	(refdb-process-inline "JOURNALNAMESTYLE"))
       ((equal? rel (normalize "book"))
	(refdb-process-inline "BOOKTITLESTYLE"))
       ((equal? rel (normalize "chapter"))
	(refdb-process-inline "CHAPTITLESTYLE"))
       ((equal? rel (normalize "series"))
	(refdb-process-inline "SERIESTITLESTYLE"))
       ((equal? rel (normalize "all"))
	(refdb-process-inline "ALLTITLESTYLE"))
       ((equal? rel (normalize "author")) 
	(refdb-process-inline "AUTHORLISTSTYLE"))
       (else  (make sequence
		(process-children))))))

  (element bibliomset
    (let ((role (normalize (attribute-string (normalize "role"))))
 	  (relation (normalize (attribute-string (normalize "relation")))))
      (cond
       ((equal? role (normalize "intext"))
 	(empty-sosofo))
       ((equal? role (normalize "intextsq"))
 	(empty-sosofo))
       ((equal? role (normalize "authoronly"))
 	(empty-sosofo))
       ((equal? role (normalize "authoronlysq"))
 	(empty-sosofo))
       ((equal? role (normalize "yearonly"))
 	(empty-sosofo))
       ((equal? relation (normalize "endtermtarget"))
 	(empty-sosofo))
       ((equal? role (normalize "userdef1"))
	(refdb-process-inline "USERDEF1STYLE"))
       ((equal? role (normalize "userdef2"))
	(refdb-process-inline "USERDEF2STYLE"))
       ((equal? role (normalize "userdef3"))
	(refdb-process-inline "USERDEF3STYLE"))
       ((equal? role (normalize "userdef4"))
	(refdb-process-inline "USERDEF4STYLE"))
       ((equal? role (normalize "userdef5"))
	(refdb-process-inline "USERDEF5STYLE"))
       ((equal? role (normalize "misc1"))
	(refdb-process-inline "MISC1STYLE"))
       ((equal? role (normalize "misc2"))
	(refdb-process-inline "MISC2STYLE"))
       ((equal? role (normalize "misc3"))
	(refdb-process-inline "MISC3STYLE"))
       ((equal? role (normalize "link0"))
	(refdb-process-inline "LINK0STYLE"))
       ((equal? role (normalize "link1"))
	(refdb-process-inline "LINK1STYLE"))
       ((equal? role (normalize "link2"))
	(refdb-process-inline "LINK2STYLE"))
       ((equal? role (normalize "link3"))
	(refdb-process-inline "LINK3STYLE"))
       ((equal? role (normalize "link4"))
	(refdb-process-inline "LINK4STYLE"))
       ((equal? role (normalize "notes"))
	(refdb-process-inline "NOTESSTYLE"))
       (else
 	(process-children)))))
)

;;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;; docbook overrides: citation/xref stuff
(element citation 
  (if (equal? (normalize
	       (attribute-string (normalize "role"))) (normalize "refdb"))
      (let ((multixref (node-list-filter-by-attribute-token (children (current-node))
						   (normalize "role")  
						   (normalize "multixref"))))
	(if (node-list-empty? multixref)
	    (with-mode refdb-mode ($charseq$))
	    (with-mode refdb-mode (process-node-list multixref))))
      (if biblio-citation-check
	  (let* ((bgraphies (select-elements (descendants (sgml-root-element))
					     (normalize "bibliography")))
		 (bchildren1 (expand-children bgraphies
					      (list (normalize "bibliography"))))
		 (bchildren2 (expand-children bchildren1
					      (list (normalize "bibliodiv"))))
		 (bibentries (node-list-filter-by-gi 
			      bchildren2
			      (list (normalize "biblioentry")
				    (normalize "bibliomixed")))))
	    (let loop ((bibs bibentries))
	      (if (node-list-empty? bibs)
		  (make sequence
		    (error (string-append "Cannot find citation: " 
					  (data (current-node))))
		    (literal "[") ($charseq$) (literal "]"))
		  (if (citation-matches-target? (current-node) 
						(node-list-first bibs))
		      (make link 
			destination: (node-list-address (node-list-first bibs))
			(literal "[") ($charseq$) (literal "]"))
		      (loop (node-list-rest bibs))))))
	  (make sequence 
	    (literal "[") ($charseq$) (literal "]")))))

(mode refdb-mode
  (element xref
    (let* ((endterm (attribute-string (normalize "endterm")))
  	   (multixref (normalize (attribute-string (normalize "role"))))
	   ; we want to link to ID2 if linkend is ID2X or ID2Y or whatever
 	   (linkend 
	    (if (equal? multixref (normalize "multixref"))
		(attribute-string (normalize "linkend"))
		(substring
		 (attribute-string (normalize "linkend"))
		 0
		 (- (string-length (attribute-string (normalize "linkend"))) 2))))
  	   (target  (element-with-id linkend))
 	   (xreflabel (attribute-string (normalize "linkend"))))
      (if (node-list-empty? target)
	  (error (string-append "XRef LinkEnd to missing ID '" linkend "'"))
	  (if endterm
	      (if (node-list-empty? (element-with-id endterm))
		  (error (string-append "XRef EndTerm to missing ID '" 
					endterm "'"))
		  (make link 
		    destination: (node-list-address target)
		    (process-element-with-id endterm)))
;		    (process-node-list (children (element-with-id endterm)))))
	      (if xreflabel
		  (make link 
		    destination: (node-list-address target)
		    (process-element-with-id xreflabel))
;		    (process-node-list (children (element-with-id xreflabel))))
		  (empty-sosofo))))))

  (element bibliomset
    (with-mode biblioentry-inline-refdb-mode
      (process-children)))
)

(mode refdb-xref-endterm-mode
  (default
    (refdb-process-inline "REFNUMBERSTYLE")))




</style-specification-body>
</style-specification>

<external-specification id="docbook" document="docbook.dsl">

</style-sheet>












