% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gn_parse.R
\name{gn_parse}
\alias{gn_parse}
\title{Parse scientific names using Global Names Parser}
\usage{
gn_parse(names, ...)
}
\arguments{
\item{names}{A vector of length 1 or more taxonomic names}

\item{...}{Curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
A data.frame with results, the submitted names, and the
parsed names with additional information.
}
\description{
Parse scientific names using Global Names Parser
}
\examples{
\dontrun{
gn_parse("Cyanistes caeruleus")
gn_parse("Plantago minor")
gn_parse("Plantago minor minor")
gn_parse(c("Plantago minor minor","Helianthus annuus texanus"))

# if > 20 names, uses an HTTP POST request
x <- names_list("species", size = 30)
gn_parse(x)

# pass on curl options
gn_parse("Cyanistes caeruleus", verbose = TRUE)
}
}
\references{
http://gni.globalnames.org/
}
\seealso{
\code{\link[=gbif_parse]{gbif_parse()}}, \code{\link[=gni_parse]{gni_parse()}}
}
