context("test-remove_ns")

stat.test <- PlantGrowth %>% wilcox_test(weight ~ group)
test_that("remove_ns works when col = NULL", {
  result <- remove_ns(stat.test, col = NULL)
  p <- round(result$p, 3)
  expect_equal(p, 0.009)
})
test_that("remove_ns works when col = NA", {
  result <- remove_ns(stat.test, col = NA)
  p <- round(result$p, 3)
  expect_equal(p, 0.009)
})
test_that("remove_ns works when col is logical", {
  result <- remove_ns(stat.test, col = TRUE)
  p.true <- round(result$p, 3)
  result <- remove_ns(stat.test, col = FALSE)
  p.false <- round(result$p, 3)
  expect_equal(p.true, 0.009)
  expect_equal(p.false, c(0.199, 0.063, 0.009))
})
test_that("remove_ns works when col is specified", {
  stat.test2 <- stat.test %>% add_significance("p")
  result.when.p  <- remove_ns(stat.test2, col = "p")
  result.when.p.adj <- remove_ns(stat.test2, col = "p.adj")
  result.when.p.adj.signif <- remove_ns(stat.test2, col = "p.adj.signif")
  result.when.p.signif <- remove_ns(stat.test2, col = "p.signif")
  expect_equal(result.when.p$p.signif, "**")
  expect_equal(result.when.p.adj$p.signif, "**")
  expect_equal(result.when.p.adj.signif$p.signif, "**")
  expect_equal(result.when.p.signif$p.signif, "**")
})
test_that("remove_ns works when signif.cutoff is specified", {
  stat.test2 <- stat.test %>% add_significance("p")
  result  <- remove_ns(stat.test2, signif.cutoff = 0.01)
  expect_equal(nrow(result), 0)
})
test_that("remove_ns works when signif.cutoff and col are specified", {
  stat.test2 <- stat.test %>% add_significance("p")
  result1  <- remove_ns(stat.test2, col = "p.adj", signif.cutoff = 0.01)
  result2  <- remove_ns(stat.test2, col = "p", signif.cutoff = 0.01)
  expect_equal(nrow(result1), 0)
  expect_equal(nrow(result2), 1)
  expect_equal(result2$p.signif, "**")
})
