% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unite.R
\name{unite}
\alias{unite}
\title{Unite Multiple Columns Into One}
\usage{
unite(data, col, ..., sep = "_", remove = TRUE, na.rm = FALSE)
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{col}{\code{character(1)} or \code{symbol(1)}. The name of the new column.}

\item{...}{The columns to unite.}

\item{sep}{\code{character(1)}. Separator to use between the values.}

\item{remove}{\code{logical(1)}. If \code{TRUE}, remove the input columns from the output \code{data.frame}.}

\item{na.rm}{\code{logical(1)}. If \code{TRUE}, missing values will be remove prior to uniting each value.}
}
\value{
A \code{data.frame} with the columns passed via \code{...} pasted together in a new column.
}
\description{
Convenience function to paste together multiple columns.
}
\examples{
df <- data.frame(x = c("a", "a", NA, NA), y = c("b", NA, "b", NA))
df

df \%>\% unite("z", x:y, remove = FALSE)
# To remove missing values:
df \%>\% unite("z", x:y, na.rm = TRUE, remove = FALSE)

}
