% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add}
\alias{body_add}
\alias{body_add.character}
\alias{body_add.numeric}
\alias{body_add.factor}
\alias{body_add.fpar}
\alias{body_add.data.frame}
\alias{body_add.block_caption}
\alias{body_add.block_list}
\alias{body_add.block_toc}
\alias{body_add.external_img}
\alias{body_add.run_pagebreak}
\alias{body_add.run_columnbreak}
\alias{body_add.gg}
\alias{body_add.plot_instr}
\alias{body_add.block_pour_docx}
\alias{body_add.block_section}
\title{Add content into a Word document}
\usage{
body_add(x, value, ...)

\method{body_add}{character}(x, value, style = NULL, ...)

\method{body_add}{numeric}(x, value, style = NULL, format_fun = formatC, ...)

\method{body_add}{factor}(x, value, style = NULL, format_fun = as.character, ...)

\method{body_add}{fpar}(x, value, style = NULL, ...)

\method{body_add}{data.frame}(
  x,
  value,
  style = NULL,
  header = TRUE,
  tcf = table_conditional_formatting(),
  alignment = NULL,
  ...
)

\method{body_add}{block_caption}(x, value, ...)

\method{body_add}{block_list}(x, value, ...)

\method{body_add}{block_toc}(x, value, ...)

\method{body_add}{external_img}(x, value, style = "Normal", ...)

\method{body_add}{run_pagebreak}(x, value, style = NULL, ...)

\method{body_add}{run_columnbreak}(x, value, style = NULL, ...)

\method{body_add}{gg}(
  x,
  value,
  width = 6,
  height = 5,
  res = 300,
  style = "Normal",
  scale = 1,
  unit = "in",
  ...
)

\method{body_add}{plot_instr}(
  x,
  value,
  width = 6,
  height = 5,
  res = 300,
  style = "Normal",
  unit = "in",
  ...
)

\method{body_add}{block_pour_docx}(x, value, ...)

\method{body_add}{block_section}(x, value, ...)
}
\arguments{
\item{x}{an rdocx object}

\item{value}{object to add in the document. Supported objects
are vectors, data.frame, graphics, block of formatted paragraphs,
unordered list of formatted paragraphs,
pretty tables with package flextable, 'Microsoft' charts with package mschart.}

\item{...}{further arguments passed to or from other methods. When
adding a \code{ggplot} object or \link{plot_instr}, these arguments will be used
by png function. See method signatures to see what arguments can be used.}

\item{style}{paragraph style name. These names are available with function \link{styles_info}
and are the names of the Word styles defined in the base document (see
argument \code{path} from \link{read_docx}).}

\item{format_fun}{a function to be used to format values.}

\item{header}{display header if TRUE}

\item{tcf}{conditional formatting settings defined by \code{\link[=table_conditional_formatting]{table_conditional_formatting()}}}

\item{alignment}{columns alignement, argument length must match with columns length,
values must be "l" (left), "r" (right) or "c" (center).}

\item{width, height}{plot size in units expressed by the unit argument.
Defaults to a width of 6 and a height of 5 "in"ches.}

\item{res}{resolution of the png image in ppi}

\item{scale}{Multiplicative scaling factor, same as in ggsave}

\item{unit}{One of the following units in which the width and height
arguments are expressed: "in", "cm" or "mm".}
}
\description{
This function adds objects into a Word document. Values are added
as new paragraphs or tables.

This function is experimental and will replace the \verb{body_add_*} functions
later. For now it is only to be used for successive additions and cannot
be used in conjunction with the \verb{body_add_*} functions.
}
\section{Methods (by class)}{
\itemize{
\item \code{body_add(character)}: add a character vector.

\item \code{body_add(numeric)}: add a numeric vector.

\item \code{body_add(factor)}: add a factor vector.

\item \code{body_add(fpar)}: add a \link{fpar} object. These objects enable
the creation of formatted paragraphs made of formatted chunks of text.

\item \code{body_add(data.frame)}: add a data.frame object with \code{\link[=block_table]{block_table()}}.

\item \code{body_add(block_caption)}: add a \link{block_caption} object. These objects enable
the creation of set of formatted paragraphs made of formatted chunks of text.

\item \code{body_add(block_list)}: add a \link{block_list} object. Use this function
to add a list of block elements (e.g. paragraphs, images, tables)
into a Word document in a more efficient way than with usual
\verb{body_add_*} functions. This function will add several elements
in a faster way because the cursor is not calculated for
each iteraction over the elements, as a consequence the
function only append elements at the end of the document
and does not allow to insert elements at a specific position.

\item \code{body_add(block_toc)}: add a table of content (a \link{block_toc} object).

\item \code{body_add(external_img)}: add an image (a \link{external_img} object).

\item \code{body_add(run_pagebreak)}: add a \link{run_pagebreak} object.

\item \code{body_add(run_columnbreak)}: add a \link{run_columnbreak} object.

\item \code{body_add(gg)}: add a ggplot object.

\item \code{body_add(plot_instr)}: add a base plot with a \link{plot_instr} object.

\item \code{body_add(block_pour_docx)}: pour content of an external docx file with with a \link{block_pour_docx} object

\item \code{body_add(block_section)}: ends a section with a \link{block_section} object

}}
\section{Illustrations}{


\if{html}{\figure{body_add_doc_1.png}{options: style="width:70\%;"}}
}

\examples{
# This example demonstrates the versatility of body_add()
# by showing how to add various content types to a Word document

# Create a new Word document
x <- read_docx()

# Add a heading for the table of contents section
x <- body_add(x, "Table of content", style = "heading 1")

# Insert an automatic table of contents
# This will list all headings in the document
x <- body_add(x, block_toc())

# Insert a page break to start content on a new page
x <- body_add(x, run_pagebreak())

# Add a main section heading
x <- body_add(x, "Iris Dataset Sample", style = "heading 1")

# Add a data.frame as a table
# The first 6 rows of the iris dataset will be displayed
x <- body_add(x, head(iris), style = "table_template")

# Add another section heading
x <- body_add(x, "Alphabetic List", style = "heading 1")

# Add a character vector as paragraphs
# Each letter will appear as a separate paragraph with "Normal" style
x <- body_add(x, letters, style = "Normal")

# Insert a continuous section break
# Content continues on the same page but section properties can change
x <- body_add(x, block_section(prop_section(type = "continuous")))

# Add a plot created with R base graphics
# plot_instr() captures the plotting code to generate the image
x <- body_add(x, plot_instr(code = barplot(1:5, col = 2:6)))

# Change to landscape orientation for the next section
# This creates a new section with landscape page layout
x <- body_add(
  x,
  block_section(prop_section(page_size = page_size(orient = "landscape")))
)

# Save the document to a file
output_file <- tempfile(fileext = ".docx")
print(x, target = output_file)
}
\keyword{internal}
