% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreg.R
\name{phreg_IPTW}
\alias{phreg_IPTW}
\title{IPTW Cox, Inverse Probaibilty of Treatment Weighted Cox regression}
\usage{
phreg_IPTW(
  formula,
  data,
  treat.model = NULL,
  weight.var = NULL,
  weights = NULL,
  estpr = 1,
  pi0 = 0.5,
  ...
)
}
\arguments{
\item{formula}{for phreg}

\item{data}{data frame for risk averaging}

\item{treat.model}{propensity score model (binary or multinomial)}

\item{weight.var}{a 1/0 variable that indicates when propensity score is computed over time}

\item{weights}{may be given, and then uses weights*w(A) as the weights}

\item{estpr}{to estimate propensity scores and get infuence function contribution to uncertainty}

\item{pi0}{fixed simple weights}

\item{...}{arguments for phreg call}
}
\description{
Fits Cox model with treatment weights \deqn{ w(A)= \sum_a I(A=a)/P(A=a|X) }, computes
standard errors via influence functions that are returned as the IID argument. 
Propensity scores are fitted using either logistic regression (glm) or the multinomial model (mlogit) when more
than two categories for treatment. The treatment needs to be a factor and is identified on the rhs
of the "treat.model".
}
\details{
Also works with cluster argument. Time-dependent propensity score weights can also be computed when weight.var is 1
and then at time of 2nd treatment (A_1) uses weights w_0(A_0) * w_1(A_1) where A_0 is first treatment.
}
\examples{
##data(bmt)
##dfactor(bmt) <- tcell~tcell
##out <- phreg_IPTW(Surv(time,cause==1)~tcell+platelet+age,bmt,tcell~platelet+age)
##summary(out)

data <- mets:::simLT(0.7,100,beta=0.3,betac=0,ce=1,betao=0.3)
dfactor(data) <- Z.f~Z
out <- phreg_IPTW(Surv(time,status)~Z.f,data=data,treat.model=Z.f~X)
summary(out)

}
\author{
Thomas Scheike
}
