% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile-pred.R
\name{quantile_pred}
\alias{quantile_pred}
\alias{extract_quantile_levels}
\alias{as_tibble.quantile_pred}
\alias{as.matrix.quantile_pred}
\title{Create a vector containing sets of quantiles}
\usage{
quantile_pred(values, quantile_levels = double())

extract_quantile_levels(x)

\method{as_tibble}{quantile_pred}(x, ..., .rows = NULL, .name_repair = "minimal", rownames = NULL)

\method{as.matrix}{quantile_pred}(x, ...)
}
\arguments{
\item{values}{A matrix of values. Each column should correspond to one of
the quantile levels.}

\item{quantile_levels}{A vector of probabilities corresponding to \code{values}.}

\item{x}{An object produced by \code{quantile_pred()}.}

\item{...}{Not currently used.}

\item{.rows, .name_repair, rownames}{Arguments not used but required by the
original S3 method.}
}
\value{
\itemize{
\item \code{quantile_pred()} returns a vector of values associated with the
quantile levels.
\item \code{extract_quantile_levels()} returns a numeric vector of levels.
\item \code{as_tibble()} returns a tibble with rows \code{".pred_quantile"},
\code{".quantile_levels"}, and \code{".row"}.
\item \code{as.matrix()} returns an unnamed matrix with rows as samples, columns as
quantile levels, and entries are predictions.
}
}
\description{
\code{quantile_pred()} is a special vector class used to efficiently store
predictions from a quantile regression model. It requires the same quantile
levels for each row being predicted.
}
\examples{
.pred_quantile <- quantile_pred(matrix(rnorm(20), 5), c(.2, .4, .6, .8))

unclass(.pred_quantile)

# Access the underlying information
extract_quantile_levels(.pred_quantile)

# Matrix format
as.matrix(.pred_quantile)

# Tidy format
library(tibble)
as_tibble(.pred_quantile)
}
