% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{print.ggplot}
\alias{print.ggplot}
\alias{plot.ggplot}
\title{Explicitly draw plot}
\usage{
\method{print}{ggplot}(x, newpage = is.null(vp), vp = NULL, ...)

\method{plot}{ggplot}(x, newpage = is.null(vp), vp = NULL, ...)
}
\arguments{
\item{x}{plot to display}

\item{newpage}{draw new (empty) page first?}

\item{vp}{viewport to draw plot in}

\item{...}{other arguments not used by this method}
}
\value{
Invisibly returns the original plot.
}
\description{
Generally, you do not need to print or plot a ggplot2 plot explicitly: the
default top-level print method will do it for you. You will, however, need
to call \code{print()} explicitly if you want to draw a plot inside a
function or for loop.
}
\examples{
colours <- list(~class, ~drv, ~fl)

# Doesn't seem to do anything!
for (colour in colours) {
  ggplot(mpg, aes_(~ displ, ~ hwy, colour = colour)) +
    geom_point()
}

# Works when we explicitly print the plots
for (colour in colours) {
  print(ggplot(mpg, aes_(~ displ, ~ hwy, colour = colour)) +
    geom_point())
}
}
\keyword{hplot}
