% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/309-extractDrugAutocorrelationMass.R
\name{extractDrugAutocorrelationMass}
\alias{extractDrugAutocorrelationMass}
\title{Calculate the Moreau-Broto Autocorrelation Descriptors using Atomic Weight}
\usage{
extractDrugAutocorrelationMass(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature. This function returns 5 columns named
\code{ATSm1}, \code{ATSm2}, \code{ATSm3}, \code{ATSm4}, \code{ATSm5}.
}
\description{
Calculate the Moreau-Broto Autocorrelation Descriptors using Atomic Weight
}
\details{
Calculates the ATS autocorrelation descriptor,
where the weight equal to the scaled atomic mass.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugAutocorrelationMass(mol)
head(dat)}
}
\references{
Moreau, Gilles, and Pierre Broto.
The autocorrelation of a topological structure: a new molecular descriptor.
Nouv. J. Chim 4 (1980): 359-360.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{Autocorrelation}
\keyword{Mass}
\keyword{extractDrugAutocorrelationMass}
