/***************************************************************************
 *   Copyright (C) 2007-2010 by Vegeta          			   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "gradient.h"
#include <QPainter>


Gradient::Gradient(QWidget *parent) : QLabel(parent){
}

// Subclassed QPaintEvent, see http://daniel.molkentin.de/blog/archives/2007/03.html
// for further information
void Gradient::paintEvent(QPaintEvent *event){
    Q_UNUSED(event)
    QPainter p(this);
    QFontMetrics fm(font());

    if (fm.width(text()) > contentsRect().width()) {
        QLinearGradient gradient(contentsRect().topLeft(), contentsRect().topRight());
        gradient.setColorAt(0.8, palette().color(QPalette::WindowText));
        gradient.setColorAt(1.0, palette().color(QPalette::Window));
        QPen pen;
        pen.setBrush(QBrush(gradient));
        p.setPen(pen);
    }
    p.drawText(rect(), Qt::TextSingleLine, text());
}
