# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ConnectivitySource(Model):
    """Parameters that define the source of the connection.

    :param resource_id: The ID of the resource from which a connectivity check
     will be initiated.
    :type resource_id: str
    :param port: The source port from which a connectivity check will be
     performed.
    :type port: int
    """

    _validation = {
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, resource_id, port=None):
        self.resource_id = resource_id
        self.port = port
