#
# Macros preparing compilation of Libint and Libderiv
# Written by Andrew Simmonett
#

set(AM 0 p d f g h i k l m n o q r t u v w x y z A B C D E F G H I J K L M N O P Q R S T U V W X Y Z)

# This macros populates a list of files expected from LIBINT
# Written by Andrew Simmonett
macro(BUILD_LIBINT_FILES MYINTFILES MYOPT_AM)
    math(EXPR MYNEW_AM ${MYOPT_AM}*2)
    # hrr_order_WXYZ.cc
    # vrr_order_WXYZ.cc
    foreach(i RANGE ${MYNEW_AM})
        list(GET AM ${i} am_i)
        if(i GREATER ${MYOPT_AM})
            math(EXPR jmin "${i}-${MYOPT_AM}")
        else()
            set(jmin 0)
        endif()
        math(EXPR jmax "${i}/2")
        if(i EQUAL 0)
            set(kmin 1)
        else()
            set(kmin ${i})
        endif()
        if(NOT jmin GREATER jmax)
            foreach(j RANGE ${jmin} ${jmax} 1)
                list(GET AM ${j} am_j)
                math(EXPR reali "${i}-${j}")
                list(GET AM ${reali} am_i)
                foreach(k RANGE ${kmin} ${MYNEW_AM})
                    list(GET AM ${k} am_k)
                    if(k GREATER ${MYOPT_AM})
                        math(EXPR lmin "${k}-${MYOPT_AM}")
                    else()
                        set(lmin 0)
                    endif()
                    math(EXPR lmax "${k}/2")
                    if(NOT lmin GREATER lmax)
                        foreach(l RANGE ${lmin} ${lmax})
                            list(GET AM ${l} am_l)
                            math(EXPR realk "${k}-${l}")
                            list(GET AM ${realk} am_k)
                            set(TMPINTFILES ${TMPINTFILES} hrr_order_${am_i}${am_j}${am_k}${am_l}.cc)
                            set(TMPINTFILES ${TMPINTFILES} vrr_order_${am_i}${am_j}${am_k}${am_l}.cc)
                        endforeach()
                    endif()
                endforeach()
            endforeach()
        endif()
    endforeach()
    # hrr1_build_XY.cc
    # hrr3_build_XY.cc
    foreach(i RANGE ${MYNEW_AM})
        math(EXPR jmax "${i}/2+1")
        if(jmax GREATER i)
            set(jmax ${i})
        endif()
        if(jmax GREATER 0)
            foreach(j RANGE 1 ${jmax})
                math(EXPR reali "${i}-${j}")
                list(GET AM ${reali} am_i)
                list(GET AM ${j} am_j)
                set(TMPINTFILES ${TMPINTFILES} hrr1_build_${am_i}${am_j}.cc)
                set(TMPINTFILES ${TMPINTFILES} hrr3_build_${am_i}${am_j}.cc)
            endforeach()
        endif()
    endforeach()
    # build_X0Y0.cc
    foreach(i RANGE ${MYOPT_AM})
        list(GET AM ${i} am_i)
        if(i GREATER 0)
            set(jmin 0)
        else()
            set(jmin 1)
        endif()
        foreach(j RANGE ${jmin} ${MYOPT_AM})
            list(GET AM ${j} am_j)
            set(TMPINTFILES ${TMPINTFILES} build_${am_i}0${am_j}0.cc)
        endforeach()
    endforeach()
    set(${MYINTFILES} ${TMPINTFILES})
    set(TMPINTFILES "")
endmacro(BUILD_LIBINT_FILES)

# This macro populates a list of files expected from LIBINT for derivatives
# Written by Andrew Simmonett
macro(BUILD_LIBDERIV_FILES MYINTFILES MYOPT_AM ADDBUILD)
    math(EXPR MYNEW_AM ${MYOPT_AM}*2)
    # hrr_order_WXYZ.cc
    # vrr_order_WXYZ.cc
    foreach(i RANGE ${MYNEW_AM})
        list(GET AM ${i} am_i)
        if(i GREATER ${MYOPT_AM})
            math(EXPR jmin "${i}-${MYOPT_AM}")
        else()
            set(jmin 0)
        endif()
        math(EXPR jmax "${i}/2")
        if(i EQUAL 0)
            set(kmin 1)
        else()
            set(kmin ${i})
        endif()
        if(NOT jmin GREATER jmax)
            foreach(j RANGE ${jmin} ${jmax} 1)
                list(GET AM ${j} am_j)
                math(EXPR reali "${i}-${j}")
                list(GET AM ${reali} am_i)
                foreach(k RANGE ${kmin} ${MYNEW_AM})
                    list(GET AM ${k} am_k)
                    if(k GREATER ${MYOPT_AM})
                        math(EXPR lmin "${k}-${MYOPT_AM}")
                    else()
                        set(lmin 0)
                    endif()
                    math(EXPR lmax "${k}/2")
                    if(NOT lmin GREATER lmax)
                        foreach(l RANGE ${lmin} ${lmax})
                            list(GET AM ${l} am_l)
                            math(EXPR realk "${k}-${l}")
                            list(GET AM ${realk} am_k)
                            set(TMPINTFILES ${TMPINTFILES} hrr_order_${am_i}${am_j}${am_k}${am_l}.cc)
                            set(TMPINTFILES ${TMPINTFILES} vrr_order_${am_i}${am_j}${am_k}${am_l}.cc)
                        endforeach()
                    endif()
                endforeach()
            endforeach()
        endif()
    endforeach()
    if(${ADDBUILD})
        # hrr1_build_XY.cc
        # hrr3_build_XY.cc
        foreach(i RANGE ${MYNEW_AM})
            math(EXPR jmax "(${i}+1)/2")
            if(jmax GREATER 0)
                foreach(j RANGE 1 ${jmax})
                    math(EXPR reali "${i}-${j}")
                    list(GET AM ${reali} am_i)
                    list(GET AM ${j} am_j)
                    set(TMPINTFILES ${TMPINTFILES} hrr1_build_${am_i}${am_j}.cc)
                    set(TMPINTFILES ${TMPINTFILES} hrr3_build_${am_i}${am_j}.cc)
                endforeach()
            endif()
        endforeach()
    endif()
    set(${MYINTFILES} ${TMPINTFILES})
    set(TMPINTFILES "")
endmacro(BUILD_LIBDERIV_FILES)
