//=======================================================================
// filestreeview.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef GPACO_FILES_TREE_VIEW_H
#define GPACO_FILES_TREE_VIEW_H

#include "pkg.h"
#include <iosfwd>
#include <vector>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include <gtkmm/uimanager.h>


namespace Gpaco
{

class FilesTreeView : public Gtk::TreeView
{
	class ModelColumns : public Gtk::TreeModel::ColumnRecord
	{
		friend class FilesTreeView;

		ModelColumns();

		Gtk::TreeModelColumn<File*>							mFile;
		Gtk::TreeModelColumn< Glib::RefPtr<Gdk::Pixbuf> >	mStatus;
		Gtk::TreeModelColumn<Glib::ustring>					mName;
		Gtk::TreeModelColumn<long>							mSize;

	};	// class FilesTreeView::ModelColumns

	enum { COL_STATUS, COL_NAME, COL_SIZE };

	enum {
		GZIP,
		BZIP2,
		UNCOMPRESS,
		STRIP_ALL,
		STRIP_DEBUG,
		STRIP_UNNEEDED
	};

	public:

	FilesTreeView(Pkg&);
	virtual ~FilesTreeView();

	virtual void writeLabel() const;
	void resetModel();
	
	private:

	typedef Gtk::TreeModel::iterator iterator;

	Gtk::Menu*							mpMenu;
	Glib::RefPtr<Gtk::UIManager>		mpUIManager;
	Glib::RefPtr<Gtk::ActionGroup>		mpActionGroup;
	Glib::RefPtr<Gtk::TreeSelection>	mpSelection;
	Pkg&							mPkg;
	ModelColumns					mColumns;
	Glib::RefPtr<Gtk::ListStore>	mpModelAll;
	Glib::RefPtr<Gtk::ListStore>	mpModelInst;
	Glib::RefPtr<Gtk::ListStore>	mpModelMiss;
	Glib::RefPtr<Gtk::ListStore>	mpModelEmpty;
	Glib::RefPtr<Gtk::ListStore>*	mppModel;
	Glib::RefPtr<Gtk::Action>		mpActionStrip;
	Glib::RefPtr<Gtk::Action>		mpActionCompress;
	Glib::RefPtr<Gtk::Action>		mpActionUncompress;
	Glib::RefPtr<Gtk::Action>		mpActionRemove;

	virtual bool on_button_press_event(GdkEventButton*);
	virtual bool on_key_press_event(GdkEventKey*);
		
	void selectAll();
	void unselectAll();
	bool onPopupMenu(GdkEvent*);

	long getSelected(std::vector<File*>&, long* size = NULL) const;
	void onRemove();
	void onDo(int);
	void setLabelText(Glib::ustring const&) const;

	int nameSortFunc(iterator const&, iterator const&);
	int sizeSortFunc(iterator const&, iterator const&);
	int statusSortFunc(iterator const&, iterator const&);
	void nameCellFunc(Gtk::CellRenderer*, iterator const&);
	void sizeCellFunc(Gtk::CellRenderer*, iterator const&);
	void statusCellFunc(Gtk::CellRenderer*, iterator const&);

	bool rowChanged(Gtk::TreeModel::Path const&, iterator const&);
	bool getIter(File const*, Glib::RefPtr<Gtk::ListStore>, iterator&) const;
	void getVisible(std::vector<File*>&);
	void setModel();

};	// class FilesTreeView

} // namespace Gpaco

#endif  // GPACO_FILES_TREE_VIEW_H
