/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _ASTBACKEND_GENERATION_VISITOR_H_
#define _ASTBACKEND_GENERATION_VISITOR_H_

#include "../AST/GenerationVisitor.h"

namespace ASTBackend {
  /**
    * @internal
    * @ingroup GTLCore_AST
    *
    * This class countains the information necesseray to generate code.
    * It is then subclassed by the backends.
    */
  class GTLCORE_TESTS_EXPORT GenerationVisitor : public GTLCore::AST::GenerationVisitor {
    protected:
      GenerationVisitor(const GenerationVisitor& );
      GenerationVisitor& operator=(const GenerationVisitor& );
    public:
      GenerationVisitor();
      virtual ~GenerationVisitor();
    public:
      virtual GTLCore::AST::ExpressionResultSP generateFloat32(float arg1, const GTLCore::AST::Annotation& _annotation);
      virtual GTLCore::AST::ExpressionResultSP generateInteger32(gtl_int32 arg1, const GTLCore::AST::Annotation& _annotation);
      virtual GTLCore::AST::ExpressionResultSP generateBoolean(bool arg1, const GTLCore::AST::Annotation& _annotation);
      virtual GTLCore::AST::ExpressionResultSP generateFunctionCall(GTLCore::Function* _function, const std::list<GTLCore::AST::ExpressionResultSP>& _arguments, const GTLCore::AST::Annotation& _annotation);
      virtual GTLCore::AST::ExpressionResultSP generateString(GTLCore::String arg1, const GTLCore::AST::Annotation& _annotation);
    public:
        virtual GTLCore::AST::ExpressionResultSP generateAndExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateOrExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateBitOrExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateBitXorExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateBitAndExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateEqualExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateDifferentExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateInferiorExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateInferiorEqualExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateSupperiorExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateSupperiorEqualExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateRightShiftExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateLeftShiftExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateAdditionExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateSubtractionExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateMultiplicationExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateDivisionExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateModuloExpresion(GTLCore::AST::ExpressionResultSP arg1, GTLCore::AST::ExpressionResultSP arg2, const GTLCore::AST::Annotation& _annotation);
    public:
        virtual GTLCore::AST::ExpressionResultSP generateTildExpression(GTLCore::AST::ExpressionResultSP arg1, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateMinusExpression(GTLCore::AST::ExpressionResultSP arg1, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP generateNotExpression(GTLCore::AST::ExpressionResultSP arg1, const GTLCore::AST::Annotation& _annotation);
      public: // Convert expression
        virtual GTLCore::AST::ExpressionResultSP convertExpressionTo(GTLCore::AST::ExpressionResultSP arg1, const GTLCore::Type* _type, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP convertArrayToVector(GTLCore::AST::ExpressionResultSP arg1, const GTLCore::Type* type, const GTLCore::AST::Annotation& _annotation);
        virtual GTLCore::AST::ExpressionResultSP createCompoundConstant(std::vector< GTLCore::AST::ExpressionResultSP> arg1, const GTLCore::Type*, const GTLCore::AST::Annotation& arg2);
        virtual GTLCore::AST::ExpressionResultSP createCompoundValue(std::vector< GTLCore::AST::ExpressionResultSP > arg1, const GTLCore::Type* type, const GTLCore::AST::Annotation& _annotation);
  };
}

#endif
