/*
* Copyright (c) 1997 - 2016
* Actelion Pharmaceuticals Ltd.
* Gewerbestrasse 16
* CH-4123 Allschwil, Switzerland
*
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
* 1. Redistributions of source code must retain the above copyright notice, this
*    list of conditions and the following disclaimer.
* 2. Redistributions in binary form must reproduce the above copyright notice,
*    this list of conditions and the following disclaimer in the documentation
*    and/or other materials provided with the distribution.
* 3. Neither the name of the the copyright holder nor the
*    names of its contributors may be used to endorse or promote products
*    derived from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

package com.actelion.research.jfx.gui.chem;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericPolygon;
import com.actelion.research.jfx.gui.GraphicsContextImpl;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;


/**
 * Project:
 * User: rufenec
 * Date: 10/12/11
 * Time: 6:00 PM
 */

public class JFXCanvasDepictor extends AbstractDepictor
{

    private GraphicsContext ctx = null;
    private Font currentFont = Font.font("Helvetica", 8);
    ;
    private double lineWidth = 1.0f;


    public JFXCanvasDepictor(StereoMolecule mol, int mode)
    {
        super(mol != null ? mol : new StereoMolecule());
        super.setDisplayMode(mode);
    }

    public JFXCanvasDepictor(StereoMolecule mol)
    {
        this(mol, 0);


    }

    protected void init() {
        super.init();
    }

    @Override
    public void paint(Object g)
    {
        if (g instanceof GraphicsContext) {
            ctx = (GraphicsContext) g;
        } else if (g instanceof GraphicsContextImpl) {
            ctx = ((GraphicsContextImpl) g).getContext();
        } else {
            throw new IllegalArgumentException("Need to pass a Canvas object " + g);
        }
        super.paint(g);
    }

    @Override
    protected void drawBlackLine(DepictorLine theLine)
    {
        ctx.save();
        ctx.setLineWidth(lineWidth);
        ctx.setLineCap(StrokeLineCap.ROUND);
        ctx.setLineJoin(StrokeLineJoin.MITER);
//        ctx.setStroke(colormap.color);
        ctx.beginPath();
        ctx.moveTo(theLine.x1, theLine.y1);
        ctx.lineTo(theLine.x2,theLine.y2);
        ctx.stroke();
//        ctx.strokeLine(theLine.x1, theLine.y1, theLine.x2, theLine.y2);
        ctx.restore();
    }

    @Override
    protected void drawDottedLine(DepictorLine theLine)
    {
        ctx.save();
//        ctx.setStroke(colormap.color);
        ctx.setLineCap(StrokeLineCap.ROUND);
        ctx.beginPath();
        ctx.moveTo(theLine.x1,theLine.y1);
        ctx.lineTo(theLine.x2,theLine.y2);
        ctx.stroke();
//        ctx.strokeLine(theLine.x1, theLine.y1, theLine.x2, theLine.y2);
        ctx.restore();
    }

    @Override
    protected void drawPolygon(GenericPolygon p)
    {
        ctx.save();
//        ctx.setStroke(colormap.color);
//        ctx.setFill(colormap.color);
        double[] x = new double[p.getSize()];
        double[] y = new double[p.getSize()];
        for (int i = 0; i < p.getSize(); i++) {
            x[i] = p.getX(i);
            y[i] = p.getY(i);
        }
        ctx.fillPolygon(x, y, p.getSize());
//        ctx.strokePolygon(x, y, count);
        ctx.restore();
    }

    @Override
    protected void drawString(String theString, double x, double y)
    {
        ctx.save();
        ctx.setFont(currentFont);
        ctx.setTextAlign(TextAlignment.CENTER);
        ctx.setTextBaseline(VPos.CENTER);
//        ctx.setFill(colormap.color);
        ctx.fillText(theString, x, y);
        ctx.restore();
    }

    private Bounds getBounds(String s)
    {
        Text t = new Text(s);
        t.setFont(currentFont);
        return t.getLayoutBounds();
    }

    @Override
    protected void fillCircle(double x, double y, double r)
    {
        ctx.save();
//        if (colormap != null) {
//            ctx.setFill(colormap.color);
//        }
        ctx.fillArc(
            (double) x, (double) y,
            (double) r, (double) r, (double) 0,
            (double) 360, ArcType.ROUND);
        ctx.restore();
    }


    @Override
    protected double getStringWidth(String theString)
    {
//        Trace.trace(theString);
        return (double) getBounds(theString).getWidth();
    }

    @Override
    protected int getTextSize()
    {
        return (int) currentFont.getSize();
    }

    @Override
    protected void setTextSize(int theSize)
    {
        currentFont = Font.font("Helvetica", theSize);
    }

    @Override
    protected void setLineWidth(double lineWidth)
    {
        this.lineWidth = lineWidth;
    }

    @Override
    protected double getLineWidth()
    {
        return lineWidth;
    }


    @Override
    protected void setRGB(int rgb)
    {
        if (ctx != null) {
            Color color = new Color(((rgb & 0x00FF0000) >> 16) / 255.0, ((rgb & 0x0000FF00) >> 8) / 255.0, (rgb & 0x000000FF) / 255.0, 1.0);
            ctx.setStroke(color);
            ctx.setFill(color);
        }
         //colormap = getColor(theColor);
    }
}
