// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom2dGcc_Circ2d3Tan_HeaderFile
#define _Geom2dGcc_Circ2d3Tan_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _TColgp_Array1OfCirc2d_HeaderFile
#include <TColgp_Array1OfCirc2d.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _GccEnt_Array1OfPosition_HeaderFile
#include <GccEnt_Array1OfPosition.hxx>
#endif
#ifndef _TColStd_Array1OfInteger_HeaderFile
#include <TColStd_Array1OfInteger.hxx>
#endif
#ifndef _TColgp_Array1OfPnt2d_HeaderFile
#include <TColgp_Array1OfPnt2d.hxx>
#endif
#ifndef _TColStd_Array1OfReal_HeaderFile
#include <TColStd_Array1OfReal.hxx>
#endif
#ifndef _Handle_Geom2d_Point_HeaderFile
#include <Handle_Geom2d_Point.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _GccEnt_Position_HeaderFile
#include <GccEnt_Position.hxx>
#endif
class StdFail_NotDone;
class Standard_OutOfRange;
class Geom2dGcc_QualifiedCurve;
class Geom2d_Point;
class GccAna_Circ2d3Tan;
class gp_Circ2d;
class gp_Pnt2d;


//! This class implements the algorithms used to <br>
//!          create 2d circles tangent to 3 points/lines/circles/ <br>
//!          curves with one curve or more. <br>
//!          The arguments of all construction methods are : <br>
//!             - The three qualifiied elements for the <br>
//!             tangency constrains (QualifiedCirc, QualifiedLine, <br>
//!             Qualifiedcurv, Points). <br>
//!             - A parameter for each QualifiedCurv. <br>
//!          Describes functions for building a 2D circle: <br>
//!          -   tangential to 3 curves, or <br>
//!          -   tangential to 2 curves and passing through a point, or <br>
//!          -   tangential to a curve and passing through 2 points, or <br>
//!          -   passing through 3 points. <br>
//!          A Circ2d3Tan object provides a framework for: <br>
//!          -   defining the construction of 2D circles(s), <br>
//!          -   implementing the construction algorithm, and <br>
//!          -   consulting the result(s). <br>
class Geom2dGcc_Circ2d3Tan  {
public:

  DEFINE_STANDARD_ALLOC

  //! Constructs one or more 2D circles <br>
//!   tangential to three curves Qualified1, Qualified2 and <br>
//!   Qualified3, where Param1, Param2 and Param3 are <br>
//!   used, respectively, as the initial values of the <br>
//!   parameters on Qualified1, Qualified2 and Qualified3 <br>
//!   of the tangency point between these arguments and <br>
//!   the solution sought, if the algorithm chooses an <br>
//!   iterative method to find the solution (i.e. if either <br>
//!   Qualified1, Qualified2 or Qualified3 is more complex <br>
//!   than a line or a circle). <br>
  Standard_EXPORT   Geom2dGcc_Circ2d3Tan(const Geom2dGcc_QualifiedCurve& Qualified1,const Geom2dGcc_QualifiedCurve& Qualified2,const Geom2dGcc_QualifiedCurve& Qualified3,const Standard_Real Tolerance,const Standard_Real Param1,const Standard_Real Param2,const Standard_Real Param3);
  //! Constructs one or more 2D circles <br>
//! tangential to two curves Qualified1 and Qualified2 <br>
//!   and passing through the point Point, where Param1 <br>
//!   and Param2 are used, respectively, as the initial <br>
//!   values of the parameters on Qualified1 and <br>
//!   Qualified2 of the tangency point between this <br>
//!   argument and the solution sought, if the algorithm <br>
//!   chooses an iterative method to find the solution (i.e. if <br>
//!   either Qualified1 or Qualified2 is more complex than <br>
//!   a line or a circle). <br>
  Standard_EXPORT   Geom2dGcc_Circ2d3Tan(const Geom2dGcc_QualifiedCurve& Qualified1,const Geom2dGcc_QualifiedCurve& Qualified2,const Handle(Geom2d_Point)& Point,const Standard_Real Tolerance,const Standard_Real Param1,const Standard_Real Param2);
  //! Constructs one or more 2D circles tangential to the curve Qualified1 and passing <br>
//!  through two points Point1 and Point2, where Param1 <br>
//!  is used as the initial value of the parameter on <br>
//!  Qualified1 of the tangency point between this <br>
//!  argument and the solution sought, if the algorithm <br>
//!   chooses an iterative method to find the solution (i.e. if <br>
//!   Qualified1 is more complex than a line or a circle) <br>
  Standard_EXPORT   Geom2dGcc_Circ2d3Tan(const Geom2dGcc_QualifiedCurve& Qualified1,const Handle(Geom2d_Point)& Point1,const Handle(Geom2d_Point)& Point2,const Standard_Real Tolerance,const Standard_Real Param1);
  //! Constructs one or more 2D circles passing through three points Point1, Point2 and Point3. <br>
//! Tolerance is a tolerance criterion used by the algorithm <br>
//! to find a solution when, mathematically, the problem <br>
//! posed does not have a solution, but where there is <br>
//! numeric uncertainty attached to the arguments. <br>
//! For example, take: <br>
//! -   two circles C1 and C2, such that C2 is inside C1, <br>
//!   and almost tangential to C1; there is in fact no point <br>
//!   of intersection between C1 and C2; and <br>
//! -   a circle C3 outside C1. <br>
//! You now want to find a circle which is tangential to C1, <br>
//! C2 and C3: a pure mathematical resolution will not find <br>
//! a solution. This is where the tolerance criterion is used: <br>
//! the algorithm considers that C1 and C2 are tangential if <br>
//! the shortest distance between these two circles is less <br>
//! than or equal to Tolerance. Thus, the algorithm finds a solution. <br>
//! Warning <br>
//! An iterative algorithm is used if Qualified1, Qualified2 or <br>
//! Qualified3 is more complex than a line or a circle. In <br>
//! such cases, the algorithm constructs only one solution. <br>
//! Exceptions <br>
//! GccEnt_BadQualifier if a qualifier is inconsistent with <br>
//! the argument it qualifies (for example, enclosing for a line). <br>
  Standard_EXPORT   Geom2dGcc_Circ2d3Tan(const Handle(Geom2d_Point)& Point1,const Handle(Geom2d_Point)& Point2,const Handle(Geom2d_Point)& Point3,const Standard_Real Tolerance);
  
  Standard_EXPORT     void Results(const GccAna_Circ2d3Tan& Circ,const Standard_Integer Rank1,const Standard_Integer Rank2,const Standard_Integer Rank3) ;
  //! Returns true if the construction algorithm does not fail (even if it finds no solution). <br>
//! Note: IsDone protects against a failure arising from a <br>
//! more internal intersection algorithm, which has reached its numeric limits. <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;
  //! This method returns the number of solutions. <br>
//!          NotDone is raised if the algorithm failed. <br>
  Standard_EXPORT     Standard_Integer NbSolutions() const;
  //! Returns the solution number Index and raises OutOfRange <br>
//! exception if Index is greater than the number of solutions. <br>
//! Be carefull: the Index is only a way to get all the <br>
//! solutions, but is not associated to theses outside the context <br>
//! of the algorithm-object. <br>
  Standard_EXPORT     gp_Circ2d ThisSolution(const Standard_Integer Index) const;
  //! It returns the informations about the qualifiers of the tangency <br>
//!          arguments concerning the solution number Index. <br>
//!          It returns the real qualifiers (the qualifiers given to the <br>
//!          constructor method in case of enclosed, enclosing and outside <br>
//!          and the qualifiers computedin case of unqualified). <br>
  Standard_EXPORT     void WhichQualifier(const Standard_Integer Index,GccEnt_Position& Qualif1,GccEnt_Position& Qualif2,GccEnt_Position& Qualif3) const;
  //! Returns informations about the tangency point between the <br>
//! result and the first argument. <br>
//! ParSol is the intrinsic parameter of the point PntSol on the solution curv. <br>
//! ParArg is the intrinsic parameter of the point PntSol on the argument curv. <br>
  Standard_EXPORT     void Tangency1(const Standard_Integer Index,Standard_Real& ParSol,Standard_Real& ParArg,gp_Pnt2d& PntSol) const;
  //! Returns informations about the tangency point between the <br>
//! result and the second argument. <br>
//! ParSol is the intrinsic parameter of the point PntSol on the solution curv. <br>
//! ParArg is the intrinsic parameter of the point PntSol on the argument curv. <br>
  Standard_EXPORT     void Tangency2(const Standard_Integer Index,Standard_Real& ParSol,Standard_Real& ParArg,gp_Pnt2d& PntSol) const;
  //! Returns informations about the tangency point between the <br>
//! result and the third argument. <br>
//! ParSol is the intrinsic parameter of the point PntSol on the solution curv. <br>
//! ParArg is the intrinsic parameter of the point PntSol on the argument curv. <br>
  Standard_EXPORT     void Tangency3(const Standard_Integer Index,Standard_Real& ParSol,Standard_Real& ParArg,gp_Pnt2d& PntSol) const;
  //! Returns True if the solution is equal to the first argument. <br>
  Standard_EXPORT     Standard_Boolean IsTheSame1(const Standard_Integer Index) const;
  //! Returns True if the solution is equal to the second argument. <br>
  Standard_EXPORT     Standard_Boolean IsTheSame2(const Standard_Integer Index) const;
  //!  Returns True if the solution is equal to the third argument. <br>
//! If Rarg is the radius of the first, second or third <br>
//! argument, Rsol is the radius of the solution and dist <br>
//! is the distance between the two centers, we consider <br>
//! the two circles to be identical if |Rarg - Rsol| and <br>
//! dist are less than or equal to the tolerance criterion <br>
//! given at the time of construction of this algorithm. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is less than zero or <br>
//! greater than the number of solutions computed by this algorithm. <br>
//! StdFail_NotDone if the construction fails. <br>
  Standard_EXPORT     Standard_Boolean IsTheSame3(const Standard_Integer Index) const;





protected:





private:



TColgp_Array1OfCirc2d cirsol;
Standard_Real NbrSol;
Standard_Boolean WellDone;
GccEnt_Array1OfPosition qualifier1;
GccEnt_Array1OfPosition qualifier2;
GccEnt_Array1OfPosition qualifier3;
TColStd_Array1OfInteger TheSame1;
TColStd_Array1OfInteger TheSame2;
TColStd_Array1OfInteger TheSame3;
TColgp_Array1OfPnt2d pnttg1sol;
TColgp_Array1OfPnt2d pnttg2sol;
TColgp_Array1OfPnt2d pnttg3sol;
TColStd_Array1OfReal par1sol;
TColStd_Array1OfReal par2sol;
TColStd_Array1OfReal par3sol;
TColStd_Array1OfReal pararg1;
TColStd_Array1OfReal pararg2;
TColStd_Array1OfReal pararg3;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
