/*
 * Decompiled with CFR 0.152.
 */
package gov.pnnl.bse.nwchem;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.security.auth.DialogAuthListener;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import java.io.File;
import java.io.FileWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.axis.client.Call;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.BasisSetBrowse;
import org.scidac.cmcs.tools.bse.BasisSetDescriptor;
import org.scidac.cmcs.tools.bse.BseCall;

public class BseNWChem {
    protected static final String SAMSERVER = "https://bse.pnl.gov/sam";

    public static void main(String[] args) {
        String DATADIR = "bsedata";
        Vector errors = new Vector();
        DialogAuthListener dal = new DialogAuthListener();
        BSEProperties props = BSEProperties.getBSEProperties();
        String gaussianUrl = props.getProperty("BseDataServer") + props.getProperty("Gaussian");
        System.out.println("Gettng basis set info from:\n\t" + gaussianUrl);
        DSI dsi = new DSI(gaussianUrl, dal);
        String hostIp = "0.0.0.0";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostIp = addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            System.out.println("Can't get host ip.");
        }
        BseNWChem.retreiveOrbitalsOnly(DATADIR, props, hostIp, errors, dsi);
        BseNWChem.retreiveECPsOnly(DATADIR, props, hostIp, errors, dsi);
        if (errors.size() > 0) {
            System.out.println("Errors occurred while retrieving the following basis sets: ");
            Iterator errIter = errors.iterator();
            while (errIter.hasNext()) {
                System.out.println("   " + (String)errIter.next());
            }
        }
        System.exit(0);
    }

    public static String convertBsNameToNWChem(String bsName) {
        String newName = bsName.toLowerCase();
        if (newName.indexOf(42) >= 0) {
            newName = newName.replace('*', 's');
        }
        if (newName.indexOf(40) >= 0) {
            newName = newName.replaceAll("\\(", "");
        }
        if (newName.indexOf(41) >= 0) {
            newName = newName.replaceAll("\\)", "");
        }
        if (newName.indexOf(" ") >= 0) {
            newName = newName.replaceAll(" ", "_");
        }
        if (newName.indexOf(",") >= 0) {
            newName = newName.replaceAll(",", "_");
        }
        if (newName.indexOf("/") >= 0) {
            newName = newName.replaceAll("/", "_");
        }
        return newName;
    }

    protected static void retreiveOrbitalsOnly(String DATADIR, BSEProperties props, String hostIp, Vector errors, DSI dsi) {
        try {
            Hashtable bsList = null;
            Vector formats = new Vector();
            Vector returnProps = props.getPropertyAsNSPropertyVector("PropertyList");
            Vector<NSProperty> searchProps = new Vector<NSProperty>();
            searchProps.add(new NSProperty("http://purl.org/dc/elements/1.1/:format"));
            bsList = dsi.searchMetaData(returnProps, searchProps, Integer.MAX_VALUE, "chemical/x-emsl-gaussian-basisset");
            BasisSetBrowse bsbrowse = new BasisSetBrowse(0, bsList);
            int total = 0;
            for (BasisSetDescriptor desc : bsbrowse.getBasisSets()) {
                if (!desc.getCurationStatus().equals("published")) continue;
                ++total;
            }
            File dir = new File(DATADIR + "/orbitals");
            boolean status = dir.mkdirs();
            int counter = 0;
            for (BasisSetDescriptor desc : bsbrowse.getBasisSets()) {
                if (!desc.getCurationStatus().equals("published")) continue;
                ++counter;
                Iterator eltItor = desc.getElts().iterator();
                String bsElts = "";
                if (eltItor.hasNext()) {
                    bsElts = (String)eltItor.next();
                }
                while (eltItor.hasNext()) {
                    String elt = (String)eltItor.next();
                    bsElts = bsElts + " " + elt;
                }
                String fileName = dir.getAbsolutePath() + File.separator + BseNWChem.convertBsNameToNWChem(desc.getName());
                System.out.println("Getting file " + fileName);
                try {
                    Call call = BseCall.getCall("getBasisSetNwchem");
                    String bsdata = (String)call.invoke(new Object[]{SAMSERVER + desc.getUrl(), "true", bsElts, "nwchem-library", "lisong.sun@pnl.gov", "Lisong Sun", hostIp, "false"});
                    System.out.println("Saving file (" + Integer.toString(counter) + " of " + Integer.toString(total) + "): \t" + fileName);
                    FileWriter fw = new FileWriter(fileName);
                    fw.write(bsdata);
                    fw.close();
                }
                catch (Exception e) {
                    System.out.println("Error retrieving file.");
                    e.printStackTrace();
                    errors.add(fileName);
                }
            }
            System.out.println(counter);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            System.out.println(LoggerUtils.getStackTrace(ex));
        }
    }

    protected static void retreiveECPsOnly(String DATADIR, BSEProperties props, String hostIp, Vector errors, DSI dsi) {
        try {
            Hashtable bsList = null;
            Vector formats = new Vector();
            Vector returnProps = props.getPropertyAsNSPropertyVector("PropertyList");
            Vector<NSProperty> searchProps = new Vector<NSProperty>();
            searchProps.add(new NSProperty("http://purl.org/dc/elements/1.1/:format"));
            bsList = dsi.searchMetaData(returnProps, searchProps, Integer.MAX_VALUE, "chemical/x-emsl-ecp");
            BasisSetBrowse bsbrowse = new BasisSetBrowse(0, bsList);
            int total = 0;
            for (BasisSetDescriptor desc : bsbrowse.getBasisSets()) {
                if (!desc.getCurationStatus().equals("published")) continue;
                ++total;
            }
            File dir = new File(DATADIR + "/ecps");
            boolean status = dir.mkdirs();
            int counter = 0;
            for (BasisSetDescriptor desc : bsbrowse.getBasisSets()) {
                if (!desc.getCurationStatus().equals("published")) continue;
                ++counter;
                Iterator eltItor = desc.getElts().iterator();
                String bsElts = "";
                if (eltItor.hasNext()) {
                    bsElts = (String)eltItor.next();
                }
                while (eltItor.hasNext()) {
                    String elt = (String)eltItor.next();
                    bsElts = bsElts + " " + elt;
                }
                String fileName = dir.getAbsolutePath() + File.separator + BseNWChem.convertBsNameToNWChem(desc.getName());
                System.out.println("Getting file " + fileName);
                try {
                    Call call = BseCall.getCall("getBasisSetNwchem");
                    String bsdata = (String)call.invoke(new Object[]{SAMSERVER + desc.getUrl(), "true", bsElts, "nwchem-library-ecp", "lisong.sun@pnl.gov", "Lisong Sun", hostIp, "false"});
                    System.out.println("Saving file (" + Integer.toString(counter) + " of " + Integer.toString(total) + "): \t" + fileName);
                    FileWriter fw = new FileWriter(fileName);
                    fw.write(bsdata);
                    fw.close();
                }
                catch (Exception e) {
                    System.out.println("Error retrieving file.");
                    errors.add(fileName);
                }
            }
            System.out.println(counter);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            System.out.println(LoggerUtils.getStackTrace(ex));
        }
    }
}

