/* NVTV Conexant chip data header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: data_cx.h,v 1.11 2002/11/13 17:13:21 dthierbach Exp $
 *
 * Contents:
 *
 * Header: Data tables and setup routines for the Conexant chip.
 */ 

#ifndef _DATA_CX_H
#define _DATA_CX_H

#include "tv_chip.h"
#include "data.h"

void data_init_cx (TVSystem system, TVCxRegs *r, int btmode);

void data_default_cx (TVSettings *s);
void data_clamp_cx (TVSettings *s, TVRegs *r);
void data_setup_cx (TVSettings *s, TVRegs *r);

void data_secam_cx (TVCxRegs *r);

TVCxRegs cx_ntsc_xbox;     /* XBox BIOS */

TVCxRegs cx_ntsc_small_a;  /* Mode 10, hoc=15.11 voc=14.81 */
TVCxRegs cx_ntsc_normal_a; /* Mode 26, hoc=11.97 voc=11.93 */
TVCxRegs cx_ntsc_tiny_a;   /* Mode 42, hoc=18.04 voc=18.11 */
TVCxRegs cx_ntsc_small_b;  /* Mode 18, hoc=13.79 voc=13.58 */
TVCxRegs cx_ntsc_tiny_b;   /* Mode 34, hoc=19.26 voc=19.34 */
TVCxRegs cx_ntsc_mini_b;   /* Mode 40, hoc=15.59 voc=15.64 */

TVCxRegs cx_pal_small_a;   /* Mode 11, hoc=13.44 voc=14.24 */
TVCxRegs cx_pal_mini_a;    /* Mode 43, hoc=16.20 voc=16.67 */

#endif /* _DATA_CX_H */
