/*
 * Copyright 2013 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QObject>
#include <QStringList>

#include "QNetworkReply"

/**
 * This class is a mock class for
 * http://qt-project.org/doc/qt-5.0/qtnetwork/qnetworkaccessmanager.html
 */
class QNetworkAccessManager : public QObject
{
    Q_OBJECT

public:
    QNetworkAccessManager(QObject* parent = 0);
    QNetworkReply* get(QNetworkRequest request);

    static QStringList& log() {
        static QStringList requestLog;
        return requestLog;
    }
};

