title: HTTP Server Security Vulnerability: Please upgrade to 0.6.17
author: Isaac Schlueter
date: Mon May 07 2012 10:02:01 GMT-0700 (PDT)
status: publish
category: vulnerability
slug: http-server-security-vulnerability-please-upgrade-to-0-6-17

<h2>tl;dr</h2>

<ul><li><p>A carefully crafted attack request can cause the contents of the HTTP parser's buffer to be appended to the attacking request's header, making it appear to come from the attacker.  Since it is generally safe to echo back contents of a request, this can allow an attacker to get an otherwise correctly designed server to divulge information about other requests.  It is theoretically possible that it could enable header-spoofing attacks, though such an attack has not been demonstrated.</li>
<li>Versions affected: All versions of the 0.5/0.6 branch prior to 0.6.17, and all versions of the 0.7 branch prior to 0.7.8.  Versions in the 0.4 branch are not affected.</li>
<li>Fix: Upgrade to <a href="http://blog.nodejs.org/2012/05/04/version-0-6-17-stable/">v0.6.17</a>, or apply the fix in <a href="https://github.com/joyent/node/commit/c9a231d">c9a231d</a> to your system.</li></ul>

<h2>Details</h2>

<p>A few weeks ago, Matthew Daley found a security vulnerability in Node&#39;s HTTP implementation, and thankfully did the responsible thing and reported it to us via email.  He explained it quite well, so I'll quote him here:</p>
<blockquote>
<p>There is a vulnerability in node&#39;s `http_parser` binding which allows information disclosure to a remote attacker:

</p>
<p>In node::StringPtr::Update, an attempt is made at an optimization on certain inputs (`node_http_parser.cc`, line 151). The intent is that if the current string pointer plus the current string size is equal to the incoming string pointer, the current string size is just increased to match, as the incoming string lies just beyond the current string pointer. However, the check to see whether or not this can be done is incorrect; &quot;size&quot; is used whereas &quot;size_&quot; should be used. Therefore, an attacker can call Update with a string of certain length and cause the current string to have other data appended to it. In the case of HTTP being parsed out of incoming socket data, this can be incoming data from other sockets.

</p>
<p>Normally node::StringPtr::Save, which is called after each execution of `http_parser`, would stop this from being exploitable as it converts strings to non-optimizable heap-based strings. However, this is not done to 0-length strings. An attacker can therefore exploit the mistake by making Update set a 0-length string, and then Update past its boundary, so long as it is done in one `http_parser` execution. This can be done with an HTTP header with empty value, followed by a continuation with a value of certain length.

</p>
<p>The <a href="https://gist.github.com/2628868">attached files</a> demonstrate the issue:  </p>
<pre><code>$ ./node ~/stringptr-update-poc-server.js &amp;
[1] 11801
$ ~/stringptr-update-poc-client.py
HTTP/1.1 200 OK
Content-Type: text/plain
Date: Wed, 18 Apr 2012 00:05:11 GMT
Connection: close
Transfer-Encoding: chunked

64
X header:
 This is private data, perhaps an HTTP request with a Cookie in it.
0</code></pre>
</blockquote>
<p>The fix landed on <a href="https://github.com/joyent/node/commit/7b3fb22">7b3fb22</a> and <a href="https://github.com/joyent/node/commit/c9a231d">c9a231d</a>, for master and v0.6, respectively.  The innocuous commit message does not give away the security implications, precisely because we wanted to get a fix out before making a big deal about it.  </p>
<p>The first releases with the fix are v0.7.8 and 0.6.17.  So now is a good time to make a big deal about it.  </p>
<p>If you are using node version 0.6 in production, please upgrade to at least <a href="http://blog.nodejs.org/2012/05/04/version-0-6-17-stable/">v0.6.17</a>, or at least apply the fix in <a href="https://github.com/joyent/node/commit/c9a231d">c9a231d</a> to your system. (Version 0.6.17 also fixes some other important bugs, and is without doubt the most stable release of Node 0.6 to date, so it&#39;s a good idea to upgrade anyway.)  </p>
<p>I&#39;m extremely grateful that Matthew took the time to report the problem to us with such an elegant explanation, and in such a way that we had a reasonable amount of time to fix the issue before making it public. </p>
