---
id: fast-foundation.matchmediastylesheetbehavior.with
title: MatchMediaStyleSheetBehavior.with() method
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [MatchMediaStyleSheetBehavior](./fast-foundation.matchmediastylesheetbehavior.md) &gt; [with](./fast-foundation.matchmediastylesheetbehavior.with.md)

## MatchMediaStyleSheetBehavior.with() method

Defines a function to construct [MatchMediaStyleSheetBehaviors](./fast-foundation.matchmediastylesheetbehavior.md) for a provided query.

<b>Signature:</b>

```typescript
static with(query: MediaQueryList): (styles: ElementStyles) => MatchMediaStyleSheetBehavior;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  query | MediaQueryList | The media query to operate from. |

<b>Returns:</b>

(styles: [ElementStyles](./fast-element.elementstyles.md)<!-- -->) =&gt; [MatchMediaStyleSheetBehavior](./fast-foundation.matchmediastylesheetbehavior.md)

## Example


```ts
import { css } from "@microsoft/fast-element";
import { MatchMediaStyleSheetBehavior } from "@microsoft/fast-foundation";

const landscapeBehavior = MatchMediaStyleSheetBehavior.with(
  window.matchMedia("(orientation: landscape)")
);
const styles = css`
  :host {
    width: 200px;
    height: 400px;
  }
`
.withBehaviors(landscapeBehavior(css`
  :host {
    width: 400px;
    height: 200px;
  }
`))

```
