/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Value;

public class SingletonItem
extends Value
implements GroundedValue {
    protected Item item = null;

    public SingletonItem(Item item) {
        this.item = item;
    }

    public Item asItem() {
        return this.item;
    }

    public void process(XPathContext context) throws XPathException {
        if (this.item != null) {
            context.getReceiver().append(this.item, 0, 2);
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)this.item;
            switch (node.getNodeKind()) {
                case 9: {
                    NodeInfo n;
                    AxisIterator iter = node.iterateAxis((byte)3);
                    ItemType elementType = null;
                    while ((n = (NodeInfo)iter.next()) != null) {
                        int kind = n.getNodeKind();
                        if (kind == 3) {
                            elementType = null;
                            break;
                        }
                        if (kind != 1) continue;
                        if (elementType != null) {
                            elementType = null;
                            break;
                        }
                        elementType = new SingletonItem(n).getItemType(th);
                    }
                    if (elementType == null) {
                        return NodeKindTest.DOCUMENT;
                    }
                    return new DocumentNodeTest((NodeTest)elementType);
                }
                case 1: {
                    int eltype = node.getTypeAnnotation();
                    if (eltype == -1 || eltype == 630 || eltype == 572) {
                        return new NameTest(1, node.getFingerprint(), node.getNamePool());
                    }
                    return new CombinedNodeTest(new NameTest(1, node.getFingerprint(), node.getNamePool()), 23, new ContentTypeTest(1, node.getConfiguration().getSchemaType(eltype), node.getConfiguration()));
                }
                case 2: {
                    int attype = node.getTypeAnnotation();
                    if (attype == -1 || attype == 631) {
                        return new NameTest(2, node.getFingerprint(), node.getNamePool());
                    }
                    return new CombinedNodeTest(new NameTest(2, node.getFingerprint(), node.getNamePool()), 23, new ContentTypeTest(2, node.getConfiguration().getSchemaType(attype), node.getConfiguration()));
                }
                case 3: {
                    return NodeKindTest.TEXT;
                }
                case 8: {
                    return NodeKindTest.COMMENT;
                }
                case 7: {
                    return NodeKindTest.PROCESSING_INSTRUCTION;
                }
                case 13: {
                    return NodeKindTest.NAMESPACE;
                }
            }
            throw new IllegalArgumentException("Unknown node kind " + node.getNodeKind());
        }
        if (this.item instanceof FunctionItem) {
            return ((FunctionItem)this.item).getFunctionItemType();
        }
        return ((AtomicValue)this.item).getTypeLabel();
    }

    public int getCardinality() {
        if (this.item == null) {
            return 8192;
        }
        return 16384;
    }

    public int getLength() throws XPathException {
        return this.item == null ? 0 : 1;
    }

    public Item itemAt(int n) {
        if (n == 0 && this.item != null) {
            return this.item;
        }
        return null;
    }

    public GroundedValue subsequence(int start, int length) {
        if (this.item != null && start <= 0 && start + length > 0) {
            return this;
        }
        return EmptySequence.getInstance();
    }

    public Item getItem() {
        return this.item;
    }

    public SequenceIterator iterate() {
        return SingletonIterator.makeIterator(this.item);
    }

    public boolean effectiveBooleanValue() {
        return this.item != null;
    }

    public String getStringValue() {
        return this.item == null ? "" : this.item.getStringValue();
    }
}

