/* 
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#ifndef _WF_LISTBOX_H_
#define _WF_LISTBOX_H_

using namespace System;
using namespace Drawing;
using namespace Windows::Forms;

namespace MySQL {
  namespace Forms {

    public ref class ListBoxImpl : public ViewImpl
    {
    protected:
      static bool create(mforms::ListBox *self, bool multi_select);
      static void clear(mforms::ListBox *self);
      static void set_heading(mforms::ListBox *self, const std::string &text);
      static void add_items(mforms::ListBox *self, const std::list<std::string> &items);
      static int add_item(mforms::ListBox *self, const std::string &item);
      static std::string get_text(mforms::ListBox *self);
      static void set_index(mforms::ListBox *self, int index);
      static int get_index(mforms::ListBox *self);
      static std::vector<int> get_selected_indices(mforms::ListBox *self);

      static void selection_changed(System::Object ^sender, System::EventArgs ^e);

    public:
      ListBoxImpl(mforms::ListBox *self);

      void clear();
      void set_heading(const std::string &text);
      void add_items(const std::list<std::string> &items);
      int add_item(const std::string &item);
      std::string get_text();
      void set_index(int index);
      int get_index();
      std::vector<int> get_selected_indices();

      static void init(Manager ^mgr)
      {
        mforms::ControlFactory *f= mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, mforms::ListBox*, bool, mgr, f->_listbox_impl, ListBoxImpl, create);
        DEF_CALLBACK1(void, mforms::ListBox*, mgr, f->_listbox_impl, ListBoxImpl, clear);
        DEF_CALLBACK2(void, mforms::ListBox*, const std::string&, mgr, f->_listbox_impl, ListBoxImpl, set_heading);
        DEF_CALLBACK2(void, mforms::ListBox*, const std::list<std::string>&, mgr, f->_listbox_impl, ListBoxImpl, add_items);
        DEF_CALLBACK2(int, mforms::ListBox*, const std::string&, mgr, f->_listbox_impl, ListBoxImpl, add_item);
        DEF_CALLBACK1(std::string, mforms::ListBox*, mgr, f->_listbox_impl, ListBoxImpl, get_text);
        DEF_CALLBACK2(void, mforms::ListBox*, int, mgr, f->_listbox_impl, ListBoxImpl, set_index);
        DEF_CALLBACK1(int, mforms::ListBox*, mgr, f->_listbox_impl, ListBoxImpl, get_index);
        DEF_CALLBACK1(std::vector<int>, mforms::ListBox*, mgr, f->_listbox_impl, ListBoxImpl, get_selected_indices);
      }
    };
  }
}

#endif // _WF_LISTBOX_H_