/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the demos of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "TitleBar.h"

#include <QtCore>
#include <QtGui>

TitleBar::TitleBar(QWidget *parent)
    : QWidget(parent)
    , m_progress(0)
    , curOpacity(1.0)
{
    m_timeLine = new QTimeLine(1000, this);
    m_timeLine->setCurveShape(QTimeLine::EaseInCurve);

    startHideTimer.setSingleShot(true);

    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);

    QTimer::singleShot(0, this, SLOT(initialize()));
}

void TitleBar::initialize()
{
    connect(&startHideTimer, SIGNAL(timeout()), this, SLOT(slotStartHiding()));
    connect(m_timeLine, SIGNAL(frameChanged(int)), SLOT(slide(int)));
}

void TitleBar::slide(int pos)
{
    move (defPos.x(), pos);
    update();
}

void TitleBar::setHost(const QString &host)
{
    m_host = host;
    update();
}

void TitleBar::setTitle(const QString &title)
{
    m_title = title;
    update();
}

void TitleBar::setProgress(int percent)
{
    m_progress = percent;
    if (m_progress == 0) {
        startHideTimer.start(1000);
    } else {
        startHideTimer.stop();
        move(defPos);
    }

    update();
}

void TitleBar::slotStartHiding()
{
    if (m_progress == 0 && m_timeLine->state() != QTimeLine::Running) {
        m_timeLine->setFrameRange(defPos.y(), defPos.y() - height());
        m_timeLine->start();
    }
}

QSize TitleBar::sizeHint() const
{
    return minimumSizeHint();
}

QSize TitleBar::minimumSizeHint() const
{
    QFontMetrics fm = fontMetrics();
    return QSize(100, fm.height());
}

void TitleBar::paintEvent(QPaintEvent *event)
{
    QString title = m_host;
    if (!m_title.isEmpty())
        title.append(": ").append(m_title);

    QPalette pal = palette();
    QPainter p(this);

    if (m_progress > 0) {

        p.fillRect(event->rect(), pal.color(QPalette::Highlight));

        QRect box = rect();
        box.setLeft(16);
        box.setWidth(width() - box.left() - 110);

        p.setPen(pal.color(QPalette::HighlightedText));
        p.setOpacity(0.8);
        p.drawText(box, Qt::AlignLeft + Qt::AlignVCenter, title);

        int x = width() - 100 - 5;
        int y = 1;
        int h = height() - 4;

        p.setOpacity(1.0);
        p.setBrush(Qt::NoBrush);
        p.setPen(pal.color(QPalette::HighlightedText));
        p.drawRect(x, y, 100, h);
        p.setPen(Qt::NoPen);
        p.setBrush(pal.color(QPalette::HighlightedText));
        p.drawRect(x, y, m_progress, h);
    } else {
        p.setOpacity(curOpacity);

        p.fillRect(event->rect(), pal.color(QPalette::Highlight));

        QRect box = rect();
        box.setLeft(16);
        box.setWidth(width() - box.left() - 5);
        p.setPen(pal.color(QPalette::HighlightedText));
        p.drawText(box, Qt::AlignLeft + Qt::AlignVCenter, title);
    }

    p.end();
}

//void TitleBar::mousePressEvent (QMouseEvent * event)
//{
//	if (m_timeLine->state() == QTimeLine::Running)
//		m_timeLine->stop();
//	m_timeLine->setDuration(500);
//	m_timeLine->setFrameRange(90, 1);
//	m_timeLine->start();
//
//	event->ignore();
//}
//
//void TitleBar::mouseReleaseEvent (QMouseEvent * event)
//{
//	if (m_timeLine->state() == QTimeLine::Running)
//		m_timeLine->stop();
//	m_timeLine->setDuration(500);
//	m_timeLine->setFrameRange(1, 90);
//	m_timeLine->start();
//
//	event->ignore();
//}
//
